/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import org.json.JSONObject;

class UploadData {
    final long offset;
    final int size;
    final int index;
    String md5;
    String etag;
    private State state;
    private long uploadSize = 0L;
    byte[] data;

    UploadData(long offset, int size, int index) {
        this.offset = offset;
        this.size = size;
        this.index = index;
        this.state = State.NeedToCheck;
        this.uploadSize = 0L;
    }

    static UploadData dataFromJson(JSONObject jsonObject) throws Exception {
        if (jsonObject == null) {
            return null;
        }
        long offset = jsonObject.getLong("offset");
        int size = jsonObject.getInt("size");
        int index = jsonObject.getInt("index");
        String etag = jsonObject.optString("etag");
        State state = State.state(jsonObject.getInt("state"));
        String md5 = jsonObject.optString("md5");
        UploadData uploadData = new UploadData(offset, size, index);
        uploadData.etag = etag;
        uploadData.md5 = md5;
        uploadData.state = state;
        uploadData.uploadSize = 0L;
        return uploadData;
    }

    boolean needToUpload() {
        switch (this.state) {
            case NeedToCheck: 
            case WaitToUpload: {
                return true;
            }
        }
        return false;
    }

    boolean isUploaded() {
        return this.state == State.Complete;
    }

    State getState() {
        return this.state;
    }

    void updateState(State state) {
        switch (state) {
            case NeedToCheck: 
            case WaitToUpload: 
            case Uploading: {
                this.uploadSize = 0L;
                this.etag = null;
                break;
            }
            case Complete: {
                this.data = null;
            }
        }
        this.state = state;
    }

    void setUploadSize(long uploadSize) {
        this.uploadSize = uploadSize;
    }

    long uploadSize() {
        return this.state == State.Complete ? (long)this.size : this.uploadSize;
    }

    void clearUploadState() {
        this.etag = null;
        this.md5 = null;
        this.state = State.NeedToCheck;
    }

    void checkStateAndUpdate() {
        if ((this.state == State.WaitToUpload || this.state == State.Uploading) && this.data == null) {
            this.state = State.NeedToCheck;
        }
    }

    JSONObject toJsonObject() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.putOpt("offset", (Object)this.offset);
        jsonObject.putOpt("size", (Object)this.size);
        jsonObject.putOpt("index", (Object)this.index);
        jsonObject.putOpt("etag", (Object)this.etag);
        jsonObject.putOpt("md5", (Object)this.md5);
        jsonObject.putOpt("state", (Object)this.state.intValue());
        return jsonObject;
    }

    static enum State {
        NeedToCheck,
        WaitToUpload,
        Uploading,
        Complete;


        private int intValue() {
            return this.ordinal();
        }

        private static State state(int value) {
            State[] states = State.values();
            if (value < 0 || value >= states.length) {
                return NeedToCheck;
            }
            return states[value];
        }
    }
}

