/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadInfo;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.ListVector;
import com.qiniu.android.utils.MD5;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class UploadInfoV2
extends UploadInfo {
    private static final String TypeKey = "infoType";
    private static final String TypeValue = "UploadInfoV2";
    private static final int maxDataSize = 0x40000000;
    private static final int DataListCapacityIncrement = 2;
    private final int dataSize;
    private ListVector<UploadData> dataList;
    private boolean isEOF = false;
    private IOException readException = null;
    String uploadId;
    Long expireAt;

    private UploadInfoV2(UploadSource source, int dataSize, ListVector<UploadData> dataList) {
        super(source);
        this.dataSize = dataSize;
        this.dataList = dataList;
    }

    UploadInfoV2(UploadSource source, Configuration configuration) {
        super(source);
        this.dataSize = Math.min(configuration.chunkSize, 0x40000000);
        this.dataList = new ListVector(2, 2);
    }

    static UploadInfoV2 infoFromJson(UploadSource source, JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        int dataSize = 0;
        String type = null;
        Long expireAt = null;
        String uploadId = null;
        ListVector<UploadData> dataList = null;
        try {
            type = jsonObject.optString(TypeKey);
            dataSize = jsonObject.getInt("dataSize");
            expireAt = jsonObject.getLong("expireAt");
            uploadId = jsonObject.optString("uploadId");
            JSONArray dataJsonArray = jsonObject.getJSONArray("dataList");
            dataList = new ListVector<UploadData>(dataJsonArray.length(), 2);
            for (int i = 0; i < dataJsonArray.length(); ++i) {
                JSONObject dataJson = dataJsonArray.getJSONObject(i);
                UploadData data = UploadData.dataFromJson(dataJson);
                if (data == null) continue;
                dataList.add(data);
            }
        }
        catch (Exception e) {
            return null;
        }
        UploadInfoV2 info = new UploadInfoV2(source, dataSize, dataList);
        info.setInfoFromJson(jsonObject);
        info.expireAt = expireAt;
        info.uploadId = uploadId;
        if (!TypeValue.equals(type) || !source.getId().equals(info.getSourceId())) {
            return null;
        }
        return info;
    }

    int getPartIndexOfData(UploadData data) {
        return data.index + 1;
    }

    UploadData nextUploadData() throws IOException {
        UploadData data = this.nextUploadDataFormDataList();
        if (data == null) {
            if (this.isEOF) {
                return null;
            }
            if (this.readException != null) {
                throw this.readException;
            }
            long dataOffset = 0L;
            if (this.dataList.size() > 0) {
                UploadData lastData = (UploadData)this.dataList.get(this.dataList.size() - 1);
                dataOffset = lastData.offset + (long)lastData.size;
            }
            int dataIndex = this.dataList.size();
            data = new UploadData(dataOffset, this.dataSize, dataIndex);
        }
        UploadData loadData = null;
        try {
            loadData = this.loadData(data);
        }
        catch (IOException e) {
            this.readException = e;
            throw e;
        }
        if (loadData == null) {
            this.isEOF = true;
            if (this.dataList.size() > data.index) {
                this.dataList = this.dataList.subList(0, data.index);
            }
        } else {
            if (loadData.index == this.dataList.size()) {
                this.dataList.add(loadData);
            } else if (loadData != data) {
                this.dataList.set(loadData.index, loadData);
            }
            if (loadData.size < data.size) {
                this.isEOF = true;
                if (this.dataList.size() > data.index + 1) {
                    this.dataList = this.dataList.subList(0, data.index + 1);
                }
            }
        }
        return loadData;
    }

    private UploadData nextUploadDataFormDataList() {
        if (this.dataList == null || this.dataList.size() == 0) {
            return null;
        }
        final UploadData[] dataRet = new UploadData[]{null};
        this.dataList.enumerateObjects(new ListVector.EnumeratorHandler<UploadData>(){

            @Override
            public boolean enumerate(UploadData data) {
                if (data.needToUpload()) {
                    dataRet[0] = data;
                    return true;
                }
                return false;
            }
        });
        return dataRet[0];
    }

    private UploadData loadData(UploadData data) throws IOException {
        if (data == null) {
            return null;
        }
        if (data.data != null) {
            return data;
        }
        byte[] dataBytes = null;
        try {
            dataBytes = this.readData(data.size, data.offset);
        }
        catch (IOException e) {
            this.readException = e;
            throw e;
        }
        if (dataBytes == null || dataBytes.length == 0) {
            return null;
        }
        String md5 = MD5.encrypt(dataBytes);
        if (dataBytes.length != data.size || data.md5 == null || !data.md5.equals(md5)) {
            data = new UploadData(data.offset, dataBytes.length, data.index);
            data.md5 = md5;
        }
        if (StringUtils.isNullOrEmpty(data.etag)) {
            data.data = dataBytes;
            data.updateState(UploadData.State.WaitToUpload);
        } else {
            data.updateState(UploadData.State.Complete);
        }
        return data;
    }

    List<Map<String, Object>> getPartInfoArray() {
        if (this.uploadId == null || this.uploadId.length() == 0) {
            return null;
        }
        final ArrayList<Map<String, Object>> infoArray = new ArrayList<Map<String, Object>>();
        this.dataList.enumerateObjects(new ListVector.EnumeratorHandler<UploadData>(){

            @Override
            public boolean enumerate(UploadData data) {
                if (data.getState() == UploadData.State.Complete && !StringUtils.isNullOrEmpty(data.etag)) {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("etag", data.etag);
                    info.put("partNumber", UploadInfoV2.this.getPartIndexOfData(data));
                    infoArray.add(info);
                }
                return false;
            }
        });
        return infoArray;
    }

    @Override
    boolean reloadSource() {
        this.isEOF = false;
        this.readException = null;
        return super.reloadSource();
    }

    @Override
    boolean isSameUploadInfo(UploadInfo info) {
        if (!super.isSameUploadInfo(info)) {
            return false;
        }
        if (!(info instanceof UploadInfoV2)) {
            return false;
        }
        UploadInfoV2 infoV2 = (UploadInfoV2)info;
        return this.dataSize == infoV2.dataSize;
    }

    @Override
    void clearUploadState() {
        this.expireAt = null;
        this.uploadId = null;
        this.dataList.enumerateObjects(new ListVector.EnumeratorHandler<UploadData>(){

            @Override
            public boolean enumerate(UploadData data) {
                data.clearUploadState();
                return false;
            }
        });
    }

    @Override
    long uploadSize() {
        if (this.dataList == null || this.dataList.size() == 0) {
            return 0L;
        }
        final long[] uploadSize = new long[]{0L};
        this.dataList.enumerateObjects(new ListVector.EnumeratorHandler<UploadData>(){

            @Override
            public boolean enumerate(UploadData data) {
                uploadSize[0] = uploadSize[0] + data.uploadSize();
                return false;
            }
        });
        return uploadSize[0];
    }

    @Override
    boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (StringUtils.isNullOrEmpty(this.uploadId) || this.expireAt == null) {
            return false;
        }
        return this.expireAt - 7200L > Utils.currentSecondTimestamp();
    }

    @Override
    boolean isAllUploaded() {
        if (!this.isEOF) {
            return false;
        }
        if (this.dataList == null || this.dataList.size() == 0) {
            return true;
        }
        final boolean[] isCompleted = new boolean[]{true};
        this.dataList.enumerateObjects(new ListVector.EnumeratorHandler<UploadData>(){

            @Override
            public boolean enumerate(UploadData data) {
                if (!data.isUploaded()) {
                    isCompleted[0] = false;
                    return true;
                }
                return false;
            }
        });
        return isCompleted[0];
    }

    @Override
    void checkInfoStateAndUpdate() {
        this.dataList.enumerateObjects(new ListVector.EnumeratorHandler<UploadData>(){

            @Override
            public boolean enumerate(UploadData data) {
                data.checkStateAndUpdate();
                return false;
            }
        });
    }

    @Override
    JSONObject toJsonObject() {
        JSONObject jsonObject = super.toJsonObject();
        if (jsonObject == null) {
            return null;
        }
        try {
            jsonObject.put(TypeKey, (Object)TypeValue);
            jsonObject.put("dataSize", this.dataSize);
            jsonObject.put("expireAt", (Object)this.expireAt);
            jsonObject.put("uploadId", (Object)this.uploadId);
            if (this.dataList != null && this.dataList.size() > 0) {
                final JSONArray dataJsonArray = new JSONArray();
                this.dataList.enumerateObjects(new ListVector.EnumeratorHandler<UploadData>(){

                    @Override
                    public boolean enumerate(UploadData data) {
                        try {
                            JSONObject dataJson = data.toJsonObject();
                            if (dataJson != null) {
                                dataJsonArray.put((Object)dataJson);
                            }
                        }
                        catch (Exception e) {
                            return true;
                        }
                        return false;
                    }
                });
                if (dataJsonArray.length() != this.dataList.size()) {
                    return null;
                }
                jsonObject.put("dataList", (Object)dataJsonArray);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return jsonObject;
    }
}

