/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UploadSource;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class UploadSourceFile
extends UploadSource {
    private Exception readException = null;
    private final File file;
    private final RandomAccessFile randomAccessFile;

    UploadSourceFile(File file) {
        this.file = file;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (Exception e) {
            this.readException = e;
        }
        this.randomAccessFile = randomAccessFile;
    }

    @Override
    public String getId() {
        return this.getFileName() + "_" + this.file.lastModified();
    }

    @Override
    public boolean couldReloadSource() {
        return this.randomAccessFile != null;
    }

    @Override
    public boolean reloadSource() {
        return true;
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public byte[] readData(int dataSize, long dataOffset) throws IOException {
        if (this.randomAccessFile == null) {
            if (this.readException != null) {
                throw new IOException(this.readException);
            }
            throw new IOException("file is invalid");
        }
        byte[] buffer = new byte[dataSize];
        try {
            int readSize;
            int ret;
            this.randomAccessFile.seek(dataOffset);
            for (readSize = 0; readSize < dataSize && (ret = this.randomAccessFile.read(buffer, readSize, dataSize - readSize)) >= 0; readSize += ret) {
            }
            if (readSize < dataSize) {
                byte[] newBuffer = new byte[readSize];
                System.arraycopy(buffer, 0, newBuffer, 0, readSize);
                buffer = newBuffer;
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        return buffer;
    }

    @Override
    public void close() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                try {
                    this.randomAccessFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    String getSourceType() {
        return "File";
    }
}

