/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.Config;
import com.qiniu.android.common.FixedZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZonesInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetchTransaction;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.SingleFlight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public final class AutoZone
extends Zone {
    private String[] ucServers;
    private ArrayList<RequestTransaction> transactions = new ArrayList();
    private FixedZone defaultZone;
    private static final SingleFlight SingleFlight = new SingleFlight();

    public void setUcServer(String ucServer) {
        if (ucServer != null) {
            this.ucServers = new String[]{ucServer};
        }
    }

    public void setUcServers(String[] ucServers) {
        if (ucServers != null && ucServers.length > 0) {
            this.ucServers = ucServers;
        }
    }

    public void setDefaultZones(FixedZone[] zones) {
        this.defaultZone = FixedZone.combineZones(zones);
    }

    public List<String> getUcServerList() {
        if (this.ucServers != null && this.ucServers.length > 0) {
            ArrayList<String> serverList = new ArrayList<String>();
            Collections.addAll(serverList, this.ucServers);
            return serverList;
        }
        return Arrays.asList(Config.preQueryHosts());
    }

    public static void clearCache() {
        GlobalCache.getInstance().clearCache();
    }

    private String[] getUcServerArray() {
        if (this.ucServers != null && this.ucServers.length > 0) {
            return this.ucServers;
        }
        return Config.preQueryHosts();
    }

    @Override
    public ZonesInfo getZonesInfo(UpToken token) {
        if (token == null) {
            return null;
        }
        String cacheKey = token.index();
        ZonesInfo zonesInfo = GlobalCache.getInstance().zonesInfoForKey(cacheKey);
        if (zonesInfo != null) {
            try {
                zonesInfo = (ZonesInfo)zonesInfo.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zonesInfo;
    }

    @Override
    public void preQuery(final UpToken token, final Zone.QueryHandler completeHandler) {
        if (token == null || !token.isValid()) {
            completeHandler.complete(-1, ResponseInfo.invalidToken("invalid token"), null);
            return;
        }
        UploadRegionRequestMetrics localMetrics = new UploadRegionRequestMetrics(null);
        localMetrics.start();
        final String cacheKey = token.index();
        ZonesInfo zonesInfo = GlobalCache.getInstance().zonesInfoForKey(cacheKey);
        if (zonesInfo != null && zonesInfo.isValid() && !zonesInfo.isTemporary()) {
            localMetrics.end();
            completeHandler.complete(0, ResponseInfo.successResponse(), localMetrics);
            return;
        }
        DnsPrefetchTransaction.addDnsCheckAndPrefetchTransaction(this.getUcServerArray());
        try {
            SingleFlight.perform(cacheKey, new SingleFlight.ActionHandler(){

                public void action(final SingleFlight.CompleteHandler completeHandler) throws Exception {
                    final RequestTransaction transaction = AutoZone.this.createUploadRequestTransaction(token);
                    transaction.queryUploadHosts(true, new RequestTransaction.RequestCompleteHandler(){

                        @Override
                        public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                            AutoZone.this.destroyUploadRequestTransaction(transaction);
                            SingleFlightValue value = new SingleFlightValue();
                            value.responseInfo = responseInfo;
                            value.response = response;
                            value.metrics = requestMetrics;
                            completeHandler.complete(value);
                        }
                    });
                }
            }, new SingleFlight.CompleteHandler(){

                public void complete(Object value) {
                    SingleFlightValue singleFlightValue = (SingleFlightValue)value;
                    ResponseInfo responseInfo = singleFlightValue.responseInfo;
                    UploadRegionRequestMetrics requestMetrics = singleFlightValue.metrics;
                    JSONObject response = singleFlightValue.response;
                    if (responseInfo != null && responseInfo.isOK() && response != null) {
                        ZonesInfo zonesInfoP = ZonesInfo.createZonesInfo(response);
                        if (zonesInfoP.isValid()) {
                            GlobalCache.getInstance().cache(zonesInfoP, cacheKey);
                            completeHandler.complete(0, responseInfo, requestMetrics);
                        } else {
                            completeHandler.complete(-1015, responseInfo, requestMetrics);
                        }
                    } else if (responseInfo != null && responseInfo.isNetworkBroken()) {
                        completeHandler.complete(-1, responseInfo, requestMetrics);
                    } else {
                        ZonesInfo infoP;
                        ZonesInfo info = null;
                        if (AutoZone.this.defaultZone != null && (infoP = AutoZone.this.defaultZone.getZonesInfo(token)) != null && infoP.isValid()) {
                            infoP.toTemporary();
                            info = infoP;
                        }
                        if (info != null) {
                            GlobalCache.getInstance().cache(info, cacheKey);
                            completeHandler.complete(0, responseInfo, requestMetrics);
                        } else {
                            completeHandler.complete(-1015, responseInfo, requestMetrics);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            completeHandler.complete(-1, ResponseInfo.localIOError(e.toString()), null);
        }
    }

    private RequestTransaction createUploadRequestTransaction(UpToken token) {
        List<String> hosts = this.getUcServerList();
        RequestTransaction transaction = new RequestTransaction(hosts, "unknown", token);
        this.transactions.add(transaction);
        return transaction;
    }

    private void destroyUploadRequestTransaction(RequestTransaction transaction) {
        this.transactions.remove(transaction);
    }

    private static class GlobalCache {
        private static GlobalCache globalCache = new GlobalCache();
        private ConcurrentHashMap<String, ZonesInfo> cache = new ConcurrentHashMap();

        private GlobalCache() {
        }

        private static GlobalCache getInstance() {
            return globalCache;
        }

        private synchronized void cache(ZonesInfo zonesInfo, String cacheKey) {
            if (cacheKey == null || cacheKey.isEmpty() || zonesInfo == null) {
                return;
            }
            this.cache.put(cacheKey, zonesInfo);
        }

        private synchronized ZonesInfo zonesInfoForKey(String cacheKey) {
            if (cacheKey == null || cacheKey.isEmpty()) {
                return null;
            }
            return this.cache.get(cacheKey);
        }

        private void clearCache() {
            for (ZonesInfo zonesInfo : this.cache.values()) {
                zonesInfo.toTemporary();
            }
        }
    }

    private static class SingleFlightValue {
        private ResponseInfo responseInfo;
        private JSONObject response;
        private UploadRegionRequestMetrics metrics;

        private SingleFlightValue() {
        }
    }
}

