/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.ZoneInfo;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZonesInfo
implements Cloneable {
    private boolean isTemporary;
    public final ArrayList<ZoneInfo> zonesInfo;

    public ZonesInfo(ArrayList<ZoneInfo> zonesInfo) {
        this(zonesInfo, false);
    }

    public ZonesInfo(ArrayList<ZoneInfo> zonesInfo, boolean isTemporary) {
        this.zonesInfo = zonesInfo;
        this.isTemporary = isTemporary;
    }

    public static ZonesInfo createZonesInfo(JSONObject jsonObject) {
        ArrayList<ZoneInfo> zonesInfo = new ArrayList<ZoneInfo>();
        if (jsonObject != null) {
            try {
                JSONArray hosts = jsonObject.getJSONArray("hosts");
                for (int i = 0; i < hosts.length(); ++i) {
                    ZoneInfo zoneInfo = ZoneInfo.buildFromJson(hosts.getJSONObject(i));
                    if (zoneInfo == null || !zoneInfo.isValid()) continue;
                    zonesInfo.add(zoneInfo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ZonesInfo(zonesInfo);
    }

    public boolean isValid() {
        if (this.zonesInfo == null || this.zonesInfo.size() == 0) {
            return false;
        }
        boolean valid = true;
        for (ZoneInfo info : this.zonesInfo) {
            if (info.isValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void toTemporary() {
        this.isTemporary = true;
    }

    protected Object clone() throws CloneNotSupportedException {
        ArrayList<ZoneInfo> infos = new ArrayList<ZoneInfo>();
        if (this.zonesInfo != null && this.zonesInfo.size() > 0) {
            for (ZoneInfo zoneInfo : this.zonesInfo) {
                infos.add((ZoneInfo)zoneInfo.clone());
            }
        }
        ZonesInfo info = new ZonesInfo(infos);
        info.isTemporary = this.isTemporary;
        return info;
    }
}

