/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.ContextGetter;
import com.qiniu.android.utils.IPAddressUtil;
import com.qiniu.android.utils.StringUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class Utils {
    private static Boolean isDebug = null;

    public static boolean isDebug() {
        if (isDebug != null) {
            return isDebug;
        }
        Context context = ContextGetter.applicationContext();
        if (context == null) {
            return false;
        }
        try {
            ApplicationInfo info = context.getApplicationInfo();
            isDebug = (info.flags & 2) != 0;
            return isDebug;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String sdkVerion() {
        return "8.6.0";
    }

    public static String sdkLanguage() {
        return "Android";
    }

    public static Integer getCurrentProcessID() {
        return Process.myPid();
    }

    public static Long getCurrentThreadID() {
        Thread thread = Thread.currentThread();
        return thread.getId();
    }

    public static String systemName() {
        try {
            String model = Build.MODEL != null ? Build.MODEL.trim() : "";
            String device = Utils.deviceName(Build.MANUFACTURER.trim(), model);
            if (TextUtils.isEmpty((CharSequence)device)) {
                device = Utils.deviceName(Build.BRAND.trim(), model);
            }
            String sdkVersion = Build.VERSION.SDK != null ? Build.VERSION.SDK : "";
            return device + "/" + model + "/" + sdkVersion;
        }
        catch (Throwable t) {
            return "-";
        }
    }

    private static String deviceName(String manufacturer, String model) {
        String str = manufacturer.toLowerCase(Locale.getDefault());
        if (str.startsWith("unknown") || str.startsWith("alps") || str.startsWith("android") || str.startsWith("sprd") || str.startsWith("spreadtrum") || str.startsWith("rockchip") || str.startsWith("wondermedia") || str.startsWith("mtk") || str.startsWith("mt65") || str.startsWith("nvidia") || str.startsWith("brcm") || str.startsWith("marvell") || model.toLowerCase(Locale.getDefault()).contains(str)) {
            return null;
        }
        return manufacturer;
    }

    public static String systemVersion() {
        try {
            String v = Build.VERSION.RELEASE;
            if (v == null) {
                return "-";
            }
            return StringUtils.strip(v.trim());
        }
        catch (Throwable t) {
            return "-";
        }
    }

    public static Integer getCurrentSignalStrength() {
        return null;
    }

    public static String getCurrentNetworkType() {
        Context context = ContextGetter.applicationContext();
        if (context == null) {
            return "";
        }
        return AndroidNetwork.networkType(context);
    }

    public static long currentTimestamp() {
        return new Date().getTime();
    }

    public static long currentSecondTimestamp() {
        return Utils.currentTimestamp() / 1000L;
    }

    public static long dateDuration(Date startDate, Date endDate) {
        if (startDate != null && endDate != null) {
            return endDate.getTime() - startDate.getTime();
        }
        return 0L;
    }

    public static Long calculateSpeed(Long bytes, Long totalTime) {
        if (bytes == null || bytes < 0L || totalTime == null || totalTime == 0L) {
            return null;
        }
        return bytes * 1000L / totalTime;
    }

    public static String sdkDirectory() {
        Context context = ContextGetter.applicationContext();
        if (context == null) {
            return null;
        }
        String directory = context.getCacheDir().getAbsolutePath() + "/qiniu";
        return directory;
    }

    public static String formEscape(String string) {
        if (string == null) {
            return null;
        }
        String ret = string;
        ret = ret.replace("\\", "\\\\");
        ret = ret.replace("\"", "\\\"");
        return ret;
    }

    @Deprecated
    public static String getIpType(String ip, String host) {
        String type = host;
        if (ip == null || ip.length() == 0) {
            return type;
        }
        if (ip.contains(":")) {
            type = Utils.getIPV6StringType(ip, host);
        } else if (ip.contains(".")) {
            type = Utils.getIPV4StringType(ip, host);
        }
        return type;
    }

    public static String getIpType(String httpVersion, String ip, String host) {
        if (httpVersion == null) {
            httpVersion = "";
        }
        String type = host;
        if (ip == null || ip.length() == 0) {
            return httpVersion + "-" + type;
        }
        if (ip.contains(":")) {
            type = Utils.getIPV6StringType(ip, host);
        } else if (ip.contains(".")) {
            type = Utils.getIPV4StringType(ip, host);
        }
        return httpVersion + "-" + type;
    }

    public static boolean isIpv6(String ip) {
        if (StringUtils.isNullOrEmpty(ip)) {
            return false;
        }
        return IPAddressUtil.isIPv6LiteralAddress(ip);
    }

    private static String getIPV4StringType(String ipv4String, String host) {
        if (host == null) {
            host = "";
        }
        String type = null;
        String[] ipNumberStrings = ipv4String.split("\\.");
        if (ipNumberStrings.length == 4) {
            int firstNumber = Integer.parseInt(ipNumberStrings[0]);
            int secondNumber = Integer.parseInt(ipNumberStrings[1]);
            type = firstNumber + "-" + secondNumber;
        }
        type = host + "-" + type;
        return type;
    }

    private static String getIPV6StringType(String ipv6String, String host) {
        String ipNumberString;
        String ipNumberString2;
        int i;
        if (host == null) {
            host = "";
        }
        String[] ipNumberStrings = ipv6String.split(":");
        String[] ipNumberStringsReal = new String[]{"0000", "0000", "0000", "0000", "0000", "0000", "0000", "0000"};
        String[] suppleStrings = new String[]{"0000", "000", "00", "0", ""};
        for (i = 0; i < ipNumberStrings.length && (ipNumberString2 = ipNumberStrings[i]).length() > 0; ++i) {
            ipNumberStringsReal[i] = ipNumberString2 = suppleStrings[ipNumberString2.length()] + ipNumberString2;
        }
        int j = ipNumberStrings.length - 1;
        int indexReal = ipNumberStringsReal.length - 1;
        while (i < j && (ipNumberString = ipNumberStrings[j]).length() > 0) {
            ipNumberStringsReal[indexReal] = ipNumberString = suppleStrings[ipNumberString.length()] + ipNumberString;
            --j;
            --indexReal;
        }
        String[] typeNumberArray = Arrays.copyOfRange(ipNumberStringsReal, 0, 4);
        String numberInfo = StringUtils.join(typeNumberArray, "-");
        return host + "-ipv6-" + numberInfo;
    }
}

