/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.Config;
import com.qiniu.android.common.FixedZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZonesInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetchTransaction;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.Cache;
import com.qiniu.android.utils.SingleFlight;
import com.qiniu.android.utils.UrlSafeBase64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public final class AutoZone
extends Zone {
    private String[] ucServers;
    private final List<RequestTransaction> transactions = new ArrayList<RequestTransaction>();
    private FixedZone defaultZone;
    private final Map<String, ZonesInfo> zonesInfoMap = new ConcurrentHashMap<String, ZonesInfo>();
    private static final SingleFlight<SingleFlightValue> SingleFlight = new SingleFlight();
    private static final Cache zoneCache = new Cache.Builder(ZonesInfo.class).setVersion("v1").builder();

    public void setUcServer(String ucServer) {
        if (ucServer != null) {
            this.ucServers = new String[]{ucServer};
        }
    }

    public void setUcServers(String[] ucServers) {
        if (ucServers != null && ucServers.length > 0) {
            this.ucServers = ucServers;
        }
    }

    public void setDefaultZones(FixedZone[] zones) {
        this.defaultZone = FixedZone.combineZones(zones);
    }

    public List<String> getUcServerList() {
        if (this.ucServers != null && this.ucServers.length > 0) {
            ArrayList<String> serverList = new ArrayList<String>();
            Collections.addAll(serverList, this.ucServers);
            return serverList;
        }
        return Arrays.asList(Config.preQueryHosts());
    }

    public static void clearCache() {
        zoneCache.clearMemoryCache();
        zoneCache.clearDiskCache();
    }

    private String[] getUcServerArray() {
        if (this.ucServers != null && this.ucServers.length > 0) {
            return this.ucServers;
        }
        return Config.preQueryHosts();
    }

    @Override
    public ZonesInfo getZonesInfo(UpToken token) {
        if (token == null) {
            return null;
        }
        String cacheKey = this.makeCacheKey(token.index());
        ZonesInfo zonesInfo = this.zonesInfoMap.get(cacheKey);
        if (zonesInfo != null) {
            try {
                zonesInfo = (ZonesInfo)zonesInfo.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zonesInfo;
    }

    @Override
    public void preQuery(final UpToken token, final Zone.QueryHandler completeHandler) {
        if (token == null || !token.isValid()) {
            completeHandler.complete(-1, ResponseInfo.invalidToken("invalid token"), null);
            return;
        }
        UploadRegionRequestMetrics localMetrics = new UploadRegionRequestMetrics(null);
        localMetrics.start();
        final String cacheKey = this.makeCacheKey(token.index());
        ZonesInfo zonesInfo = null;
        Cache.Object object = zoneCache.cacheForKey(cacheKey);
        if (object instanceof ZonesInfo) {
            zonesInfo = (ZonesInfo)object;
        }
        if (zonesInfo != null && zonesInfo.isValid()) {
            localMetrics.end();
            this.zonesInfoMap.put(cacheKey, zonesInfo);
            completeHandler.complete(0, ResponseInfo.successResponse(), localMetrics);
            return;
        }
        DnsPrefetchTransaction.addDnsCheckAndPrefetchTransaction(this.getUcServerArray());
        final ZonesInfo finalZonesInfo = zonesInfo;
        try {
            SingleFlight.perform(cacheKey, new SingleFlight.ActionHandler<SingleFlightValue>(){

                @Override
                public void action(final SingleFlight.CompleteHandler<SingleFlightValue> completeHandler) throws Exception {
                    final RequestTransaction transaction = AutoZone.this.createUploadRequestTransaction(token);
                    transaction.queryUploadHosts(true, new RequestTransaction.RequestCompleteHandler(){

                        @Override
                        public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                            AutoZone.this.destroyUploadRequestTransaction(transaction);
                            SingleFlightValue value = new SingleFlightValue();
                            value.responseInfo = responseInfo;
                            value.response = response;
                            value.metrics = requestMetrics;
                            completeHandler.complete(value);
                        }
                    });
                }
            }, new SingleFlight.CompleteHandler<SingleFlightValue>(){

                @Override
                public void complete(SingleFlightValue singleFlightValue) {
                    ResponseInfo responseInfo = singleFlightValue.responseInfo;
                    UploadRegionRequestMetrics requestMetrics = singleFlightValue.metrics;
                    JSONObject response = singleFlightValue.response;
                    if (responseInfo != null && responseInfo.isOK() && response != null) {
                        ZonesInfo zonesInfoP = ZonesInfo.createZonesInfo(response);
                        if (zonesInfoP.isValid()) {
                            zoneCache.cache(cacheKey, zonesInfoP, true);
                            AutoZone.this.zonesInfoMap.put(cacheKey, zonesInfoP);
                            completeHandler.complete(0, responseInfo, requestMetrics);
                        } else {
                            completeHandler.complete(-1015, responseInfo, requestMetrics);
                        }
                    } else if (AutoZone.this.defaultZone != null) {
                        ZonesInfo defaultZoneZonesInfo = AutoZone.this.defaultZone.getZonesInfo(token);
                        AutoZone.this.zonesInfoMap.put(cacheKey, defaultZoneZonesInfo);
                        completeHandler.complete(0, responseInfo, requestMetrics);
                    } else if (finalZonesInfo != null) {
                        AutoZone.this.zonesInfoMap.put(cacheKey, finalZonesInfo);
                        completeHandler.complete(0, responseInfo, requestMetrics);
                    } else {
                        completeHandler.complete(-1, responseInfo, requestMetrics);
                    }
                }
            });
        }
        catch (Exception e) {
            completeHandler.complete(-1, ResponseInfo.localIOError(e.toString()), null);
        }
    }

    private String makeCacheKey(String akAndBucket) {
        List<String> ucHosts = this.getUcServerList();
        if (ucHosts == null || ucHosts.isEmpty()) {
            return akAndBucket;
        }
        StringBuilder hosts = new StringBuilder();
        for (String host : ucHosts) {
            if (host == null || host.isEmpty()) continue;
            hosts.append(host).append(":");
        }
        return UrlSafeBase64.encodeToString(hosts + akAndBucket);
    }

    private RequestTransaction createUploadRequestTransaction(UpToken token) {
        List<String> hosts = this.getUcServerList();
        RequestTransaction transaction = new RequestTransaction(hosts, "unknown", token);
        this.transactions.add(transaction);
        return transaction;
    }

    private void destroyUploadRequestTransaction(RequestTransaction transaction) {
        this.transactions.remove(transaction);
    }

    private static class SingleFlightValue {
        private ResponseInfo responseInfo;
        private JSONObject response;
        private UploadRegionRequestMetrics metrics;

        private SingleFlightValue() {
        }
    }
}

