/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.networkStatus;

import com.qiniu.android.utils.Cache;
import com.qiniu.android.utils.Utils;
import org.json.JSONObject;

public class NetworkStatusManager {
    private static final NetworkStatusManager networkStatusManager = new NetworkStatusManager();
    private final Cache cache = new Cache.Builder(NetworkStatus.class).setVersion("v2").setFlushCount(10).builder();
    protected static final int DefaultSpeed = 600;

    public static NetworkStatusManager getInstance() {
        return networkStatusManager;
    }

    private NetworkStatusManager() {
    }

    @Deprecated
    public static String getNetworkStatusType(String host, String ip) {
        return Utils.getIpType(ip, host);
    }

    public static String getNetworkStatusType(String httpVersion, String host, String ip) {
        return Utils.getIpType(httpVersion, ip, host);
    }

    public NetworkStatus getNetworkStatus(String type) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        Cache.Object object = this.cache.cacheForKey(type);
        if (object instanceof NetworkStatus) {
            return (NetworkStatus)object;
        }
        return new NetworkStatus();
    }

    public void updateNetworkStatus(String type, int speed) {
        if (type == null || type.isEmpty()) {
            return;
        }
        NetworkStatus status = new NetworkStatus();
        status.speed = speed;
        this.cache.cache(type, status, false);
    }

    public static class NetworkStatus
    implements Cache.Object {
        private int speed = 600;

        public int getSpeed() {
            return this.speed;
        }

        public void setSpeed(int speed) {
            this.speed = speed;
        }

        private NetworkStatus() {
        }

        public NetworkStatus(JSONObject jsonObject) {
            if (jsonObject == null) {
                return;
            }
            try {
                this.speed = jsonObject.getInt("speed");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public JSONObject toJson() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("speed", this.speed);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return jsonObject;
        }
    }
}

