/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.networkStatus;

import com.qiniu.android.http.networkStatus.NetworkStatusManager;
import com.qiniu.android.http.request.IUploadServer;

public class UploadServerNetworkStatus {
    private UploadServerNetworkStatus() {
    }

    public static IUploadServer getBetterNetworkServer(IUploadServer serverA, IUploadServer serverB) {
        return UploadServerNetworkStatus.isServerNetworkBetter(serverA, serverB) ? serverA : serverB;
    }

    public static boolean isServerNetworkBetter(IUploadServer serverA, IUploadServer serverB) {
        if (serverA == null) {
            return false;
        }
        if (serverB == null) {
            return true;
        }
        String serverTypeA = NetworkStatusManager.getNetworkStatusType(serverA.getHttpVersion(), serverA.getHost(), serverA.getIp());
        String serverTypeB = NetworkStatusManager.getNetworkStatusType(serverB.getHttpVersion(), serverB.getHost(), serverB.getIp());
        if (serverTypeA == null || serverTypeA.length() == 0) {
            return false;
        }
        if (serverTypeB == null || serverTypeB.length() == 0) {
            return true;
        }
        NetworkStatusManager.NetworkStatus serverStatusA = NetworkStatusManager.getInstance().getNetworkStatus(serverTypeA);
        NetworkStatusManager.NetworkStatus serverStatusB = NetworkStatusManager.getInstance().getNetworkStatus(serverTypeB);
        int serverASpeed = serverStatusA.getSpeed();
        int serverBSpeed = serverStatusB.getSpeed();
        String serverAHttpVersion = serverA.getHttpVersion();
        String serverBHttpVersion = serverB.getHttpVersion();
        if (serverAHttpVersion == null) {
            serverAHttpVersion = "";
        }
        if (serverBHttpVersion == null) {
            serverBHttpVersion = "";
        }
        if (serverAHttpVersion.equals(IUploadServer.HttpVersion3) && !serverAHttpVersion.equals(serverBHttpVersion)) {
            if (serverASpeed < 200 && serverBSpeed == 600) {
                return true;
            }
            if (serverASpeed > 600 && serverBSpeed > 400) {
                return false;
            }
        } else if (serverBHttpVersion.equals(IUploadServer.HttpVersion3) && !serverAHttpVersion.equals(serverBHttpVersion)) {
            if (serverBSpeed < 200 && serverASpeed == 600) {
                return false;
            }
            if (serverBSpeed > 600 && serverASpeed > 400) {
                return true;
            }
        }
        return serverBSpeed <= serverASpeed;
    }
}

