/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.collect.UploadInfoReporter;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.PartsUploadPerformer;
import com.qiniu.android.storage.PartsUploadPerformerV1;
import com.qiniu.android.storage.PartsUploadPerformerV2;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.Utils;
import org.json.JSONObject;

class PartsUpload
extends BaseUpload {
    PartsUploadPerformer uploadPerformer;
    private ResponseInfo uploadDataErrorResponseInfo;
    private JSONObject uploadDataErrorResponse;

    protected PartsUpload(UploadSource source, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, BaseUpload.UpTaskCompletionHandler completionHandler) {
        super(source, key, token, option, config, recorder, recorderKey, completionHandler);
    }

    @Override
    protected void initData() {
        super.initData();
        if (this.config != null && this.config.resumeUploadVersion == Configuration.RESUME_UPLOAD_VERSION_V1) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " \u5206\u7247V1");
            this.uploadPerformer = new PartsUploadPerformerV1(this.uploadSource, this.fileName, this.key, this.token, this.option, this.config, this.recorderKey);
        } else {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " \u5206\u7247V2");
            this.uploadPerformer = new PartsUploadPerformerV2(this.uploadSource, this.fileName, this.key, this.token, this.option, this.config, this.recorderKey);
        }
    }

    boolean isAllUploaded() {
        if (this.uploadPerformer.uploadInfo == null) {
            return false;
        }
        return this.uploadPerformer.uploadInfo.isAllUploaded();
    }

    private void setErrorResponse(ResponseInfo responseInfo, JSONObject response) {
        if (responseInfo == null) {
            return;
        }
        if (this.uploadDataErrorResponseInfo == null || responseInfo.statusCode != -9) {
            this.uploadDataErrorResponseInfo = responseInfo;
            this.uploadDataErrorResponse = response == null ? responseInfo.response : response;
        }
    }

    @Override
    protected int prepareToUpload() {
        int code = super.prepareToUpload();
        if (code != 0) {
            return code;
        }
        if (this.uploadPerformer.currentRegion != null && this.uploadPerformer.currentRegion.isValid()) {
            this.insertRegionAtFirst(this.uploadPerformer.currentRegion);
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " \u4f7f\u7528\u7f13\u5b58region");
        } else {
            this.uploadPerformer.switchRegion(this.getCurrentRegion());
        }
        if (this.uploadPerformer != null && this.uploadPerformer.currentRegion != null && this.uploadPerformer.currentRegion.getZoneInfo() != null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " region:" + StringUtils.toNonnullString(this.uploadPerformer.currentRegion.getZoneInfo().regionId));
        }
        if (!this.uploadPerformer.canReadFile()) {
            code = -7;
        }
        return code;
    }

    @Override
    protected boolean switchRegion() {
        boolean isSuccess = super.switchRegion();
        if (isSuccess) {
            this.uploadPerformer.switchRegion(this.getCurrentRegion());
            if (this.uploadPerformer != null && this.uploadPerformer.currentRegion != null && this.uploadPerformer.currentRegion.getZoneInfo() != null) {
                LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " region:" + StringUtils.toNonnullString(this.uploadPerformer.currentRegion.getZoneInfo().regionId));
            }
        }
        return isSuccess;
    }

    @Override
    protected boolean switchRegionAndUploadIfNeededWithErrorResponse(ResponseInfo errorResponseInfo) {
        this.reportBlock();
        return super.switchRegionAndUploadIfNeededWithErrorResponse(errorResponseInfo);
    }

    @Override
    protected boolean reloadUploadInfo() {
        if (!super.reloadUploadInfo()) {
            return false;
        }
        return this.uploadPerformer.couldReloadInfo() && this.uploadPerformer.reloadInfo();
    }

    @Override
    protected void startToUpload() {
        super.startToUpload();
        this.uploadDataErrorResponse = null;
        this.uploadDataErrorResponseInfo = null;
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " serverInit");
        this.serverInit(new UploadFileCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, JSONObject response) {
                if (!responseInfo.isOK()) {
                    if (!PartsUpload.this.switchRegionAndUploadIfNeededWithErrorResponse(responseInfo)) {
                        PartsUpload.this.completeAction(responseInfo, response);
                    }
                    return;
                }
                LogUtil.i("key:" + StringUtils.toNonnullString(PartsUpload.this.key) + " uploadRestData");
                PartsUpload.this.uploadRestData(new UploadFileRestDataCompleteHandler(){

                    @Override
                    public void complete() {
                        if (!PartsUpload.this.isAllUploaded()) {
                            if (!PartsUpload.this.switchRegionAndUploadIfNeededWithErrorResponse(PartsUpload.this.uploadDataErrorResponseInfo)) {
                                PartsUpload.this.completeAction(PartsUpload.this.uploadDataErrorResponseInfo, PartsUpload.this.uploadDataErrorResponse);
                            }
                            return;
                        }
                        if (PartsUpload.this.uploadPerformer.uploadInfo.getSourceSize() == 0L) {
                            ResponseInfo response = ResponseInfo.zeroSize("file is empty");
                            PartsUpload.this.completeAction(response, null);
                            return;
                        }
                        LogUtil.i("key:" + StringUtils.toNonnullString(PartsUpload.this.key) + " completeUpload");
                        PartsUpload.this.completeUpload(new UploadFileCompleteHandler(){

                            @Override
                            public void complete(ResponseInfo responseInfo, JSONObject response) {
                                if (!responseInfo.isOK()) {
                                    if (!PartsUpload.this.switchRegionAndUploadIfNeededWithErrorResponse(responseInfo)) {
                                        PartsUpload.this.completeAction(responseInfo, response);
                                    }
                                    return;
                                }
                                PartsUpload.this.completeAction(responseInfo, response);
                            }
                        });
                    }
                });
            }
        });
    }

    protected void uploadRestData(UploadFileRestDataCompleteHandler completeHandler) {
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " \u4e32\u884c\u5206\u7247");
        this.performUploadRestData(completeHandler);
    }

    protected void performUploadRestData(final UploadFileRestDataCompleteHandler completeHandler) {
        if (this.isAllUploaded()) {
            completeHandler.complete();
            return;
        }
        this.uploadNextData(new UploadFileDataCompleteHandler(){

            @Override
            public void complete(boolean stop, ResponseInfo responseInfo, JSONObject response) {
                if (stop || responseInfo != null && !responseInfo.isOK()) {
                    completeHandler.complete();
                } else {
                    PartsUpload.this.performUploadRestData(completeHandler);
                }
            }
        });
    }

    protected void serverInit(final UploadFileCompleteHandler completeHandler) {
        this.uploadPerformer.serverInit(new PartsUploadPerformer.PartsUploadPerformerCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo != null && !responseInfo.isOK()) {
                    PartsUpload.this.setErrorResponse(responseInfo, response);
                }
                PartsUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                completeHandler.complete(responseInfo, response);
            }
        });
    }

    protected void uploadNextData(final UploadFileDataCompleteHandler completeHandler) {
        this.uploadPerformer.uploadNextData(new PartsUploadPerformer.PartsUploadPerformerDataCompleteHandler(){

            @Override
            public void complete(boolean stop, ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo != null && !responseInfo.isOK()) {
                    PartsUpload.this.setErrorResponse(responseInfo, response);
                }
                PartsUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                completeHandler.complete(stop, responseInfo, response);
            }
        });
    }

    protected void completeUpload(final UploadFileCompleteHandler completeHandler) {
        this.uploadPerformer.completeUpload(new PartsUploadPerformer.PartsUploadPerformerCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo != null && !responseInfo.isOK()) {
                    PartsUpload.this.setErrorResponse(responseInfo, response);
                }
                PartsUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                completeHandler.complete(responseInfo, response);
            }
        });
    }

    @Override
    protected void completeAction(ResponseInfo responseInfo, JSONObject response) {
        this.uploadPerformer.closeFile();
        if (this.shouldRemoveUploadInfoRecord(responseInfo)) {
            this.uploadPerformer.removeUploadInfoRecord();
        }
        super.completeAction(responseInfo, response);
        this.reportBlock();
    }

    private boolean shouldRemoveUploadInfoRecord(ResponseInfo responseInfo) {
        return responseInfo != null && (responseInfo.isOK() || responseInfo.statusCode == 612 || responseInfo.statusCode == 614 || responseInfo.statusCode == 701);
    }

    private void reportBlock() {
        if (this.token == null || !this.token.isValid()) {
            return;
        }
        UploadRegionRequestMetrics metrics = this.getCurrentRegionRequestMetrics();
        if (metrics == null) {
            metrics = new UploadRegionRequestMetrics(null);
        }
        String currentZoneRegionId = null;
        if (this.getCurrentRegion() != null && this.getCurrentRegion().getZoneInfo() != null && this.getCurrentRegion().getZoneInfo().regionId != null) {
            currentZoneRegionId = this.getCurrentRegion().getZoneInfo().regionId;
        }
        String targetZoneRegionId = null;
        if (this.getTargetRegion() != null && this.getTargetRegion().getZoneInfo() != null && this.getTargetRegion().getZoneInfo().regionId != null) {
            targetZoneRegionId = this.getTargetRegion().getZoneInfo().regionId;
        }
        ReportItem item = new ReportItem();
        item.setReport("block", "log_type");
        item.setReport(Utils.currentTimestamp() / 1000L, "up_time");
        item.setReport(this.key, "target_key");
        item.setReport(this.token.bucket, "target_bucket");
        item.setReport(currentZoneRegionId, "target_region_id");
        item.setReport(targetZoneRegionId, "current_region_id");
        item.setReport(metrics.totalElapsedTime(), "total_elapsed_time");
        item.setReport(metrics.bytesSend(), "bytes_sent");
        item.setReport(this.uploadPerformer.recoveredFrom, "recovered_from");
        item.setReport(this.uploadSource.getSize(), "file_size");
        UploadSingleRequestMetrics lastRequestMetrics = metrics.lastMetrics();
        if (lastRequestMetrics != null) {
            item.setReport(lastRequestMetrics.getHijacked(), "hijacking");
        }
        if (this.uploadDataErrorResponseInfo == null && this.uploadSource.getSize() > 0L && metrics.totalElapsedTime() > 0L) {
            item.setReport(Utils.calculateSpeed(this.uploadSource.getSize(), metrics.totalElapsedTime()), "perceptive_speed");
        }
        item.setReport(Utils.getCurrentProcessID(), "pid");
        item.setReport(Utils.getCurrentThreadID(), "tid");
        if (this.config != null && this.config.resumeUploadVersion == Configuration.RESUME_UPLOAD_VERSION_V1) {
            item.setReport(1, "up_api_version");
        } else {
            item.setReport(2, "up_api_version");
        }
        item.setReport(Utils.currentTimestamp(), "client_time");
        item.setReport(Utils.systemName(), "os_name");
        item.setReport(Utils.systemVersion(), "os_version");
        item.setReport(Utils.sdkLanguage(), "sdk_name");
        item.setReport(Utils.sdkVerion(), "sdk_version");
        UploadInfoReporter.getInstance().report(item, this.token.token);
    }

    @Override
    String getUpType() {
        if (this.config == null) {
            return null;
        }
        if (this.config.resumeUploadVersion == Configuration.RESUME_UPLOAD_VERSION_V1) {
            return "resumable_v1<" + this.uploadSource.getSourceType() + ">";
        }
        return "resumable_v2<" + this.uploadSource.getSourceType() + ">";
    }

    protected static interface UploadFileDataCompleteHandler {
        public void complete(boolean var1, ResponseInfo var2, JSONObject var3);
    }

    protected static interface UploadFileCompleteHandler {
        public void complete(ResponseInfo var1, JSONObject var2);
    }

    protected static interface UploadFileRestDataCompleteHandler {
        public void complete();
    }
}

