/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UploadBlock;
import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadInfo;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.BytesUtils;
import com.qiniu.android.utils.ListVector;
import com.qiniu.android.utils.MD5;
import com.qiniu.android.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class UploadInfoV1
extends UploadInfo {
    private static final String TypeKey = "infoType";
    private static final String TypeValue = "UploadInfoV1";
    private static final int BlockSize = 0x400000;
    private static final int BlockListCapacityIncrement = 2;
    private final int dataSize;
    private ListVector<UploadBlock> blockList;
    private boolean isEOF = false;
    private IOException readException = null;

    private UploadInfoV1(UploadSource source, int dataSize, ListVector<UploadBlock> blockList) {
        super(source);
        this.dataSize = dataSize;
        this.blockList = blockList;
    }

    UploadInfoV1(UploadSource source, Configuration configuration) {
        super(source);
        this.dataSize = configuration.useConcurrentResumeUpload || configuration.chunkSize > 0x400000 ? 0x400000 : configuration.chunkSize;
        this.blockList = new ListVector(2, 2);
    }

    static UploadInfoV1 infoFromJson(UploadSource source, JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        int dataSize = 0;
        String type = null;
        ListVector<UploadBlock> blockList = null;
        try {
            type = jsonObject.optString(TypeKey);
            dataSize = jsonObject.getInt("dataSize");
            JSONArray blockJsonArray = jsonObject.getJSONArray("blockList");
            blockList = new ListVector<UploadBlock>(blockJsonArray.length(), 2);
            for (int i = 0; i < blockJsonArray.length(); ++i) {
                JSONObject blockJson = blockJsonArray.getJSONObject(i);
                try {
                    UploadBlock block = UploadBlock.blockFromJson(blockJson);
                    if (block == null) continue;
                    blockList.add(block);
                    continue;
                }
                catch (Exception ignore) {
                    break;
                }
            }
        }
        catch (JSONException ignored) {
            return null;
        }
        UploadInfoV1 info = new UploadInfoV1(source, dataSize, blockList);
        info.setInfoFromJson(jsonObject);
        if (!TypeValue.equals(type) || !source.getId().equals(info.getSourceId())) {
            return null;
        }
        return info;
    }

    boolean isFirstData(UploadData data) {
        return data.index == 0;
    }

    @Override
    boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        final boolean[] isValid = new boolean[]{true};
        this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

            @Override
            public boolean enumerate(UploadBlock block) {
                boolean valid = block.isValid();
                if (!valid) {
                    isValid[0] = false;
                    return true;
                }
                return false;
            }
        });
        return isValid[0];
    }

    @Override
    boolean reloadSource() {
        this.isEOF = false;
        this.readException = null;
        return super.reloadSource();
    }

    @Override
    boolean isSameUploadInfo(UploadInfo info) {
        if (!super.isSameUploadInfo(info)) {
            return false;
        }
        if (!(info instanceof UploadInfoV1)) {
            return false;
        }
        UploadInfoV1 infoV1 = (UploadInfoV1)info;
        return this.dataSize == infoV1.dataSize;
    }

    @Override
    void clearUploadState() {
        if (this.blockList == null || this.blockList.size() == 0) {
            return;
        }
        this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

            @Override
            public boolean enumerate(UploadBlock block) {
                block.clearUploadState();
                return false;
            }
        });
    }

    @Override
    long uploadSize() {
        if (this.blockList == null || this.blockList.size() == 0) {
            return 0L;
        }
        final long[] uploadSize = new long[]{0L};
        this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

            @Override
            public boolean enumerate(UploadBlock block) {
                uploadSize[0] = uploadSize[0] + block.uploadSize();
                return false;
            }
        });
        return uploadSize[0];
    }

    @Override
    boolean isAllUploaded() {
        if (!this.isEOF) {
            return false;
        }
        if (this.blockList == null || this.blockList.size() == 0) {
            return true;
        }
        final boolean[] isAllUploaded = new boolean[]{true};
        this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

            @Override
            public boolean enumerate(UploadBlock block) {
                if (!block.isCompleted()) {
                    isAllUploaded[0] = false;
                    return true;
                }
                return false;
            }
        });
        return isAllUploaded[0];
    }

    @Override
    void checkInfoStateAndUpdate() {
        this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

            @Override
            public boolean enumerate(UploadBlock block) {
                block.checkInfoStateAndUpdate();
                return false;
            }
        });
    }

    @Override
    JSONObject toJsonObject() {
        JSONObject jsonObject = super.toJsonObject();
        if (jsonObject == null) {
            return null;
        }
        try {
            jsonObject.put(TypeKey, (Object)TypeValue);
            jsonObject.put("dataSize", this.dataSize);
            if (this.blockList != null && this.blockList.size() > 0) {
                final JSONArray blockJsonArray = new JSONArray();
                this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

                    @Override
                    public boolean enumerate(UploadBlock block) {
                        try {
                            JSONObject blockJson = block.toJsonObject();
                            if (blockJson != null) {
                                blockJsonArray.put((Object)blockJson);
                            }
                        }
                        catch (Exception e) {
                            return true;
                        }
                        return false;
                    }
                });
                if (blockJsonArray.length() != this.blockList.size()) {
                    return null;
                }
                jsonObject.put("blockList", (Object)blockJsonArray);
            }
        }
        catch (Exception e) {
            return null;
        }
        return jsonObject;
    }

    UploadBlock nextUploadBlock() throws IOException {
        UploadBlock block = this.nextUploadBlockFormBlockList();
        if (block == null) {
            if (this.isEOF) {
                return null;
            }
            if (this.readException != null) {
                throw this.readException;
            }
            long blockOffset = 0L;
            if (this.blockList.size() > 0) {
                UploadBlock lastBlock = (UploadBlock)this.blockList.get(this.blockList.size() - 1);
                blockOffset = lastBlock.offset + (long)lastBlock.size;
            }
            block = new UploadBlock(blockOffset, 0x400000, this.dataSize, this.blockList.size());
        }
        UploadBlock loadBlock = null;
        try {
            loadBlock = this.loadBlockData(block);
        }
        catch (IOException e) {
            this.readException = e;
            throw e;
        }
        if (loadBlock == null) {
            this.isEOF = true;
            if (this.blockList.size() > block.index) {
                this.blockList = this.blockList.subList(0, block.index);
            }
        } else {
            if (loadBlock.index == this.blockList.size()) {
                this.blockList.add(loadBlock);
            } else if (loadBlock != block) {
                this.blockList.set(loadBlock.index, loadBlock);
            }
            if (loadBlock.size < 0x400000) {
                this.isEOF = true;
                if (this.blockList.size() > block.index + 1) {
                    this.blockList = this.blockList.subList(0, block.index + 1);
                }
            }
        }
        return loadBlock;
    }

    private UploadBlock nextUploadBlockFormBlockList() {
        if (this.blockList == null || this.blockList.size() == 0) {
            return null;
        }
        final UploadBlock[] blocks = new UploadBlock[]{null};
        this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

            @Override
            public boolean enumerate(UploadBlock block) {
                UploadData data = block.nextUploadDataWithoutCheckData();
                if (data != null) {
                    blocks[0] = block;
                    return true;
                }
                return false;
            }
        });
        return blocks[0];
    }

    private UploadBlock loadBlockData(UploadBlock block) throws IOException {
        if (block == null) {
            return null;
        }
        UploadData nextUploadData = block.nextUploadDataWithoutCheckData();
        if (nextUploadData.getState() == UploadData.State.WaitToUpload && nextUploadData.data != null) {
            return block;
        }
        byte[] blockBytes = null;
        blockBytes = this.readData(block.size, block.offset);
        if (blockBytes == null || blockBytes.length == 0) {
            return null;
        }
        String md5 = MD5.encrypt(blockBytes);
        if (blockBytes.length != block.size || block.md5 == null || !block.md5.equals(md5)) {
            block = new UploadBlock(block.offset, blockBytes.length, this.dataSize, block.index);
            block.md5 = md5;
        }
        for (UploadData data : block.uploadDataList) {
            if (data.getState() != UploadData.State.Complete) {
                data.data = BytesUtils.subBytes(blockBytes, (int)data.offset, data.size);
                data.updateState(UploadData.State.WaitToUpload);
                continue;
            }
            data.updateState(UploadData.State.Complete);
        }
        return block;
    }

    UploadData nextUploadData(UploadBlock block) throws IOException {
        if (block == null) {
            return null;
        }
        return block.nextUploadDataWithoutCheckData();
    }

    ArrayList<String> allBlocksContexts() {
        if (this.blockList == null || this.blockList.size() == 0) {
            return null;
        }
        final ArrayList<String> contexts = new ArrayList<String>();
        this.blockList.enumerateObjects(new ListVector.EnumeratorHandler<UploadBlock>(){

            @Override
            public boolean enumerate(UploadBlock block) {
                String ctx = block.ctx;
                if (!StringUtils.isNullOrEmpty(ctx)) {
                    contexts.add(ctx);
                }
                return false;
            }
        });
        return contexts;
    }
}

