/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage.serverConfig;

import com.qiniu.android.utils.Cache;
import com.qiniu.android.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerUserConfig
implements Cache.Object {
    private long timestamp;
    private long ttl = 10L;
    private Boolean http3Enable;
    private Boolean networkCheckEnable;
    private JSONObject info;

    public ServerUserConfig(JSONObject info) {
        JSONObject networkCheck;
        JSONObject http3;
        if (info == null) {
            return;
        }
        this.info = info;
        this.ttl = info.optLong("ttl", 300L);
        if (info.opt("timestamp") != null) {
            this.timestamp = info.optLong("timestamp");
        }
        if (this.timestamp == 0L) {
            this.timestamp = Utils.currentSecondTimestamp();
            try {
                info.putOpt("timestamp", (Object)this.timestamp);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((http3 = info.optJSONObject("http3")) != null && http3.opt("enabled") != null) {
            this.http3Enable = http3.optBoolean("enabled");
        }
        if ((networkCheck = info.optJSONObject("network_check")) != null && networkCheck.opt("enabled") != null) {
            this.networkCheckEnable = networkCheck.optBoolean("enabled");
        }
    }

    @Override
    public JSONObject toJson() {
        return this.info;
    }

    public Boolean getHttp3Enable() {
        return this.http3Enable;
    }

    public Boolean getNetworkCheckEnable() {
        return this.networkCheckEnable;
    }

    public JSONObject getInfo() {
        return this.toJson();
    }

    public boolean isValid() {
        return Utils.currentSecondTimestamp() < this.timestamp + this.ttl;
    }
}

