/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request.httpclient;

import com.qiniu.android.http.CancellationHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ProxyConfiguration;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.SystemDns;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.request.IRequestClient;
import com.qiniu.android.http.request.IUploadServer;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.http.request.httpclient.ByteBody;
import com.qiniu.android.http.request.httpclient.CountingRequestBody;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Connection;
import okhttp3.ConnectionPool;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class SystemHttpClient
extends IRequestClient {
    public static final String ContentTypeHeader = "Content-Type";
    public static final String DefaultMime = "application/octet-stream";
    public static final String JsonMime = "application/json";
    public static final String FormMime = "application/x-www-form-urlencoded";
    private boolean hasHandleComplete = false;
    private static ConnectionPool pool;
    private IUploadServer currentServer;
    private Request currentRequest;
    private static final OkHttpClient baseClient;
    private OkHttpClient httpClient;
    private Call call;
    private UploadSingleRequestMetrics metrics;
    private IRequestClient.Progress requestProgress;
    private IRequestClient.CompleteHandler completeHandler;

    public void request(Request request, boolean isAsync, ProxyConfiguration connectionProxy, IRequestClient.Progress progress, IRequestClient.CompleteHandler complete) {
        this.request(request, new IRequestClient.Options(null, isAsync, connectionProxy), progress, complete);
    }

    @Override
    public void request(Request request, IRequestClient.Options options, IRequestClient.Progress progress, IRequestClient.CompleteHandler complete) {
        IUploadServer server = null;
        boolean isAsync = true;
        ProxyConfiguration connectionProxy = null;
        if (options != null) {
            server = options.server;
            isAsync = options.isAsync;
            connectionProxy = options.connectionProxy;
        }
        this.metrics = new UploadSingleRequestMetrics();
        this.metrics.start();
        this.metrics.setClientName(this.getClientId());
        this.metrics.setClientVersion(SystemHttpClient.getOkHttpVersion());
        if (server != null) {
            this.currentServer = server;
            this.metrics.setRemoteAddress(server.getIp());
            this.metrics.setSyncDnsSource(server.getSource());
        }
        this.metrics.setRequest(request);
        this.currentRequest = request;
        this.requestProgress = progress;
        this.completeHandler = complete;
        this.httpClient = this.createHttpClient(connectionProxy);
        Request.Builder requestBuilder = this.createRequestBuilder(this.requestProgress);
        if (requestBuilder == null) {
            ResponseInfo responseInfo = ResponseInfo.invalidArgument("invalid http request");
            this.handleError(request, responseInfo.statusCode, responseInfo.message, complete);
            return;
        }
        this.call = this.httpClient.newCall(requestBuilder.build());
        if (isAsync) {
            this.call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    e.printStackTrace();
                    String msg = e.getMessage();
                    int status = SystemHttpClient.this.getStatusCodeByException(e);
                    if (call.isCanceled()) {
                        status = -2;
                        msg = "user cancelled";
                    }
                    SystemHttpClient.this.handleError(SystemHttpClient.this.currentRequest, status, msg, SystemHttpClient.this.completeHandler);
                }

                public void onResponse(Call call, final Response response) throws IOException {
                    AsyncRun.runInBack(new Runnable(){

                        @Override
                        public void run() {
                            SystemHttpClient.this.handleResponse(SystemHttpClient.this.currentRequest, response, SystemHttpClient.this.completeHandler);
                        }
                    });
                }
            });
        } else {
            try {
                Response response = this.call.execute();
                this.handleResponse(request, response, complete);
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = e.getMessage();
                int status = this.getStatusCodeByException(e);
                if (this.call.isCanceled()) {
                    status = -2;
                    msg = "user cancelled";
                }
                this.handleError(request, status, msg, complete);
            }
        }
    }

    @Override
    public synchronized void cancel() {
        if (this.call != null && !this.call.isCanceled()) {
            this.call.cancel();
        }
    }

    @Override
    public String getClientId() {
        return "okhttp";
    }

    private OkHttpClient createHttpClient(ProxyConfiguration connectionProxy) {
        if (this.currentRequest == null) {
            return null;
        }
        OkHttpClient.Builder clientBuilder = baseClient.newBuilder();
        if (connectionProxy != null) {
            clientBuilder.proxy(connectionProxy.proxy());
            if (connectionProxy.user != null && connectionProxy.password != null) {
                clientBuilder.proxyAuthenticator(connectionProxy.authenticator());
            }
        }
        clientBuilder.eventListener(this.createEventLister());
        if (GlobalConfiguration.getInstance().isDnsOpen) {
            clientBuilder.dns(new Dns(){

                public List<InetAddress> lookup(String s) throws UnknownHostException {
                    if (SystemHttpClient.this.currentServer != null && s.equals(SystemHttpClient.this.currentServer.getHost())) {
                        InetAddress address = SystemHttpClient.this.currentServer.getInetAddress();
                        if (address != null) {
                            ArrayList<InetAddress> inetAddressList = new ArrayList<InetAddress>();
                            inetAddressList.add(address);
                            return inetAddressList;
                        }
                        return new SystemDns().lookupInetAddress(s);
                    }
                    return new SystemDns().lookupInetAddress(s);
                }
            });
        }
        clientBuilder.connectionPool(SystemHttpClient.getConnectPool());
        clientBuilder.connectTimeout((long)this.currentRequest.connectTimeout, TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)this.currentRequest.readTimeout, TimeUnit.SECONDS);
        clientBuilder.writeTimeout((long)this.currentRequest.writeTimeout, TimeUnit.SECONDS);
        return clientBuilder.build();
    }

    private static synchronized ConnectionPool getConnectPool() {
        if (pool == null) {
            pool = new ConnectionPool(10, 10L, TimeUnit.MINUTES);
        }
        return pool;
    }

    private Request.Builder createRequestBuilder(final IRequestClient.Progress progress) {
        if (this.currentRequest == null) {
            return null;
        }
        Headers allHeaders = Headers.of(this.currentRequest.allHeaders);
        Request.Builder requestBuilder = null;
        if (this.currentRequest.httpMethod.equals("HEAD") || this.currentRequest.httpMethod.equals("GET")) {
            requestBuilder = new Request.Builder().get().url(this.currentRequest.urlString);
            for (String key : this.currentRequest.allHeaders.keySet()) {
                String value = this.currentRequest.allHeaders.get(key);
                requestBuilder.header(key, value);
            }
        } else if (this.currentRequest.httpMethod.equals("POST") || this.currentRequest.httpMethod.equals("PUT")) {
            RequestBody rbody;
            requestBuilder = new Request.Builder().url(this.currentRequest.urlString);
            requestBuilder = requestBuilder.headers(allHeaders);
            if (this.currentRequest.httpBody.length > 0) {
                MediaType type = MediaType.parse((String)DefaultMime);
                String contentType = this.currentRequest.allHeaders.get(ContentTypeHeader);
                if (contentType != null) {
                    type = MediaType.parse((String)contentType);
                }
                rbody = new ByteBody(type, this.currentRequest.httpBody);
            } else {
                rbody = new ByteBody(null, new byte[0]);
            }
            rbody = new CountingRequestBody(rbody, new ProgressHandler(){

                @Override
                public void onProgress(long bytesWritten, long totalSize) {
                    if (progress != null) {
                        progress.progress(bytesWritten, totalSize);
                    }
                }
            }, this.currentRequest.httpBody.length, null);
            if (this.currentRequest.httpMethod.equals("POST")) {
                requestBuilder = requestBuilder.post(rbody);
            } else if (this.currentRequest.httpMethod.equals("PUT")) {
                requestBuilder = requestBuilder.put(rbody);
            }
        }
        return requestBuilder;
    }

    private EventListener createEventLister() {
        return new EventListener(){

            public void callStart(Call call) {
            }

            public void dnsStart(Call call, String domainName) {
                SystemHttpClient.this.metrics.setDomainLookupStartDate(new Date());
            }

            public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
                SystemHttpClient.this.metrics.setDomainLookupEndDate(new Date());
            }

            public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
                SystemHttpClient.this.metrics.setConnectStartDate(new Date());
                if (inetSocketAddress != null && inetSocketAddress.getAddress() != null) {
                    SystemHttpClient.this.metrics.setRemoteAddress(inetSocketAddress.getAddress().getHostAddress());
                    SystemHttpClient.this.metrics.setRemotePort(inetSocketAddress.getPort());
                }
            }

            public void secureConnectStart(Call call) {
                SystemHttpClient.this.metrics.setConnectEndDate(new Date());
            }

            public void secureConnectEnd(Call call, Handshake handshake) {
                SystemHttpClient.this.metrics.setSecureConnectionStartDate(new Date());
            }

            public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
                SystemHttpClient.this.metrics.setSecureConnectionEndDate(new Date());
            }

            public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
                SystemHttpClient.this.metrics.setConnectEndDate(new Date());
            }

            public void connectionAcquired(Call call, Connection connection) {
            }

            public void connectionReleased(Call call, Connection connection) {
            }

            public void requestHeadersStart(Call call) {
                SystemHttpClient.this.metrics.setRequestStartDate(new Date());
            }

            public void requestHeadersEnd(Call call, okhttp3.Request request) {
                SystemHttpClient.this.metrics.setCountOfRequestHeaderBytesSent(request.headers().toString().length());
            }

            public void requestBodyStart(Call call) {
            }

            public void requestBodyEnd(Call call, long byteCount) {
                SystemHttpClient.this.metrics.setRequestEndDate(new Date());
                SystemHttpClient.this.metrics.setCountOfRequestBodyBytesSent(byteCount);
            }

            public void requestFailed(Call call, IOException ioe) {
                SystemHttpClient.this.metrics.setCountOfRequestBodyBytesSent(0L);
            }

            public void responseHeadersStart(Call call) {
                SystemHttpClient.this.metrics.setResponseStartDate(new Date());
            }

            public void responseHeadersEnd(Call call, Response response) {
                Headers headers = response.headers();
                if (headers != null && headers.byteCount() > 0L) {
                    SystemHttpClient.this.metrics.setCountOfResponseHeaderBytesReceived(headers.byteCount());
                }
            }

            public void responseBodyStart(Call call) {
            }

            public void responseBodyEnd(Call call, long byteCount) {
                SystemHttpClient.this.metrics.setResponseEndDate(new Date());
                SystemHttpClient.this.metrics.setCountOfResponseBodyBytesReceived(byteCount);
            }

            public void responseFailed(Call call, IOException ioe) {
                SystemHttpClient.this.metrics.setResponseEndDate(new Date());
            }

            public void callEnd(Call call) {
                SystemHttpClient.this.metrics.end();
            }

            public void callFailed(Call call, IOException ioe) {
                SystemHttpClient.this.metrics.end();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(Request request, int responseCode, String errorMsg, IRequestClient.CompleteHandler complete) {
        SystemHttpClient systemHttpClient = this;
        synchronized (systemHttpClient) {
            if (this.hasHandleComplete) {
                return;
            }
            this.hasHandleComplete = true;
        }
        ResponseInfo info = ResponseInfo.create(request, responseCode, null, null, errorMsg);
        this.metrics.setResponse(info);
        this.metrics.setRequest(request);
        this.metrics.end();
        complete.complete(info, this.metrics, info.response);
        this.releaseResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(Request request, Response response, IRequestClient.CompleteHandler complete) {
        SystemHttpClient systemHttpClient = this;
        synchronized (systemHttpClient) {
            if (this.hasHandleComplete) {
                return;
            }
            this.hasHandleComplete = true;
        }
        int statusCode = response.code();
        HashMap<String, String> responseHeader = new HashMap<String, String>();
        int headerCount = response.headers().size();
        for (int i = 0; i < headerCount; ++i) {
            String name = response.headers().name(i).toLowerCase();
            String value = response.headers().value(i);
            responseHeader.put(name, value);
        }
        byte[] responseBody = null;
        JSONObject responseJson = null;
        String errorMessage = null;
        try {
            responseBody = response.body().bytes();
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        if (responseBody == null) {
            errorMessage = response.message();
        } else if (!SystemHttpClient.responseContentType(response).equals(JsonMime)) {
            String responseString = new String(responseBody);
            if (!responseString.isEmpty()) {
                try {
                    responseJson = new JSONObject();
                    responseJson.put("error", (Object)responseString);
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                responseJson = SystemHttpClient.buildJsonResp(responseBody);
            }
            catch (Exception e) {
                statusCode = -1015;
                errorMessage = e.getMessage();
            }
        }
        ResponseInfo info = ResponseInfo.create(request, statusCode, responseHeader, responseJson, errorMessage);
        this.metrics.setResponse(info);
        this.metrics.setRequest(request);
        if (response.protocol() == Protocol.HTTP_1_0) {
            this.metrics.setHttpVersion("1.0");
        } else if (response.protocol() == Protocol.HTTP_1_1) {
            this.metrics.setHttpVersion("1.1");
        } else if (response.protocol() == Protocol.HTTP_2) {
            this.metrics.setHttpVersion("2");
        }
        this.metrics.end();
        complete.complete(info, this.metrics, info.response);
        this.releaseResource();
    }

    private void releaseResource() {
        this.currentRequest = null;
        this.requestProgress = null;
        this.completeHandler = null;
        this.metrics = null;
        this.httpClient = null;
        this.call = null;
    }

    private static String responseContentType(Response response) {
        MediaType mediaType = response.body().contentType();
        if (mediaType == null) {
            return "";
        }
        return mediaType.type() + "/" + mediaType.subtype();
    }

    private int getStatusCodeByException(Exception e) {
        int statusCode = -1;
        String msg = e.getMessage();
        if (msg != null && msg.contains("Canceled")) {
            statusCode = -2;
        } else if (e instanceof CancellationHandler.CancellationException) {
            statusCode = -2;
        } else if (e instanceof UnknownHostException) {
            statusCode = -1003;
        } else if (msg != null && msg.indexOf("Broken pipe") == 0) {
            statusCode = -1005;
        } else if (e instanceof SocketTimeoutException) {
            statusCode = -1001;
        } else if (e instanceof ConnectException) {
            statusCode = -1004;
        } else if (e instanceof ProtocolException) {
            statusCode = 100;
        } else if (e instanceof SSLException) {
            statusCode = -1200;
        }
        return statusCode;
    }

    private static JSONObject buildJsonResp(byte[] body) throws Exception {
        String str = new String(body, "utf-8");
        if (StringUtils.isNullOrEmpty(str)) {
            return new JSONObject();
        }
        return new JSONObject(str);
    }

    private static String getOkHttpVersion() {
        try {
            Class<?> clazz = Class.forName("okhttp3.OkHttp");
            Field versionField = clazz.getField("VERSION");
            Object version = versionField.get(clazz);
            return version + "";
        }
        catch (Exception clazz) {
            try {
                Class<?> clazz2 = Class.forName("okhttp3.internal.Version");
                Field versionField = clazz2.getField("userAgent");
                Object version = versionField.get(clazz2);
                return (version + "").replace("okhttp/", "");
            }
            catch (Exception clazz2) {
                try {
                    Class<?> clazz3 = Class.forName("okhttp3.internal.Version");
                    Method get = clazz3.getMethod("userAgent", new Class[0]);
                    Object version = get.invoke(clazz3, new Object[0]);
                    return (version + "").replace("okhttp/", "");
                }
                catch (Exception exception) {
                    return "";
                }
            }
        }
    }

    static {
        baseClient = new OkHttpClient();
    }

    private static class ResponseTag {
        public String ip = "";
        public long duration = -1L;

        private ResponseTag() {
        }
    }
}

