/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.PartsUploadPerformer;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadBlock;
import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadInfo;
import com.qiniu.android.storage.UploadInfoV1;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

class PartsUploadPerformerV1
extends PartsUploadPerformer {
    PartsUploadPerformerV1(UploadSource uploadSource, String fileName, String key, UpToken token, UploadOptions options, Configuration config, String recorderKey) {
        super(uploadSource, fileName, key, token, options, config, recorderKey);
    }

    @Override
    UploadInfo getUploadInfoFromJson(UploadSource source, JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return UploadInfoV1.infoFromJson(source, jsonObject);
    }

    @Override
    UploadInfo getDefaultUploadInfo() {
        return new UploadInfoV1(this.uploadSource, this.config);
    }

    @Override
    void serverInit(PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        ResponseInfo responseInfo = ResponseInfo.successResponse();
        completeHandler.complete(responseInfo, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void uploadNextData(final PartsUploadPerformer.PartsUploadPerformerDataCompleteHandler completeHandler) {
        ResponseInfo responseInfo;
        UploadInfoV1 info = (UploadInfoV1)this.uploadInfo;
        UploadBlock block = null;
        UploadData chunk = null;
        UploadSource uploadSource = this.uploadSource;
        synchronized (uploadSource) {
            try {
                block = info.nextUploadBlock();
                chunk = info.nextUploadData(block);
                if (chunk != null) {
                    chunk.updateState(UploadData.State.Uploading);
                }
            }
            catch (Exception e) {
                LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + e.getMessage());
                ResponseInfo responseInfo2 = ResponseInfo.localIOError(e.getMessage());
                completeHandler.complete(true, responseInfo2, null, null);
                return;
            }
        }
        if (block == null || chunk == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " no chunk left");
            responseInfo = null;
            responseInfo = this.uploadInfo.getSourceSize() == 0L ? ResponseInfo.zeroSize("file is empty") : ResponseInfo.sdkInteriorError("no chunk left");
            completeHandler.complete(true, responseInfo, null, null);
            return;
        }
        if (chunk.data == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " get chunk null");
            responseInfo = ResponseInfo.invalidArgument("chunk data is null");
            completeHandler.complete(true, responseInfo, null, null);
            return;
        }
        final UploadBlock uploadBlock = block;
        final UploadData uploadChunk = chunk;
        RequestProgressHandler progressHandler = new RequestProgressHandler(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                uploadChunk.setUploadSize(totalBytesWritten);
                PartsUploadPerformerV1.this.notifyProgress(false);
            }
        };
        PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandlerP = new PartsUploadPerformer.PartsUploadPerformerCompleteHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                String ctx = null;
                Long expiredAt = null;
                if (response != null) {
                    try {
                        ctx = response.getString("ctx");
                        expiredAt = response.getLong("expired_at");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && ctx != null && expiredAt != null) {
                    UploadSource uploadSource = PartsUploadPerformerV1.this.uploadSource;
                    synchronized (uploadSource) {
                        uploadBlock.ctx = ctx;
                        uploadBlock.expireAt = expiredAt;
                        uploadChunk.updateState(UploadData.State.Complete);
                    }
                    PartsUploadPerformerV1.this.recordUploadInfo();
                    PartsUploadPerformerV1.this.notifyProgress(false);
                } else {
                    UploadSource uploadSource = PartsUploadPerformerV1.this.uploadSource;
                    synchronized (uploadSource) {
                        uploadChunk.updateState(UploadData.State.WaitToUpload);
                    }
                }
                completeHandler.complete(false, responseInfo, requestMetrics, response);
            }
        };
        if (info.isFirstData(uploadChunk)) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " makeBlock");
            this.makeBlock(uploadBlock, uploadChunk, progressHandler, completeHandlerP);
        } else {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " uploadChunk");
            this.uploadChunk(uploadBlock, uploadChunk, progressHandler, completeHandlerP);
        }
    }

    @Override
    void completeUpload(final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        UploadInfoV1 info = (UploadInfoV1)this.uploadInfo;
        String[] contexts = null;
        ArrayList<String> contextsList = info.allBlocksContexts();
        if (contextsList != null && contextsList.size() > 0) {
            contexts = contextsList.toArray(new String[contextsList.size()]);
        }
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.makeFile(info.getSourceSize(), this.fileName, contexts, true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo.isOK()) {
                    PartsUploadPerformerV1.this.notifyProgress(true);
                }
                PartsUploadPerformerV1.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    private void makeBlock(UploadBlock block, UploadData chunk, RequestProgressHandler progressHandler, final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.makeBlock(block.offset, block.size, chunk.data, true, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                PartsUploadPerformerV1.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    private void uploadChunk(UploadBlock block, UploadData chunk, RequestProgressHandler progressHandler, final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.uploadChunk(block.ctx, block.offset, chunk.data, chunk.offset, true, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                PartsUploadPerformerV1.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }
}

