/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import com.qiniu.android.storage.FileRecorder;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.Utils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class Cache {
    private final int flushCount;
    private final String version;
    private final Class<?> objectClass;
    private boolean isFlushing = false;
    private int needFlushCount = 0;
    private final ConcurrentHashMap<String, Object> memCache = new ConcurrentHashMap();
    private final FileRecorder diskCache;

    private Cache(Class<?> objectClass, int flushCount, String version) {
        this.objectClass = objectClass;
        this.flushCount = flushCount;
        this.version = version;
        FileRecorder fileRecorder = null;
        try {
            if (objectClass != null) {
                fileRecorder = new FileRecorder(Utils.sdkDirectory() + "/" + objectClass.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.diskCache = fileRecorder;
        this.load();
    }

    private void load() {
        if (this.diskCache == null || this.objectClass == null) {
            return;
        }
        byte[] cacheData = this.diskCache.get(this.version);
        if (cacheData == null || cacheData.length == 0) {
            return;
        }
        try {
            JSONObject cacheJson = new JSONObject(new String(cacheData));
            Iterator it = cacheJson.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                try {
                    JSONObject jsonObject = cacheJson.getJSONObject(key);
                    Constructor<?> constructor = this.objectClass.getConstructor(JSONObject.class);
                    Object object = (Object)constructor.newInstance(jsonObject);
                    this.memCache.put(key, object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object cacheForKey(String cacheKey) {
        return this.memCache.get(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(String cacheKey, Object object, boolean atomically) {
        if (StringUtils.isNullOrEmpty(cacheKey) || object == null) {
            return;
        }
        this.memCache.put(cacheKey, object);
        Cache cache = this;
        synchronized (cache) {
            ++this.needFlushCount;
        }
        if (this.needFlushCount >= this.flushCount) {
            this.flush(atomically);
        }
    }

    public Map<String, Object> allMemoryCache() {
        return new HashMap<String, Object>(this.memCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean atomically) {
        Cache cache = this;
        synchronized (cache) {
            if (this.isFlushing) {
                return;
            }
            this.isFlushing = true;
            this.needFlushCount = 0;
        }
        final HashMap<String, Object> flushCache = new HashMap<String, Object>(this.memCache);
        if (atomically) {
            this.flushCache(flushCache);
        } else {
            AsyncRun.runInBack(new Runnable(){

                @Override
                public void run() {
                    Cache.this.flushCache(flushCache);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCache(Map<String, Object> flushCache) {
        if (this.diskCache == null || flushCache == null || flushCache.isEmpty()) {
            return;
        }
        JSONObject cacheJson = new JSONObject();
        for (String key : flushCache.keySet()) {
            Object object = flushCache.get(key);
            if (object == null) continue;
            try {
                JSONObject jsonObject = object.toJson();
                if (jsonObject == null) continue;
                cacheJson.put(key, (java.lang.Object)jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[] cacheData = cacheJson.toString().getBytes();
        if (cacheData == null || cacheData.length == 0) {
            return;
        }
        this.diskCache.set(this.version, cacheData);
        Cache cache = this;
        synchronized (cache) {
            this.isFlushing = false;
        }
    }

    public void clearMemoryCache() {
        this.memCache.clear();
    }

    public void clearDiskCache() {
        this.diskCache.deleteAll();
    }

    public static interface Object {
        public JSONObject toJson();
    }

    public static class Builder {
        private int flushCount = 1;
        private String version = "v1.0.0";
        private final Class<?> objectClass;

        public Builder(Class<?> objectClass) {
            this.objectClass = objectClass;
        }

        public Builder setFlushCount(int flushCount) {
            this.flushCount = flushCount;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Cache builder() {
            return new Cache(this.objectClass, this.flushCount, this.version);
        }
    }
}

