/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.fop;

import com.qiniu.api.auth.AuthException;
import com.qiniu.api.auth.digest.Mac;
import com.qiniu.api.net.CallRet;
import com.qiniu.api.net.Client;
import com.qiniu.api.rs.GetPolicy;

public class ImageView {
    public int mode;
    public int width;
    public int height;
    public int quality;
    public String format;

    public String makeParams() {
        StringBuilder params = new StringBuilder();
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalArgumentException("Mode value must be 1 or 2!");
        }
        params.append("/" + this.mode);
        if (this.width > 0) {
            params.append("/w/" + this.width);
        }
        if (this.height > 0) {
            params.append("/h/" + this.height);
        }
        if (this.quality > 0) {
            params.append("/q/" + this.quality);
        }
        if (this.format != null && this.format != "") {
            params.append("/format/" + this.format);
        }
        return params.toString();
    }

    public String makeRequest(String url) {
        return url + "?imageView" + this.makeParams();
    }

    public CallRet call(String url) {
        CallRet ret = new Client().call(this.makeRequest(url));
        return ret;
    }

    public CallRet call(String url, Mac mac) throws AuthException {
        String pubUrl = this.makeRequest(url);
        GetPolicy policy = new GetPolicy();
        String priUrl = policy.makeRequest(pubUrl, mac);
        CallRet ret = new Client().call(priUrl);
        return ret;
    }
}

