/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.net;

import com.qiniu.api.auth.AuthException;
import com.qiniu.api.net.CallRet;
import com.qiniu.api.net.Http;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.util.EntityUtils;

public class Client {
    private static final String HEADER_AGENT = "User-Agent";

    public void setAuth(HttpPost post) throws AuthException {
    }

    public static HttpPost newPost(String url) {
        HttpPost postMethod = new HttpPost(url);
        postMethod.setHeader(HEADER_AGENT, Client.getUserAgent());
        return postMethod;
    }

    private static String getUserAgent() {
        String javaVersion = "Java/" + System.getProperty("java.version");
        String os = System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        String sdk = "QiniuJava/6.1.9";
        return sdk + " (" + os + ") " + javaVersion;
    }

    public CallRet call(String url) {
        HttpClient client = Http.getClient();
        HttpPost postMethod = Client.newPost(url);
        try {
            this.setAuth(postMethod);
            HttpResponse response = client.execute((HttpUriRequest)postMethod);
            return this.handleResult(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CallRet(0, e);
        }
    }

    public CallRet call(String url, List<NameValuePair> nvps) {
        HttpClient client = Http.getClient();
        HttpPost postMethod = Client.newPost(url);
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, "UTF-8");
            entity.setContentType("application/x-www-form-urlencoded");
            postMethod.setEntity((HttpEntity)entity);
            this.setAuth(postMethod);
            HttpResponse response = client.execute((HttpUriRequest)postMethod);
            return this.handleResult(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CallRet(0, e);
        }
    }

    public CallRet callWithBinary(String url, AbstractHttpEntity entity) {
        HttpClient client = Http.getClient();
        HttpPost postMethod = Client.newPost(url);
        postMethod.setEntity((HttpEntity)entity);
        try {
            this.setAuth(postMethod);
            HttpResponse response = client.execute((HttpUriRequest)postMethod);
            return this.handleResult(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CallRet(0, e);
        }
    }

    public CallRet callWithBinary(String url, String contentType, byte[] body) {
        ByteArrayEntity entity = new ByteArrayEntity(body);
        if (contentType == null || contentType.isEmpty()) {
            contentType = "application/octet-stream";
        }
        entity.setContentType(contentType);
        return this.callWithBinary(url, (AbstractHttpEntity)entity);
    }

    public CallRet callWithMultiPart(String url, MultipartEntity requestEntity) {
        HttpPost postMethod = Client.newPost(url);
        postMethod.setEntity((HttpEntity)requestEntity);
        HttpClient client = Http.getClient();
        try {
            HttpResponse response = client.execute((HttpUriRequest)postMethod);
            return this.handleResult(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CallRet(0, e);
        }
    }

    private CallRet handleResult(HttpResponse response) {
        String responseBody;
        if (response == null || response.getStatusLine() == null) {
            return new CallRet(0, "No response");
        }
        try {
            responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CallRet(0, e);
        }
        StatusLine status = response.getStatusLine();
        int statusCode = status == null ? 0 : status.getStatusCode();
        return new CallRet(statusCode, responseBody);
    }
}

