/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.resumableio;

import com.qiniu.api.resumableio.RandomAccessFileUploadBlock;
import com.qiniu.api.resumableio.SliceUpload;
import com.qiniu.api.resumableio.UploadBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RandomAccessFileUpload
extends SliceUpload {
    protected RandomAccessFile file;
    private final Lock fileUploadLock;
    private String resumeKey;
    private int currentBlockIdx = 0;

    public RandomAccessFileUpload(File file, String token, String key, String mimeType) {
        super(token, key, mimeType);
        try {
            this.contentLength = file.length();
            this.file = new RandomAccessFile(file, "r");
            this.fileUploadLock = new ReentrantLock();
            this.resumeKey = key;
            if (this.resumeKey == null) {
                this.resumeKey = file.getAbsolutePath();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean hasNext() {
        return this.contentLength > (long)(this.currentBlockIdx * 0x400000);
    }

    @Override
    protected UploadBlock buildNextBlockUpload() throws IOException {
        long start = this.currentBlockIdx * 0x400000;
        int len = (int)Math.min(0x400000L, this.contentLength - start);
        RandomAccessFileUploadBlock fb = new RandomAccessFileUploadBlock(this, this.httpClient, this.host, this.currentBlockIdx, start, len, this.file, this.fileUploadLock);
        ++this.currentBlockIdx;
        return fb;
    }

    @Override
    protected void clean() throws Exception {
        if (this.file != null) {
            this.file.close();
        }
    }
}

