/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.google.gson.Gson;
import com.qiniu.common.Config;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.model.ResumeBlockInfo;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class ResumeUploader {
    private final String upToken;
    private final String key;
    private final File f;
    private final long size;
    private final StringMap params;
    private final String mime;
    private final String[] contexts;
    private final Client client;
    private final byte[] blockBuffer;
    private FileInputStream file;
    private String host;
    private final Recorder recorder;
    private final String recorderKey;
    private final long modifyTime;
    private final RecordHelper helper;

    ResumeUploader(Client client, String upToken, String key, File file, StringMap params, String mime, Recorder recorder, String recorderKey) {
        this.client = client;
        this.upToken = upToken;
        this.key = key;
        this.f = file;
        this.size = file.length();
        this.params = params;
        this.mime = mime == null ? "application/octet-stream" : mime;
        this.host = Config.UP_HOST;
        long count = (this.size + 0x400000L - 1L) / 0x400000L;
        this.contexts = new String[(int)count];
        this.blockBuffer = new byte[0x400000];
        this.recorder = recorder;
        this.recorderKey = recorderKey;
        this.modifyTime = this.f.lastModified();
        this.helper = new RecordHelper();
    }

    public Response upload() throws QiniuException {
        Response response;
        long uploaded = this.helper.recoveryFromRecord();
        try {
            this.file = new FileInputStream(this.f);
        }
        catch (FileNotFoundException e) {
            throw new QiniuException(e);
        }
        boolean retry = false;
        int contextIndex = 0;
        while (uploaded < this.size) {
            int blockSize = this.nextBlockSize(uploaded);
            try {
                this.file.read(this.blockBuffer, 0, blockSize);
            }
            catch (IOException e) {
                this.close();
                throw new QiniuException(e);
            }
            response = null;
            try {
                response = this.makeBlock(this.blockBuffer, blockSize);
            }
            catch (QiniuException e) {
                if (e.code() < 0) {
                    this.host = Config.UP_HOST_BACKUP;
                }
                if (e.response == null || e.response.needRetry()) {
                    retry = true;
                }
                this.close();
                throw e;
            }
            if (retry) {
                try {
                    response = this.makeBlock(this.blockBuffer, blockSize);
                    retry = false;
                }
                catch (QiniuException e) {
                    this.close();
                    throw e;
                }
            }
            ResumeBlockInfo blockInfo = response.jsonToObject(ResumeBlockInfo.class);
            this.contexts[contextIndex++] = blockInfo.ctx;
            this.helper.record(uploaded += (long)blockSize);
        }
        this.close();
        try {
            Response blockSize = this.makeFile();
            return blockSize;
        }
        catch (QiniuException e) {
            response = this.makeFile();
            return response;
        }
        finally {
            this.helper.removeRecord();
        }
    }

    private Response makeBlock(byte[] block, int blockSize) throws QiniuException {
        String url = this.host + "/mkblk/" + blockSize;
        return this.post(url, block, 0, blockSize);
    }

    private void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String fileUrl() {
        String url = this.host + "/mkfile/" + this.size + "/mimeType/" + UrlSafeBase64.encodeToString(this.mime);
        final StringBuilder b = new StringBuilder(url);
        if (this.key != null) {
            b.append("/key/");
            b.append(UrlSafeBase64.encodeToString(this.key));
        }
        if (this.params != null) {
            this.params.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    b.append("/");
                    b.append(key);
                    b.append("/");
                    b.append(value);
                }
            });
        }
        return b.toString();
    }

    private Response makeFile() throws QiniuException {
        String url = this.fileUrl();
        String s = StringUtils.join(this.contexts, ",");
        return this.post(url, StringUtils.utf8Bytes(s));
    }

    private Response post(String url, byte[] data) throws QiniuException {
        return this.client.post(url, data, new StringMap().put("Authorization", "UpToken " + this.upToken));
    }

    private Response post(String url, byte[] data, int offset, int size) throws QiniuException {
        return this.client.post(url, data, offset, size, new StringMap().put("Authorization", "UpToken " + this.upToken), "application/octet-stream");
    }

    private int nextBlockSize(long uploaded) {
        if (this.size < uploaded + 0x400000L) {
            return (int)(this.size - uploaded);
        }
        return 0x400000;
    }

    private class RecordHelper {
        private RecordHelper() {
        }

        long recoveryFromRecord() {
            try {
                return this.recoveryFromRecord0();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0L;
            }
        }

        long recoveryFromRecord0() {
            if (ResumeUploader.this.recorder == null) {
                return 0L;
            }
            byte[] data = ResumeUploader.this.recorder.get(ResumeUploader.this.recorderKey);
            if (data == null) {
                return 0L;
            }
            String jsonStr = new String(data);
            Record r = (Record)new Gson().fromJson(jsonStr, Record.class);
            if (r.offset == 0L || r.modify_time != ResumeUploader.this.modifyTime || r.size != ResumeUploader.this.size || r.contexts == null || r.contexts.length == 0) {
                return 0L;
            }
            for (int i = 0; i < r.contexts.length; ++i) {
                ((ResumeUploader)ResumeUploader.this).contexts[i] = r.contexts[i];
            }
            return r.offset;
        }

        void removeRecord() {
            try {
                if (ResumeUploader.this.recorder != null) {
                    ResumeUploader.this.recorder.del(ResumeUploader.this.recorderKey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void record(long offset) {
            try {
                if (ResumeUploader.this.recorder == null || offset == 0L) {
                    return;
                }
                String data = new Gson().toJson((Object)new Record(ResumeUploader.this.size, offset, ResumeUploader.this.modifyTime, ResumeUploader.this.contexts));
                ResumeUploader.this.recorder.set(ResumeUploader.this.recorderKey, data.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private class Record {
            long size;
            long offset;
            long modify_time;
            String[] contexts;

            Record() {
            }

            Record(long size, long offset, long modify_time, String[] contexts) {
                this.size = size;
                this.offset = offset;
                this.modify_time = modify_time;
                this.contexts = contexts;
            }
        }
    }
}

