/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.http;

import com.qiniu.common.QiniuException;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.squareup.okhttp.MediaType;
import java.io.IOException;
import java.util.Locale;

public final class Response {
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final double duration;
    public final String address;
    private byte[] body;
    private com.squareup.okhttp.Response response;

    private Response(com.squareup.okhttp.Response response, int statusCode, String reqId, String xlog, String xvia, String address, double duration, String error, byte[] body) {
        this.response = response;
        this.statusCode = statusCode;
        this.reqId = reqId;
        this.xlog = xlog;
        this.xvia = xvia;
        this.duration = duration;
        this.error = error;
        this.address = address;
        this.body = body;
    }

    static Response create(com.squareup.okhttp.Response response, String address, double duration) {
        byte[] body;
        String reqId;
        int code;
        String error;
        block4: {
            error = null;
            code = response.code();
            reqId = null;
            body = null;
            if (Response.ctype(response).equals("application/json")) {
                reqId = response.header("X-Reqid");
                reqId = reqId == null ? null : reqId.trim();
                try {
                    body = response.body().bytes();
                    if (response.code() >= 400 && !StringUtils.isNullOrEmpty(reqId) && body != null) {
                        ErrorBody errorBody = Json.decode(new String(body), ErrorBody.class);
                        error = errorBody.error;
                    }
                }
                catch (Exception e) {
                    if (response.code() >= 300) break block4;
                    error = e.getMessage();
                }
            }
        }
        return new Response(response, code, reqId, response.header("X-Log"), Response.via(response), address, duration, error, body);
    }

    private static String via(com.squareup.okhttp.Response response) {
        String via = response.header("X-Via", "");
        if (!via.equals("")) {
            return via;
        }
        via = response.header("X-Px", "");
        if (!via.equals("")) {
            return via;
        }
        via = response.header("Fw-Via", "");
        if (!via.equals("")) {
            return via;
        }
        return via;
    }

    private static String ctype(com.squareup.okhttp.Response response) {
        MediaType mediaType = response.body().contentType();
        if (mediaType == null) {
            return "";
        }
        return mediaType.type() + "/" + mediaType.subtype();
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && this.reqId != null && this.reqId.length() > 0;
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean needSwitchServer() {
        return this.isNetworkBroken() || this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579;
    }

    public boolean needRetry() {
        return this.isNetworkBroken() || this.isServerError() || this.statusCode == 406 || this.statusCode == 200 && this.error != null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ResponseInfo:%s,status:%d, reqId:%s, xlog:%s, xvia:%s, adress:%s, duration:%f s, error:%s}", super.toString(), this.statusCode, this.reqId, this.xlog, this.xvia, this.address, this.duration, this.error);
    }

    public <T> T jsonToObject(Class<T> classOfT) throws QiniuException {
        if (!this.isJson()) {
            return null;
        }
        String b = this.bodyString();
        return Json.decode(b, classOfT);
    }

    public StringMap jsonToMap() throws QiniuException {
        if (!this.isJson()) {
            return null;
        }
        String b = this.bodyString();
        return Json.decode(b);
    }

    public synchronized byte[] body() throws QiniuException {
        if (this.body != null) {
            return this.body;
        }
        try {
            this.body = this.response.body().bytes();
        }
        catch (IOException e) {
            throw new QiniuException(e);
        }
        return this.body;
    }

    public String bodyString() throws QiniuException {
        return StringUtils.utf8String(this.body());
    }

    public String contentType() {
        return Response.ctype(this.response);
    }

    public boolean isJson() {
        return this.contentType().equals("application/json");
    }

    public String url() {
        return this.response.request().urlString();
    }

    public static class ErrorBody {
        public String error;
    }
}

