/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.http;

import com.qiniu.common.Config;
import com.qiniu.common.QiniuException;
import com.qiniu.http.AsyncCallback;
import com.qiniu.http.Response;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;

public final class Client {
    public static final String ContentTypeHeader = "Content-Type";
    public static final String DefaultMime = "application/octet-stream";
    public static final String JsonMime = "application/json";
    public static final String FormMime = "application/x-www-form-urlencoded";
    private final OkHttpClient httpClient;

    public Client() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(64);
        dispatcher.setMaxRequestsPerHost(16);
        ConnectionPool connectionPool = new ConnectionPool(32, 300000L);
        this.httpClient = new OkHttpClient();
        this.httpClient.setDispatcher(dispatcher);
        this.httpClient.setConnectionPool(connectionPool);
        this.httpClient.networkInterceptors().add(new Interceptor(){

            public com.squareup.okhttp.Response intercept(Interceptor.Chain chain) throws IOException {
                String ip;
                Request request = chain.request();
                com.squareup.okhttp.Response response = chain.proceed(request);
                IpTag tag = (IpTag)request.tag();
                tag.ip = ip = chain.connection().getSocket().getRemoteSocketAddress().toString();
                return response;
            }
        });
        this.httpClient.setConnectTimeout((long)Config.CONNECT_TIMEOUT, TimeUnit.SECONDS);
        this.httpClient.setReadTimeout((long)Config.RESPONSE_TIMEOUT, TimeUnit.SECONDS);
    }

    private static String userAgent() {
        String javaVersion = "Java/" + System.getProperty("java.version");
        String os = System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        String sdk = "QiniuJava/7.0.5";
        return sdk + " (" + os + ") " + javaVersion;
    }

    private static RequestBody create(final MediaType contentType, final byte[] content, final int offset, final int size) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return size;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content, offset, size);
            }
        };
    }

    public Response get(String url) throws QiniuException {
        return this.get(url, new StringMap());
    }

    public Response get(String url, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        return this.send(requestBuilder, headers);
    }

    public Response post(String url, byte[] body, StringMap headers) throws QiniuException {
        return this.post(url, body, headers, DefaultMime);
    }

    public Response post(String url, String body, StringMap headers) throws QiniuException {
        return this.post(url, StringUtils.utf8Bytes(body), headers, DefaultMime);
    }

    public Response post(String url, StringMap params, StringMap headers) throws QiniuException {
        final FormEncodingBuilder f = new FormEncodingBuilder();
        params.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                f.add(key, value.toString());
            }
        });
        return this.post(url, f.build(), headers);
    }

    public Response post(String url, byte[] body, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    public Response post(String url, byte[] body, int offset, int size, StringMap headers, String contentType) throws QiniuException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = Client.create(t, body, offset, size);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    private Response post(String url, RequestBody body, StringMap headers) throws QiniuException {
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        return this.send(requestBuilder, headers);
    }

    public Response multipartPost(String url, StringMap fields, String name, String fileName, byte[] fileBody, String mimeType, StringMap headers) throws QiniuException {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])fileBody);
        return this.multipartPost(url, fields, name, fileName, file, headers);
    }

    public Response multipartPost(String url, StringMap fields, String name, String fileName, File fileBody, String mimeType, StringMap headers) throws QiniuException {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)fileBody);
        return this.multipartPost(url, fields, name, fileName, file, headers);
    }

    private Response multipartPost(String url, StringMap fields, String name, String fileName, RequestBody file, StringMap headers) throws QiniuException {
        final MultipartBuilder mb = new MultipartBuilder();
        mb.addFormDataPart(name, fileName, file);
        fields.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                mb.addFormDataPart(key, value.toString());
            }
        });
        mb.type(MediaType.parse((String)"multipart/form-data"));
        RequestBody body = mb.build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        return this.send(requestBuilder, headers);
    }

    public Response send(final Request.Builder requestBuilder, StringMap headers) throws QiniuException {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    requestBuilder.header(key, value.toString());
                }
            });
        }
        requestBuilder.header("User-Agent", Client.userAgent());
        long start = System.currentTimeMillis();
        com.squareup.okhttp.Response res = null;
        double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
        IpTag tag = new IpTag();
        try {
            res = this.httpClient.newCall(requestBuilder.tag((Object)tag).build()).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QiniuException(e);
        }
        Response r = Response.create(res, tag.ip, duration);
        if (r.statusCode >= 300) {
            throw new QiniuException(r);
        }
        return r;
    }

    public void asyncSend(final Request.Builder requestBuilder, StringMap headers, final AsyncCallback cb) {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    requestBuilder.header(key, value.toString());
                }
            });
        }
        requestBuilder.header("User-Agent", Client.userAgent());
        final long start = System.currentTimeMillis();
        IpTag tag = new IpTag();
        this.httpClient.newCall(requestBuilder.tag((Object)tag).build()).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                e.printStackTrace();
                long duration = (System.currentTimeMillis() - start) / 1000L;
                cb.complete(Response.createError(null, "", duration, e.getMessage()));
            }

            public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                long duration = (System.currentTimeMillis() - start) / 1000L;
                cb.complete(Response.create(response, "", duration));
            }
        });
    }

    public void asyncPost(String url, byte[] body, int offset, int size, StringMap headers, String contentType, AsyncCallback cb) {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = Client.create(t, body, offset, size);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post(rbody);
        this.asyncSend(requestBuilder, headers, cb);
    }

    public void asyncMultipartPost(String url, StringMap fields, String name, String fileName, byte[] fileBody, String mimeType, StringMap headers, AsyncCallback cb) {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])fileBody);
        this.asyncMultipartPost(url, fields, name, fileName, file, headers, cb);
    }

    public void asyncMultipartPost(String url, StringMap fields, String name, String fileName, File fileBody, String mimeType, StringMap headers, AsyncCallback cb) throws QiniuException {
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)fileBody);
        this.asyncMultipartPost(url, fields, name, fileName, file, headers, cb);
    }

    private void asyncMultipartPost(String url, StringMap fields, String name, String fileName, RequestBody file, StringMap headers, AsyncCallback cb) {
        final MultipartBuilder mb = new MultipartBuilder();
        mb.addFormDataPart(name, fileName, file);
        fields.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                mb.addFormDataPart(key, value.toString());
            }
        });
        mb.type(MediaType.parse((String)"multipart/form-data"));
        RequestBody body = mb.build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        this.asyncSend(requestBuilder, headers, cb);
    }

    private static class IpTag {
        public String ip = null;

        private IpTag() {
        }
    }
}

