/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.Config;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.storage.model.FileListing;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.util.ArrayList;
import java.util.Iterator;

public final class BucketManager {
    private final Auth auth;
    private final Client client;

    public BucketManager(Auth auth) {
        this.auth = auth;
        this.client = new Client();
    }

    public static String entry(String bucket, String key) {
        return BucketManager.entry(bucket, key, true);
    }

    public static String entry(String bucket, String key, boolean mustHaveKey) {
        String en = bucket + ":" + key;
        if (!mustHaveKey && key == null) {
            en = bucket;
        }
        return UrlSafeBase64.encodeToString(en);
    }

    public String[] buckets() throws QiniuException {
        Response r = this.rsGet("/buckets");
        return r.jsonToObject(String[].class);
    }

    public FileListIterator createFileListIterator(String bucket, String prefix) {
        return new FileListIterator(bucket, prefix, 100, null);
    }

    public FileListIterator createFileListIterator(String bucket, String prefix, int limit, String delimiter) {
        return new FileListIterator(bucket, prefix, limit, delimiter);
    }

    public FileListing listFiles(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        StringMap map = new StringMap().put("bucket", bucket).putNotEmpty("marker", marker).putNotEmpty("prefix", prefix).putNotEmpty("delimiter", delimiter).putWhen("limit", limit, limit > 0);
        String url = Config.RSF_HOST + "/list?" + map.formString();
        Response r = this.get(url);
        return r.jsonToObject(FileListing.class);
    }

    public FileInfo stat(String bucket, String key) throws QiniuException {
        Response r = this.rsGet("/stat/" + BucketManager.entry(bucket, key));
        return r.jsonToObject(FileInfo.class);
    }

    public void delete(String bucket, String key) throws QiniuException {
        this.rsPost("/delete/" + BucketManager.entry(bucket, key));
    }

    public void rename(String bucket, String oldname, String newname) throws QiniuException {
        this.move(bucket, oldname, bucket, newname);
    }

    public void copy(String from_bucket, String from_key, String to_bucket, String to_key) throws QiniuException {
        String from = BucketManager.entry(from_bucket, from_key);
        String to = BucketManager.entry(to_bucket, to_key);
        String path = "/copy/" + from + "/" + to;
        this.rsPost(path);
    }

    public void move(String from_bucket, String from_key, String to_bucket, String to_key) throws QiniuException {
        String from = BucketManager.entry(from_bucket, from_key);
        String to = BucketManager.entry(to_bucket, to_key);
        String path = "/move/" + from + "/" + to;
        this.rsPost(path);
    }

    public void changeMime(String bucket, String key, String mime) throws QiniuException {
        String resource = BucketManager.entry(bucket, key);
        String encode_mime = UrlSafeBase64.encodeToString(mime);
        String path = "/chgm/" + resource + "/mime/" + encode_mime;
        this.rsPost(path);
    }

    public DefaultPutRet fetch(String url, String bucket) throws QiniuException {
        return this.fetch(url, bucket, null);
    }

    public DefaultPutRet fetch(String url, String bucket, String key) throws QiniuException {
        String resource = UrlSafeBase64.encodeToString(url);
        String to = BucketManager.entry(bucket, key, false);
        String path = "/fetch/" + resource + "/to/" + to;
        Response r = this.ioPost(path);
        return r.jsonToObject(DefaultPutRet.class);
    }

    public void prefetch(String bucket, String key) throws QiniuException {
        String resource = BucketManager.entry(bucket, key);
        String path = "/prefetch/" + resource;
        this.ioPost(path);
    }

    public Response batch(Batch operations) throws QiniuException {
        return this.rsPost("/batch", operations.toBody());
    }

    private Response rsPost(String path, byte[] body) throws QiniuException {
        String url = Config.RS_HOST + path;
        return this.post(url, body);
    }

    private Response rsPost(String path) throws QiniuException {
        return this.rsPost(path, null);
    }

    private Response rsGet(String path) throws QiniuException {
        String url = Config.RS_HOST + path;
        return this.get(url);
    }

    private Response ioPost(String path) throws QiniuException {
        String url = Config.IO_HOST + path;
        return this.post(url, null);
    }

    private Response get(String url) throws QiniuException {
        StringMap headers = this.auth.authorization(url);
        return this.client.get(url, headers);
    }

    private Response post(String url, byte[] body) throws QiniuException {
        StringMap headers = this.auth.authorization(url, body, "application/x-www-form-urlencoded");
        return this.client.post(url, body, headers, "application/x-www-form-urlencoded");
    }

    public class FileListIterator
    implements Iterator<FileInfo[]> {
        private String marker = null;
        private String bucket;
        private String delimiter;
        private int limit;
        private String prefix;
        private QiniuException exception = null;

        public FileListIterator(String bucket, String prefix, int limit, String delimiter) {
            if (limit <= 0) {
                throw new IllegalArgumentException("limit must great than 0");
            }
            this.bucket = bucket;
            this.prefix = prefix;
            this.limit = limit;
            this.delimiter = delimiter;
        }

        public QiniuException error() {
            return this.exception;
        }

        @Override
        public boolean hasNext() {
            return this.exception == null && !"".equals(this.marker);
        }

        @Override
        public FileInfo[] next() {
            try {
                FileListing f = BucketManager.this.listFiles(this.bucket, this.prefix, this.marker, this.limit, this.delimiter);
                this.marker = f.marker == null ? "" : f.marker;
                return f.items;
            }
            catch (QiniuException e) {
                this.exception = e;
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class Batch {
        private ArrayList<String> ops = new ArrayList();

        public Batch copy(String from_bucket, String from_key, String to_bucket, String to_key) {
            String from = BucketManager.entry(from_bucket, from_key);
            String to = BucketManager.entry(to_bucket, to_key);
            this.ops.add("copy/" + from + "/" + to);
            return this;
        }

        public Batch rename(String from_bucket, String from_key, String to_key) {
            return this.move(from_bucket, from_key, from_bucket, to_key);
        }

        public Batch move(String from_bucket, String from_key, String to_bucket, String to_key) {
            String from = BucketManager.entry(from_bucket, from_key);
            String to = BucketManager.entry(to_bucket, to_key);
            this.ops.add("move/" + from + "/" + to);
            return this;
        }

        public Batch delete(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add("delete/" + BucketManager.entry(bucket, key));
            }
            return this;
        }

        public Batch stat(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add("stat/" + BucketManager.entry(bucket, key));
            }
            return this;
        }

        public byte[] toBody() {
            String body = StringUtils.join(this.ops, "&op=", "op=");
            return StringUtils.utf8Bytes(body);
        }

        public Batch merge(Batch batch) {
            this.ops.addAll(batch.ops);
            return this;
        }
    }
}

