/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.rtc.service;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.rtc.model.RoomAccess;
import com.qiniu.rtc.model.RoomParam;
import com.qiniu.rtc.model.UrlParam;
import com.qiniu.rtc.service.AbstractService;
import com.qiniu.util.Auth;

public class RoomService
extends AbstractService {
    public RoomService(Auth auth) {
        super(auth);
    }

    public Response createRoom(String appId, RoomParam roomParam) throws QiniuException {
        String urlPattern = "/v3/apps/%s/createroom";
        return this.postCall(roomParam, urlPattern, appId);
    }

    public Response deleteRoom(String appId, String roomName) throws QiniuException {
        String urlPattern = "/v3/apps/%s/rooms/%s";
        return this.deleteCall(null, urlPattern, appId, roomName);
    }

    public Response listUser(String appId, String roomName) throws QiniuException {
        String urlPattern = "/v3/apps/%s/rooms/%s/users";
        return this.getCall(urlPattern, appId, roomName);
    }

    public Response kickUser(String appId, String roomName, String userId) throws QiniuException {
        String urlPattern = "/v3/apps/%s/rooms/%s/users/%s";
        return this.deleteCall(null, urlPattern, appId, roomName, userId);
    }

    public Response listActiveRoom(String appId, String roomNamePrefix, UrlParam urlParam) throws QiniuException {
        String urlPattern = "/v3/apps/%s/rooms?prefix=%s&offset=%d&limit=%d";
        return this.getCall(urlPattern, appId, roomNamePrefix, urlParam.getOffset(), urlParam.getLimit());
    }

    public String getRoomToken(RoomAccess access) throws Exception {
        String json = this.gson.toJson((Object)access);
        return this.auth.signRoomToken(json);
    }
}

