/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionGroup;
import com.qiniu.storage.RegionReqInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AutoRegion
extends Region {
    private String ucServer;
    private Map<RegionIndex, RegionGroup> regions;
    private Client client;

    private AutoRegion() {
    }

    AutoRegion(String ucServer) {
        this.ucServer = ucServer;
        this.client = new Client();
        this.regions = new ConcurrentHashMap<RegionIndex, RegionGroup>();
    }

    private UCRet getRegionJson(RegionIndex index) throws QiniuException {
        String address = this.ucServer + "/v3/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        Response r = this.client.get(address);
        return r.jsonToObject(UCRet.class);
    }

    static RegionGroup regionGroup(UCRet ret) {
        if (ret == null || ret.hosts == null || ret.hosts.length == 0) {
            return null;
        }
        RegionGroup group = new RegionGroup();
        for (HostRet host : ret.hosts) {
            String regionId;
            long timestamp = host.ttl + System.currentTimeMillis() / 1000L;
            ArrayList<String> srcUpHosts = new ArrayList();
            ArrayList<String> accUpHosts = new ArrayList();
            if (host.up != null) {
                srcUpHosts = host.up.allSrcHosts();
                accUpHosts = host.up.allAccHosts();
            }
            String iovipHost = null;
            if (host.io != null) {
                iovipHost = host.io.getOneHost();
            }
            String rsHost = null;
            if (host.rs != null) {
                rsHost = host.rs.getOneHost();
            }
            String rsfHost = null;
            if (host.rsf != null) {
                rsfHost = host.rsf.getOneHost();
            }
            String apiHost = null;
            if (host.api != null) {
                apiHost = host.api.getOneHost();
            }
            String ucHost = null;
            if (host.uc != null) {
                ucHost = host.uc.getOneHost();
            }
            if ((regionId = host.region) == null) {
                regionId = "";
            }
            Region region = new Region(timestamp, regionId, srcUpHosts, accUpHosts, iovipHost, rsHost, rsfHost, apiHost, ucHost);
            group.addRegion(region);
        }
        return group;
    }

    private RegionGroup queryRegionInfo(String accessKey, String bucket) throws QiniuException {
        RegionIndex index = new RegionIndex(accessKey, bucket);
        RegionGroup regionGroup = this.regions.get(index);
        Exception ex = null;
        if (regionGroup == null || !regionGroup.isValid()) {
            for (int i = 0; i < 2; ++i) {
                try {
                    UCRet ret = this.getRegionJson(index);
                    regionGroup = AutoRegion.regionGroup(ret);
                    if (regionGroup == null) continue;
                    this.regions.put(index, regionGroup);
                    break;
                }
                catch (Exception e) {
                    ex = e;
                }
            }
        }
        if (regionGroup == null) {
            if (ex instanceof QiniuException) {
                throw (QiniuException)ex;
            }
            throw new QiniuException(ex, "auto region get region info from uc failed.");
        }
        return regionGroup;
    }

    private RegionGroup queryRegionInfo(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.queryRegionInfo(regionReqInfo.getAccessKey(), regionReqInfo.getBucket());
    }

    @Override
    boolean switchRegion(RegionReqInfo regionReqInfo) {
        Region currentRegion = this.getCurrentRegion(regionReqInfo);
        if (currentRegion == null) {
            return false;
        }
        return currentRegion.switchRegion(regionReqInfo);
    }

    @Override
    String getRegion(RegionReqInfo regionReqInfo) {
        Region currentRegion = this.getCurrentRegion(regionReqInfo);
        if (currentRegion == null) {
            return "";
        }
        return currentRegion.getRegion(regionReqInfo);
    }

    @Override
    boolean isValid() {
        return true;
    }

    @Override
    Region getCurrentRegion(RegionReqInfo regionReqInfo) {
        try {
            RegionGroup regionGroup = this.queryRegionInfo(regionReqInfo);
            return regionGroup.getCurrentRegion(regionReqInfo);
        }
        catch (QiniuException e) {
            return null;
        }
    }

    @Override
    List<String> getSrcUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return null;
        }
        RegionGroup regionGroup = this.queryRegionInfo(regionReqInfo);
        return regionGroup.getSrcUpHost(regionReqInfo);
    }

    @Override
    List<String> getAccUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return null;
        }
        RegionGroup regionGroup = this.queryRegionInfo(regionReqInfo);
        return regionGroup.getAccUpHost(regionReqInfo);
    }

    @Override
    String getIovipHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        RegionGroup regionGroup = this.queryRegionInfo(regionReqInfo);
        return regionGroup.getIovipHost(regionReqInfo);
    }

    @Override
    String getRsHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        RegionGroup regionGroup = this.queryRegionInfo(regionReqInfo);
        return regionGroup.getRsHost(regionReqInfo);
    }

    @Override
    String getRsfHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        RegionGroup regionGroup = this.queryRegionInfo(regionReqInfo);
        return regionGroup.getRsfHost(regionReqInfo);
    }

    @Override
    String getApiHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        RegionGroup regionGroup = this.queryRegionInfo(regionReqInfo);
        return regionGroup.getApiHost(regionReqInfo);
    }

    @Override
    String getUcHost(RegionReqInfo regionReqInfo) throws QiniuException {
        String host = this.ucServer.replace("http://", "");
        host = host.replace("https://", "");
        return host;
    }

    @Override
    public Object clone() {
        AutoRegion newRegion = new AutoRegion();
        newRegion.ucServer = this.ucServer;
        newRegion.regions = this.regions;
        newRegion.client = this.client;
        return newRegion;
    }

    private class HostInfoRet {
        Map<String, List<String>> acc;
        Map<String, List<String>> src;

        private HostInfoRet() {
        }

        private String getOneHost() {
            List<String> hosts = this.allHosts();
            if (hosts.size() > 0) {
                return hosts.get(0);
            }
            return null;
        }

        private List<String> allHosts() {
            List<String> accHosts;
            ArrayList<String> hosts = new ArrayList<String>();
            List<String> srcHosts = this.allSrcHosts();
            if (srcHosts.size() > 0) {
                hosts.addAll(srcHosts);
            }
            if ((accHosts = this.allAccHosts()).size() > 0) {
                hosts.addAll(accHosts);
            }
            return hosts;
        }

        private List<String> allSrcHosts() {
            ArrayList<String> hosts = new ArrayList<String>();
            if (this.acc != null) {
                List<String> backupHosts;
                List<String> mainHosts = this.acc.get("main");
                if (mainHosts != null && mainHosts.size() > 0) {
                    hosts.addAll(mainHosts);
                }
                if ((backupHosts = this.acc.get("backup")) != null && backupHosts.size() > 0) {
                    hosts.addAll(backupHosts);
                }
            }
            return hosts;
        }

        private List<String> allAccHosts() {
            ArrayList<String> hosts = new ArrayList<String>();
            if (this.src != null) {
                List<String> backupHosts;
                List<String> mainHosts = this.src.get("main");
                if (mainHosts != null && mainHosts.size() > 0) {
                    hosts.addAll(mainHosts);
                }
                if ((backupHosts = this.src.get("backup")) != null && backupHosts.size() > 0) {
                    hosts.addAll(backupHosts);
                }
            }
            return hosts;
        }
    }

    private class HostRet {
        long ttl;
        String region;
        HostInfoRet up;
        HostInfoRet rs;
        HostInfoRet rsf;
        HostInfoRet uc;
        HostInfoRet api;
        HostInfoRet io;

        private HostRet() {
        }
    }

    private class UCRet {
        HostRet[] hosts;

        private UCRet() {
        }
    }

    private static class RegionIndex {
        private final String accessKey;
        private final String bucket;

        RegionIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof RegionIndex && ((RegionIndex)obj).accessKey.equals(this.accessKey) && ((RegionIndex)obj).bucket.equals(this.bucket);
        }
    }
}

