/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.http;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import okhttp3.MediaType;
import okhttp3.Request;

public final class Response {
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public final String method;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final double duration;
    public final String address;
    private byte[] body;
    private okhttp3.Response response;

    private Response(okhttp3.Response response, int statusCode, String reqId, String xlog, String xvia, String address, double duration, String error, byte[] body) {
        this.response = response;
        this.statusCode = statusCode;
        this.reqId = reqId;
        this.xlog = xlog;
        this.xvia = xvia;
        this.duration = duration;
        this.error = error;
        this.address = address;
        this.body = body;
        this.method = this.getMethod(response);
    }

    private String getMethod(okhttp3.Response response) {
        Request req;
        String method = null;
        if (response != null && (req = response.request()) != null) {
            method = req.method();
        }
        if (method == null) {
            method = "";
        }
        return method;
    }

    public static Response create(okhttp3.Response response, String address, double duration) {
        byte[] body;
        String reqId;
        int code;
        String error;
        block4: {
            error = null;
            code = response.code();
            reqId = null;
            reqId = response.header("X-Reqid");
            reqId = reqId == null ? null : reqId.trim();
            body = null;
            if (Response.ctype(response).equals("application/json")) {
                try {
                    body = response.body().bytes();
                    if (response.code() >= 400 && !StringUtils.isNullOrEmpty(reqId) && body != null) {
                        ErrorBody errorBody = Json.decode(new String(body, Constants.UTF_8), ErrorBody.class);
                        error = errorBody.error;
                    }
                }
                catch (Exception e) {
                    if (response.code() >= 300) break block4;
                    error = e.getMessage();
                }
            }
        }
        return new Response(response, code, reqId, response.header("X-Log"), Response.via(response), address, duration, error, body);
    }

    public static Response createError(okhttp3.Response response, String address, double duration, String error) {
        byte[] body;
        String reqId;
        int code;
        block5: {
            if (response == null) {
                return new Response(null, -1, "", "", "", "", duration, error, null);
            }
            code = response.code();
            reqId = null;
            reqId = response.header("X-Reqid");
            reqId = reqId == null ? null : reqId.trim();
            body = null;
            if (Response.ctype(response).equals("application/json")) {
                try {
                    body = response.body().bytes();
                    if (response.code() >= 400 && !StringUtils.isNullOrEmpty(reqId) && body != null) {
                        ErrorBody errorBody = Json.decode(new String(body, Constants.UTF_8), ErrorBody.class);
                        error = errorBody.error;
                    }
                }
                catch (Exception e) {
                    if (response.code() >= 300) break block5;
                    error = e.getMessage();
                }
            }
        }
        return new Response(response, code, reqId, response.header("X-Log"), Response.via(response), address, duration, error, body);
    }

    public static Response createSuccessResponse() {
        return new Response(null, 200, "inter:reqId", null, "inter:via", null, 0.0, null, new byte[0]);
    }

    private static String via(okhttp3.Response response) {
        String via = response.header("X-Via", "");
        if (!via.equals("")) {
            return via;
        }
        via = response.header("X-Px", "");
        if (!via.equals("")) {
            return via;
        }
        via = response.header("Fw-Via", "");
        if (!via.equals("")) {
            return via;
        }
        return via;
    }

    private static String ctype(okhttp3.Response response) {
        MediaType mediaType = response.body().contentType();
        if (mediaType == null) {
            return "";
        }
        return mediaType.type() + "/" + mediaType.subtype();
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && this.reqId != null && this.reqId.length() > 0;
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean isContextExpiredError() {
        return this.statusCode == 701 || this.statusCode == 612 && this.error.contains("no such uploadId");
    }

    public boolean needSwitchServer() {
        return this.isNetworkBroken() || this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579;
    }

    public boolean needRetry() {
        return this.isNetworkBroken() || this.isServerError() || this.statusCode == 406 || this.statusCode == 200 && this.error != null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ResponseInfo:%s,status:%d, reqId:%s, xlog:%s, xvia:%s, adress:%s, duration:%f s, error:%s}", super.toString(), this.statusCode, this.reqId, this.xlog, this.xvia, this.address, this.duration, this.error);
    }

    public <T> T jsonToObject(Class<T> classOfT) throws QiniuException {
        if (!this.isJson()) {
            return null;
        }
        String b = this.bodyString();
        return Json.decode(b, classOfT);
    }

    public StringMap jsonToMap() throws QiniuException {
        if (!this.isJson()) {
            return null;
        }
        String b = this.bodyString();
        return Json.decode(b);
    }

    public synchronized byte[] body() throws QiniuException {
        if (this.body != null) {
            return this.body;
        }
        try {
            this.body = this.response.body().bytes();
        }
        catch (IOException e) {
            throw new QiniuException(e);
        }
        return this.body;
    }

    public String bodyString() throws QiniuException {
        return StringUtils.utf8String(this.body());
    }

    public synchronized InputStream bodyStream() throws QiniuException {
        if (this.response == null) {
            return null;
        }
        return this.response.body().byteStream();
    }

    public synchronized void close() {
        if (this.response != null) {
            this.response.close();
        }
    }

    public String contentType() {
        return Response.ctype(this.response);
    }

    public String header(String name, String defaultValue) {
        return this.response.header(name, defaultValue);
    }

    public boolean isJson() {
        return this.contentType().equals("application/json");
    }

    public String url() {
        return this.response.request().url().toString();
    }

    public String getInfo() {
        Object[] msg = new String[3];
        try {
            msg[0] = this.method;
            msg[0] = (String)msg[0] + " " + this.url();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            msg[1] = this.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            msg[2] = this.bodyString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return StringUtils.join(msg, "  \n");
    }

    public static class ErrorBody {
        public String error;
    }
}

