/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.AutoZone;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionReqInfo;
import com.qiniu.storage.UpHostHelper;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

class ConfigHelper {
    private Configuration config;
    private UpHostHelper helper;

    ConfigHelper(Configuration config) {
        this.config = config;
        this.makeSureRegion();
    }

    public String upHost(String upToken) throws QiniuException {
        try {
            return this.upHost(upToken, null, false, false);
        }
        catch (QiniuException e) {
            if (e.response == null || e.response.needRetry()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.upHost(upToken, null, false, true);
            }
            throw e;
        }
    }

    public String tryChangeUpHost(String upToken, String lastUsedHost) throws QiniuException {
        return this.upHost(upToken, lastUsedHost, true, false);
    }

    private String upHost(String upToken, String lastUsedHost, boolean changeHost, boolean mustReturnUpHost) throws QiniuException {
        return this.getScheme() + this.getHelper().upHost(this.config.region, upToken, UrlUtils.removeHostScheme(lastUsedHost), changeHost, mustReturnUpHost);
    }

    public String ioHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getIovipHost(regionReqInfo);
    }

    public String ioSrcHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.config.region.getIoSrcHost(regionReqInfo);
    }

    public String apiHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getApiHost(regionReqInfo);
    }

    public String rsHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getRsHost(regionReqInfo);
    }

    public String rsfHost(String ak, String bucket) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        return this.getScheme() + this.config.region.getRsfHost(regionReqInfo);
    }

    public String rsHost() {
        String host = "";
        try {
            host = this.config.region.getRsHost(null);
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
        }
        if (host == null || host.length() == 0) {
            host = Configuration.defaultRsHost;
        }
        return this.getScheme() + host;
    }

    public String apiHost() {
        String host = "";
        try {
            host = this.config.region.getApiHost(null);
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
        }
        if (host == null || host.length() == 0) {
            host = Configuration.defaultApiHost;
        }
        return this.getScheme() + host;
    }

    public String ucHost() {
        String host = "";
        try {
            host = this.config.region.getUcHost(null);
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
        }
        if (host == null || host.length() == 0) {
            host = Configuration.defaultUcHost;
        }
        return this.getScheme() + host;
    }

    List<String> ucHostsWithoutScheme() {
        List<String> hosts = new ArrayList<String>();
        try {
            List<String> hostList = this.config.region.getUcHosts(null);
            if (hostList != null) {
                hosts.addAll(hostList);
            }
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
        }
        hosts = Arrays.asList(this.removeHostsSchemeAndHostsNoDuplication(hosts));
        if (hosts.size() == 0) {
            hosts = Arrays.asList(Configuration.defaultUcHosts);
        }
        return new ArrayList<String>(hosts);
    }

    List<String> upHostsWithoutScheme() {
        List<String> hosts = new ArrayList<String>();
        try {
            List<String> srcUpHost = this.config.region.getSrcUpHost(null);
            if (srcUpHost != null) {
                hosts.addAll(srcUpHost);
            }
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
        }
        try {
            List<String> accUpHost = this.config.region.getAccUpHost(null);
            if (accUpHost != null) {
                hosts.addAll(accUpHost);
            }
        }
        catch (QiniuException exception) {
            exception.printStackTrace();
        }
        hosts = Arrays.asList(this.removeHostsSchemeAndHostsNoDuplication(hosts));
        return new ArrayList<String>(hosts);
    }

    private String getScheme() {
        return this.config.useHttpsDomains ? "https://" : "http://";
    }

    private void makeSureRegion() {
        if (this.config.region == null) {
            this.config.region = this.config.zone != null ? this.toRegion(this.config.zone) : Region.autoRegion();
        }
    }

    private UpHostHelper getHelper() {
        if (this.helper == null) {
            this.helper = new UpHostHelper(this.config, 900);
        }
        return this.helper;
    }

    private Region toRegion(Zone zone) {
        if (zone instanceof AutoZone) {
            AutoZone autoZone = (AutoZone)zone;
            return Region.autoRegion(autoZone.ucServer);
        }
        return new Region.Builder().region(zone.getRegion()).accUpHost(this.getHosts(zone.getUpHttps(null), zone.getUpHttp(null))).srcUpHost(this.getHosts(zone.getUpBackupHttps(null), zone.getUpBackupHttp(null))).iovipHost(this.getHost(zone.getIovipHttps(null), zone.getIovipHttp(null))).rsHost(this.getHost(zone.getRsHttps(), zone.getRsHttp())).rsfHost(this.getHost(zone.getRsfHttps(), zone.getRsfHttp())).apiHost(this.getHost(zone.getApiHttps(), zone.getApiHttp())).build();
    }

    private String getHost(String https, String http) {
        if (this.config.useHttpsDomains) {
            return UrlUtils.removeHostScheme(https);
        }
        return UrlUtils.removeHostScheme(http);
    }

    private String[] getHosts(String https, String http) {
        ArrayList<String> hosts = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty(https)) {
            hosts.add(https);
        }
        if (!this.config.useHttpsDomains && !StringUtils.isNullOrEmpty(http)) {
            hosts.add(http);
        }
        return this.removeHostsSchemeAndHostsNoDuplication(hosts);
    }

    private String[] removeHostsSchemeAndHostsNoDuplication(List<String> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return new String[0];
        }
        HashSet<String> newHosts = new HashSet<String>();
        for (int i = 0; i < hosts.size(); ++i) {
            String host = UrlUtils.removeHostScheme(hosts.get(i));
            if (StringUtils.isNullOrEmpty(host)) continue;
            newHosts.add(host);
        }
        return newHosts.toArray(new String[0]);
    }
}

