/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.util.Timestamp;
import com.qiniu.util.UrlUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class HostProvider {
    public static HostProvider arrayProvider(String ... hosts) {
        if (hosts == null || hosts.length == 0) {
            return null;
        }
        return new ArrayProvider(hosts);
    }

    abstract String provider();

    abstract void freezeHost(String var1, int var2);

    abstract boolean isHostValid(String var1);

    private static final class ArrayProvider
    extends HostProvider {
        private int nextIndex = 0;
        private final String[] values;
        private final Map<String, Value> items = new HashMap<String, Value>();

        private ArrayProvider(String ... values) {
            this.values = values;
            if (this.values == null) {
                return;
            }
            for (int i = 0; i < this.values.length; ++i) {
                String value;
                this.values[i] = value = UrlUtils.removeHostScheme(this.values[i]);
                this.items.put(value, new Value(value));
            }
        }

        @Override
        public String provider() {
            if (this.values == null || this.values.length == 0) {
                return "";
            }
            int s = Math.max(this.nextIndex, 0);
            int l = this.values.length;
            for (int i = s; i < s + l; ++i) {
                String key = this.values[i % l];
                Value v = this.items.get(key);
                if (v == null || !v.isValid()) continue;
                this.nextIndex = (i + 1) % l;
                return v.value;
            }
            return null;
        }

        @Override
        public void freezeHost(String host, int freezeDuration) {
            Value v = this.items.get(host);
            if (v == null) {
                return;
            }
            v.freeze(freezeDuration);
        }

        @Override
        boolean isHostValid(String host) {
            Value v = this.items.get(host);
            if (v == null) {
                return true;
            }
            return v.isValid();
        }

        private static final class Value {
            private final String value;
            private long validAfterTime;

            private Value(String value) {
                this.value = value;
            }

            private void freeze(int freezeDuration) {
                this.validAfterTime = (long)freezeDuration + Timestamp.milliSecond();
            }

            private boolean isValid() {
                return Timestamp.milliSecond() >= this.validAfterTime;
            }
        }
    }
}

