/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Headers;
import com.qiniu.storage.Api;
import com.qiniu.util.Auth;

final class ApiInterceptorAuth
extends Api.Interceptor {
    private final Auth auth;

    private ApiInterceptorAuth(Auth auth) {
        this.auth = auth;
    }

    @Override
    int priority() {
        return 600;
    }

    @Override
    Api.Response intercept(Api.Request request, Api.Handler handler) throws QiniuException {
        if (this.auth == null || request == null) {
            return handler.handle(request);
        }
        String url = request.getUrl().toString();
        String method = request.getMethodString();
        Headers headers = Headers.of(request.getHeader());
        byte[] body = request.getBytesBody();
        String authorization = "Qiniu " + this.auth.signQiniuAuthorization(url, method, body, headers);
        request.addHeaderField("Authorization", authorization);
        return handler.handle(request);
    }

    static final class Builder {
        private Auth auth;

        Builder() {
        }

        Builder setAuth(Auth auth) {
            this.auth = auth;
            return this;
        }

        Api.Interceptor build() {
            return new ApiInterceptorAuth(this.auth);
        }
    }
}

