/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.util.Map;

public class ApiUploadV1MakeFile
extends ApiUpload {
    public ApiUploadV1MakeFile(Client client) {
        super(client);
    }

    public ApiUploadV1MakeFile(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getKey() {
            return this.getStringValueFromDataMap("key");
        }

        public String getHash() {
            return this.getStringValueFromDataMap("hash");
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private String key;
        private String fileName;
        private Long fileSize;
        private String fileMimeType;
        private String[] blockContexts;
        private Map<String, Object> params;
        private Map<String, Object> metaDataParam;

        public Request(String urlPrefix, String token, Long fileSize, String[] blockContexts) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.POST);
            this.fileSize = fileSize;
            this.blockContexts = blockContexts;
        }

        public Request setKey(String key) {
            this.key = key;
            return this;
        }

        public Request setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Request setFileMimeType(String fileMimeType) {
            this.fileMimeType = fileMimeType;
            return this;
        }

        public Request setCustomParam(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public Request setCustomMetaParam(Map<String, Object> params) {
            this.metaDataParam = params;
            return this;
        }

        @Override
        protected void buildPath() throws QiniuException {
            if (this.fileSize == null) {
                ApiUtils.throwInvalidRequestParamException("file size");
            }
            this.addPathSegment("mkfile");
            this.addPathSegment(this.fileSize + "");
            if (!StringUtils.isNullOrEmpty(this.fileMimeType)) {
                this.addPathSegment("mimeType");
                this.addPathSegment(UrlSafeBase64.encodeToString(this.fileMimeType));
            }
            if (!StringUtils.isNullOrEmpty(this.fileName)) {
                this.addPathSegment("fname");
                this.addPathSegment(UrlSafeBase64.encodeToString(this.fileName));
            }
            if (this.key != null) {
                this.addPathSegment("key");
                this.addPathSegment(UrlSafeBase64.encodeToString(this.key));
            }
            if (this.params != null && this.params.size() > 0) {
                for (String key : this.params.keySet()) {
                    this.addPathSegment(key);
                    this.addPathSegment(UrlSafeBase64.encodeToString("" + this.params.get(key)));
                }
            }
            if (this.metaDataParam != null && this.metaDataParam.size() > 0) {
                for (String key : this.metaDataParam.keySet()) {
                    this.addPathSegment(key);
                    this.addPathSegment(UrlSafeBase64.encodeToString("" + this.metaDataParam.get(key)));
                }
            }
            super.buildPath();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            if (this.blockContexts == null) {
                ApiUtils.throwInvalidRequestParamException("blockContexts");
            }
            String s = StringUtils.join(this.blockContexts, ",");
            byte[] body = StringUtils.utf8Bytes(s);
            this.setBody(body, 0, body.length, null);
        }
    }
}

