/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.Json;
import com.qiniu.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiUploadV2CompleteUpload
extends ApiUpload {
    public ApiUploadV2CompleteUpload(Client client) {
        super(client);
    }

    public ApiUploadV2CompleteUpload(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getKey() {
            return this.getStringValueFromDataMap("key");
        }

        public String getHash() {
            return this.getStringValueFromDataMap("hash");
        }
    }

    public static class Request
    extends ApiUpload.Request {
        public static final String PART_ETG = "etag";
        public static final String PART_NUMBER = "partNumber";
        private String key;
        private String fileName;
        private String fileMimeType;
        private String uploadId;
        private List<Map<String, Object>> partsInfo;
        private Map<String, Object> params;
        private Map<String, Object> metaDataParam;

        public Request(String urlPrefix, String token, String uploadId, List<Map<String, Object>> partsInfo) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.POST);
            this.uploadId = uploadId;
            this.partsInfo = partsInfo;
        }

        public Request setKey(String key) {
            this.key = key;
            return this;
        }

        public Request setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Request setFileMimeType(String fileMimeType) {
            this.fileMimeType = fileMimeType;
            return this;
        }

        public Request setCustomParam(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public Request setCustomMetaParam(Map<String, Object> params) {
            this.metaDataParam = params;
            return this;
        }

        @Override
        protected void buildPath() throws QiniuException {
            UploadToken token = this.getUploadToken();
            if (token == null || !token.isValid()) {
                ApiUtils.throwInvalidRequestParamException("token");
            }
            if (StringUtils.isNullOrEmpty(this.uploadId)) {
                ApiUtils.throwInvalidRequestParamException("uploadId");
            }
            String bucket = token.getBucket();
            this.addPathSegment("buckets");
            this.addPathSegment(bucket);
            this.addPathSegment("objects");
            this.addPathSegment(ApiUtils.resumeV2EncodeKey(this.key));
            this.addPathSegment("uploads");
            this.addPathSegment(this.uploadId);
            super.buildPath();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            if (this.partsInfo == null) {
                ApiUtils.throwInvalidRequestParamException("partInfo");
            }
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            bodyMap.put("parts", this.partsInfo);
            if (this.fileName != null) {
                bodyMap.put("fname", this.fileName);
            }
            if (this.fileMimeType != null) {
                bodyMap.put("mimeType", this.fileMimeType);
            }
            if (this.params != null && this.params.size() > 0) {
                bodyMap.put("customVars", this.params);
            }
            if (this.metaDataParam != null && this.metaDataParam.size() > 0) {
                bodyMap.put("metaData", this.metaDataParam);
            }
            String bodyString = Json.encode(bodyMap);
            byte[] body = bodyString.getBytes(Constants.UTF_8);
            this.setBody(body, 0, body.length, null);
        }
    }
}

