/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Retry;
import com.qiniu.storage.UploadToken;

public abstract class BaseUploader {
    protected final Client client;
    protected final String key;
    protected final String upToken;
    protected final ConfigHelper configHelper;
    protected final Configuration config;

    BaseUploader(Client client, String upToken, String key, Configuration config) {
        this.client = client;
        this.key = key;
        this.upToken = upToken;
        this.config = config == null ? new Configuration() : config.clone();
        this.configHelper = new ConfigHelper(this.config);
    }

    public Response upload() throws QiniuException {
        if (this.config == null) {
            throw QiniuException.unrecoverable("config can't be empty");
        }
        return this.uploadWithRegionRetry();
    }

    private Response uploadWithRegionRetry() throws QiniuException {
        Response response = null;
        QiniuException exception = null;
        do {
            response = null;
            exception = null;
            try {
                response = this.uploadFlows();
            }
            catch (QiniuException e) {
                exception = e;
            }
        } while (Retry.canSwitchRegionAndRetry(response, exception) && this.couldReloadSource() && this.reloadSource() && (response != null && response.isContextExpiredError() || exception != null && exception.response != null && exception.response.isContextExpiredError() || this.config.region != null && this.config.region.switchRegion(new UploadToken(this.upToken))));
        if (exception != null) {
            throw exception;
        }
        return response;
    }

    abstract Response uploadFlows() throws QiniuException;

    abstract boolean couldReloadSource();

    abstract boolean reloadSource();
}

