/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.processing;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.media.apis.ApiPfop;
import com.qiniu.media.apis.ApiPrefop;
import com.qiniu.processing.OperationStatus;
import com.qiniu.storage.Api;
import com.qiniu.storage.Configuration;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;

public final class OperationManager {
    private final Client client;
    private final Auth auth;
    private Configuration configuration;

    public OperationManager(Auth auth, Configuration cfg) {
        this.auth = auth;
        this.configuration = cfg.clone();
        this.client = new Client(this.configuration);
    }

    public OperationManager(Auth auth, Client client) {
        this.auth = auth;
        this.client = client;
        this.configuration = new Configuration();
    }

    public OperationManager(Auth auth, Configuration cfg, Client client) {
        this.auth = auth;
        this.client = client;
        this.configuration = cfg;
    }

    public String pfop(String bucket, String key, String fops) throws QiniuException {
        return this.pfop(bucket, key, fops, null);
    }

    public String pfop(String bucket, String key, String fops, StringMap params) throws QiniuException {
        if (params == null) {
            params = new StringMap();
        }
        params.put("fops", fops);
        return this.pfop(bucket, key, params);
    }

    public String pfop(String bucket, String key, StringMap params) throws QiniuException {
        Integer force = null;
        if (params.get("force") != null) {
            if (params.get("force") instanceof Integer) {
                force = (Integer)params.get("force");
            } else {
                throw QiniuException.unrecoverable("force type error, should be Integer");
            }
        }
        String pipeline = null;
        if (params.get("pipeline") != null) {
            if (params.get("pipeline") instanceof String) {
                pipeline = (String)params.get("pipeline");
            } else {
                throw QiniuException.unrecoverable("pipeline type error, should be String");
            }
        }
        String notifyUrl = null;
        if (params.get("notifyURL") != null) {
            if (params.get("notifyURL") instanceof String) {
                notifyUrl = (String)params.get("notifyURL");
            } else {
                throw QiniuException.unrecoverable("notifyURL type error, should be String");
            }
        }
        Integer type = null;
        if (params.get("type") != null) {
            if (params.get("type") instanceof Integer) {
                type = (Integer)params.get("type");
            } else {
                throw QiniuException.unrecoverable("type type error, should be Integer");
            }
        }
        String fops = null;
        if (params.get("fops") != null) {
            if (params.get("fops") instanceof String) {
                fops = (String)params.get("fops");
            } else {
                throw QiniuException.unrecoverable("fops type error, should be String");
            }
        }
        String workflowTemplateID = null;
        if (params.get("persistentWorkflowTemplateID") != null) {
            if (params.get("persistentWorkflowTemplateID") instanceof String) {
                workflowTemplateID = (String)params.get("persistentWorkflowTemplateID");
            } else {
                throw QiniuException.unrecoverable("persistentWorkflowTemplateID type error, should be String");
            }
        }
        String url = this.configuration.apiHost(this.auth.accessKey, bucket);
        ApiPfop.Request request = new ApiPfop.Request(url, bucket, key).setFops(fops).setWorkflowTemplateId(workflowTemplateID).setPipeline(pipeline).setForce(force).setNotifyUrl(notifyUrl).setType(type);
        ApiPfop api = new ApiPfop(this.client, new Api.Config.Builder().setAuth(this.auth).build());
        ApiPfop.Response response = api.request(request);
        if (response == null) {
            throw QiniuException.unrecoverable("unknown error");
        }
        if (!response.isOK()) {
            throw new QiniuException(response.getResponse());
        }
        ApiPfop.Response.PfopId status = response.getData();
        if (status != null) {
            return status.getPersistentId();
        }
        return null;
    }

    public String pfop(String bucket, String key, String fops, String pipeline, String notifyURL) throws QiniuException {
        StringMap params = new StringMap().putNotEmpty("pipeline", pipeline).putNotEmpty("notifyURL", notifyURL);
        return this.pfop(bucket, key, fops, params);
    }

    public String pfop(String bucket, String key, String fops, String pipeline, boolean force) throws QiniuException {
        StringMap params = new StringMap().putNotEmpty("pipeline", pipeline).putWhen("force", 1, force);
        return this.pfop(bucket, key, fops, params);
    }

    public String pfop(String bucket, String key, String fops, String pipeline, String notifyURL, boolean force) throws QiniuException {
        StringMap params = new StringMap().putNotEmpty("pipeline", pipeline).putNotEmpty("notifyURL", notifyURL).putWhen("force", 1, force);
        return this.pfop(bucket, key, fops, params);
    }

    public String pfop(String bucket, String key, String fops, String pipeline, String notifyURL, Integer type, boolean force) throws QiniuException {
        StringMap params = new StringMap().putNotNull("type", type).putNotEmpty("pipeline", pipeline).putNotEmpty("notifyURL", notifyURL).putWhen("force", 1, force);
        return this.pfop(bucket, key, fops, params);
    }

    @Deprecated
    public OperationStatus prefop(String persistentId) throws QiniuException {
        return this.prefop(persistentId, OperationStatus.class);
    }

    @Deprecated
    public <T> T prefop(String persistentId, Class<T> retClass) throws QiniuException {
        return this.prefop(null, persistentId, retClass);
    }

    public OperationStatus prefop(String bucket, String persistentId) throws QiniuException {
        return this.prefop(bucket, persistentId, OperationStatus.class);
    }

    public <T> T prefop(String bucket, String persistentId, Class<T> retClass) throws QiniuException {
        String url = null;
        url = !StringUtils.isNullOrEmpty(bucket) ? this.configuration.apiHost(this.auth.accessKey, bucket) : this.configuration.apiHost();
        ApiPrefop.Request request = new ApiPrefop.Request(url, persistentId);
        ApiPrefop api = new ApiPrefop(this.client, new Api.Config.Builder().setAuth(this.auth).build());
        ApiPrefop.Response response = api.request(request);
        if (response == null) {
            throw QiniuException.unrecoverable("unknown error");
        }
        if (!response.isOK()) {
            throw new QiniuException(response.getResponse());
        }
        return response.getResponse().jsonToObject(retClass);
    }
}

