/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.util.Json;
import com.qiniu.util.UrlSafeBase64;

public class RegionReqInfo {
    private final String accessKey;
    private final String bucket;

    public RegionReqInfo(String token) throws QiniuException {
        try {
            String[] strings = token.split(":");
            this.accessKey = strings[0];
            String policy = new String(UrlSafeBase64.decode(strings[2]), Constants.UTF_8);
            this.bucket = Json.decode(policy).get("scope").toString().split(":")[0];
        }
        catch (Exception e) {
            throw new QiniuException(e, "token is invalid");
        }
    }

    public RegionReqInfo(String accessKey, String bucket) {
        this.accessKey = accessKey;
        this.bucket = bucket;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getBucket() {
        return this.bucket;
    }
}

