/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.util.Json;
import com.qiniu.util.Md5;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FixBlockUploader {
    private final int blockSize;
    private final Configuration configuration;
    private final Client client;
    private final Recorder recorder;
    private final int retryMax;
    private String host;

    public FixBlockUploader(int blockSize, Configuration configuration, Client client, Recorder recorder) {
        assert (blockSize > 0 && blockSize % 0x400000 == 0) : "blockSize must be multiples of 4M ";
        if (configuration == null) {
            configuration = new Configuration();
        }
        if (client == null) {
            client = new Client(configuration);
        }
        this.configuration = configuration;
        this.client = client;
        this.blockSize = blockSize;
        this.recorder = recorder;
        this.retryMax = configuration.retryMax;
    }

    public Response upload(File file, String token, String key) throws QiniuException {
        return this.upload(file, token, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response upload(File file, String token, String key, StringMap metaParams) throws QiniuException {
        FileBlockData blockData;
        try {
            blockData = new FileBlockData(this.blockSize, file);
        }
        catch (IOException e) {
            throw new QiniuException(e);
        }
        try {
            Response response = this.upload((BlockData)blockData, new StaticToken(token), key, metaParams);
            return response;
        }
        finally {
            ((BlockData)blockData).close();
        }
    }

    public Response upload(InputStream is, long inputStreamLength, String token, String key) throws QiniuException {
        return this.upload(is, inputStreamLength, token, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response upload(InputStream is, long inputStreamLength, String token, String key, StringMap metaParams) throws QiniuException {
        try (InputStreamBlockData blockData = new InputStreamBlockData(this.blockSize, is, inputStreamLength);){
            Response response = this.upload((BlockData)blockData, new StaticToken(token), key, metaParams);
            return response;
        }
    }

    public Response upload(BlockData blockData, String token, String key, StringMap metaParams) throws QiniuException {
        return this.upload(blockData, new StaticToken(token), key, metaParams);
    }

    public Response upload(BlockData blockData, Token token, String key, StringMap metaParams) throws QiniuException {
        assert (!StringUtils.isNullOrEmpty(key)) : "key must not be null or empty";
        if (key == null) {
            key = "";
        }
        String bucket = FixBlockUploader.parseBucket(token.getUpToken());
        String base64Key = UrlSafeBase64.encodeToString(key);
        if (this.host == null) {
            this.changeHost(token.getUpToken());
        }
        if (metaParams == null) {
            metaParams = new StringMap();
        }
        RetryCounter counter = new RetryCounter(this.retryMax);
        String uploadId = null;
        List<EtagIdx> etags = null;
        Record record = null;
        UploadRecordHelper helper = new UploadRecordHelper(this.recorder, bucket, base64Key, blockData.getContentUUID(), this.blockSize + "*:|>?^ \b" + this.getClass().getName());
        if (blockData.isRetryable() && helper.isActiveRecord(record = helper.reloadRecord(), blockData)) {
            try {
                blockData.skipByte(record.size);
                blockData.skipBlock(record.etagIdxes.size());
                etags = record.etagIdxes;
                uploadId = record.uploadId;
            }
            catch (IOException e) {
                helper.delRecord();
                throw new QiniuException(e, "blockData skip failed. record file is already deleted, please retry if needed.");
            }
        }
        if (uploadId == null) {
            uploadId = this.init(bucket, base64Key, token.getUpToken());
            etags = new ArrayList<EtagIdx>();
            record = this.initRecord(uploadId, etags);
        }
        while (blockData.hasNext()) {
            try {
                blockData.nextBlock();
            }
            catch (IOException e) {
                throw new QiniuException(e);
            }
            byte[] data = blockData.getCurrentBlockData();
            int size = blockData.getCurrentRead();
            int index = blockData.getCurrentIndex();
            String etag = this.uploadBlock(bucket, base64Key, token.getUpToken(), uploadId, data, size, index, counter);
            etags.add(new EtagIdx(etag, index));
            record.size += (long)size;
            helper.syncRecord(record);
        }
        Response res = this.makeFile(bucket, base64Key, token.getUpToken(), uploadId, etags, metaParams);
        if (res.needRetry()) {
            res = this.makeFile(bucket, base64Key, token.getUpToken(), uploadId, etags, metaParams);
        }
        if (res.needRetry()) {
            if (res.needSwitchServer()) {
                this.changeHost(token.getUpToken());
            }
            res = this.makeFile(bucket, base64Key, token.getUpToken(), uploadId, etags, metaParams);
        }
        if (res.isOK()) {
            helper.delRecord();
        }
        return res;
    }

    String init(String bucket, String base64Key, String upToken) throws QiniuException {
        String url = this.host + "/buckets/" + bucket + "/objects/" + base64Key + "/uploads";
        Response res = this.client.post(url, new byte[0], new StringMap().put("Authorization", "UpToken " + upToken), "");
        Object _uploadId = res.jsonToMap().get("uploadId");
        if (_uploadId == null) {
            throw new QiniuException(res);
        }
        String uploadId = _uploadId.toString();
        if (uploadId.length() < 10) {
            throw new QiniuException(res);
        }
        return uploadId;
    }

    String uploadBlock(String bucket, String base64Key, String upToken, String uploadId, byte[] data, int dataLength, int partNum, RetryCounter counter) throws QiniuException {
        Response res = this.uploadBlockWithRetry(bucket, base64Key, upToken, uploadId, data, dataLength, partNum, counter);
        StringMap m = res.jsonToMap();
        Object etag = m.get("etag");
        if (etag == null) {
            throw new QiniuException(res);
        }
        return etag.toString();
    }

    Response uploadBlockWithRetry(String bucket, String base64Key, String upToken, String uploadId, byte[] data, int dataLength, int partNum, RetryCounter counter) throws QiniuException {
        Response res = this.uploadBlock1(bucket, base64Key, upToken, uploadId, data, dataLength, partNum, counter);
        if (res.isOK()) {
            return res;
        }
        if (res.needSwitchServer()) {
            this.changeHost(upToken);
        }
        if (!counter.inRange()) {
            return res;
        }
        if (res.needRetry()) {
            counter.retried();
            res = this.uploadBlock1(bucket, base64Key, upToken, uploadId, data, dataLength, partNum, counter);
            if (res.isOK()) {
                return res;
            }
            if (res.needSwitchServer()) {
                this.changeHost(upToken);
            }
            if (!counter.inRange()) {
                return res;
            }
            if (res.needRetry()) {
                counter.retried();
                res = this.uploadBlock1(bucket, base64Key, upToken, uploadId, data, dataLength, partNum, counter);
            }
        }
        return res;
    }

    Response uploadBlock1(String bucket, String base64Key, String upToken, String uploadId, byte[] data, int dataLength, int partNum, RetryCounter counter) throws QiniuException {
        String url = this.host + "/buckets/" + bucket + "/objects/" + base64Key + "/uploads/" + uploadId + "/" + partNum;
        StringMap headers = new StringMap().put("Content-MD5", Md5.md5(data, 0, dataLength)).put("Authorization", "UpToken " + upToken);
        Response res = this.client.put(url, data, 0, dataLength, headers, "application/octet-stream");
        return res;
    }

    Response makeFile(String bucket, String base64Key, String upToken, String uploadId, List<EtagIdx> etags, StringMap metaParams) throws QiniuException {
        String url = this.host + "/buckets/" + bucket + "/objects/" + base64Key + "/uploads/" + uploadId;
        byte[] data = new EtagIdxPart(etags).toString().getBytes(Charset.forName("UTF-8"));
        final StringMap headers = new StringMap().put("Authorization", "UpToken " + upToken);
        metaParams.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                if (key != null && key.startsWith("X-Qn-Meta-")) {
                    headers.put(key, value);
                }
            }
        });
        Response res = this.client.post(url, data, headers, "text/plain");
        return res;
    }

    private void changeHost(String upToken) throws QiniuException {
        String h1 = this.configuration.upHost(upToken);
        this.host = !h1.equalsIgnoreCase(this.host) ? h1 : this.configuration.upHostBackup(upToken);
    }

    static String parseBucket(String upToken) throws QiniuException {
        try {
            String part3 = upToken.split(":")[2];
            byte[] b = UrlSafeBase64.decode(part3);
            StringMap m = Json.decode(new String(b, Charset.forName("UTF-8")));
            String scope = m.get("scope").toString();
            return scope.split(":")[0];
        }
        catch (Exception e) {
            throw new QiniuException(e, "invalid uptoken : " + upToken);
        }
    }

    Record initRecord(String uploadId, List<EtagIdx> etagIdxes) {
        Record record = new Record();
        record.createdTime = new Date().getTime();
        record.uploadId = uploadId;
        record.size = 0L;
        record.etagIdxes = etagIdxes != null ? etagIdxes : new ArrayList();
        return record;
    }

    static void sleep(long millis) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class StaticToken
    implements Token {
        String token;

        public StaticToken(String token) {
            this.token = token;
        }

        @Override
        public String getUpToken() {
            return this.token;
        }
    }

    public static class InputStreamBlockData
    extends BlockData {
        final long totalLength;
        final boolean closedAfterUpload;
        boolean retryable;
        String contentUUID;
        InputStream is;
        byte[] data;
        int readLength = -1;
        int index = 0;
        long alreadyReadSize = 0L;

        public InputStreamBlockData(int blockDataSize, InputStream is, long totalLength) {
            this(blockDataSize, is, totalLength, true);
        }

        public InputStreamBlockData(int blockDataSize, InputStream is, long totalLength, boolean closedAfterUpload) {
            this(blockDataSize, is, totalLength, closedAfterUpload, false, "");
        }

        public InputStreamBlockData(int blockDataSize, InputStream is, long totalLength, boolean closedAfterUpload, boolean retryable, String contentUUID) {
            super(blockDataSize);
            this.is = is;
            this.totalLength = totalLength;
            this.closedAfterUpload = closedAfterUpload;
            this.data = new byte[blockDataSize];
            this.retryable = retryable;
            this.contentUUID = contentUUID;
        }

        @Override
        public long size() {
            return this.totalLength;
        }

        @Override
        public byte[] getCurrentBlockData() {
            return this.data;
        }

        @Override
        public int getCurrentRead() {
            return this.readLength;
        }

        @Override
        public int getCurrentIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.alreadyReadSize < this.totalLength;
        }

        @Override
        public void nextBlock() throws IOException {
            int rl;
            this.readLength = 0;
            int rlt = rl = this.is.read(this.data);
            while (rlt < this.blockDataSize && rl != -1) {
                FixBlockUploader.sleep(100L);
                rl = this.is.read(this.data, rlt, this.blockDataSize - rlt);
                if (rl <= 0) continue;
                rlt += rl;
            }
            if (rlt != -1) {
                this.readLength = rlt;
                this.alreadyReadSize += (long)this.readLength;
                ++this.index;
            }
        }

        @Override
        public void skipByte(long n) throws IOException {
            long sn;
            long snt = sn = this.is.skip(n);
            while (snt < n) {
                if (sn == -1L) {
                    throw new IOException("input stream does not have enough content: " + n);
                }
                FixBlockUploader.sleep(100L);
                sn = this.is.skip(n - snt);
                if (sn <= 0L) continue;
                snt += sn;
            }
            this.alreadyReadSize += n;
        }

        @Override
        public void skipBlock(int blockCount) {
            this.index += blockCount;
        }

        @Override
        public boolean isRetryable() {
            return this.retryable;
        }

        @Override
        public String getContentUUID() {
            return this.contentUUID;
        }

        @Override
        public void close() {
            if (this.closedAfterUpload) {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class FileBlockData
    extends BlockData {
        final long totalLength;
        String contentUUID;
        FileInputStream fis;
        byte[] data;
        int readLength = -1;
        int index = 0;
        long alreadyReadSize = 0L;

        public FileBlockData(int blockDataSize, File file) throws FileNotFoundException {
            super(blockDataSize);
            this.fis = new FileInputStream(file);
            this.totalLength = file.length();
            this.data = new byte[blockDataSize];
            this.contentUUID = file.lastModified() + "_.-^ \b" + file.getAbsolutePath();
        }

        @Override
        public long size() {
            return this.totalLength;
        }

        @Override
        public byte[] getCurrentBlockData() {
            return this.data;
        }

        @Override
        public int getCurrentRead() {
            return this.readLength;
        }

        @Override
        public int getCurrentIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.alreadyReadSize < this.totalLength;
        }

        @Override
        public void nextBlock() throws IOException {
            this.readLength = this.fis.read(this.data);
            this.alreadyReadSize += (long)this.readLength;
            ++this.index;
        }

        @Override
        public void skipByte(long n) throws IOException {
            this.fis.skip(n);
            this.alreadyReadSize += n;
        }

        @Override
        public void skipBlock(int blockCount) {
            this.index += blockCount;
        }

        @Override
        public boolean isRetryable() {
            return true;
        }

        @Override
        public String getContentUUID() {
            return this.contentUUID;
        }

        @Override
        public void close() {
            try {
                this.fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class RetryCounter {
        int count;

        RetryCounter(int max) {
            this.count = max;
        }

        public void retried() {
            --this.count;
        }

        public boolean inRange() {
            return this.count > 0;
        }
    }

    public static interface Token {
        public String getUpToken();
    }

    public static abstract class BlockData {
        public final int blockDataSize;

        BlockData(int blockDataSize) {
            this.blockDataSize = blockDataSize;
        }

        public abstract int getCurrentIndex();

        public abstract byte[] getCurrentBlockData();

        public abstract int getCurrentRead();

        public abstract boolean hasNext();

        public abstract void nextBlock() throws IOException;

        public abstract void skipByte(long var1) throws IOException;

        public abstract void skipBlock(int var1);

        public abstract void close();

        public abstract long size();

        public abstract boolean isRetryable();

        public abstract String getContentUUID();
    }

    class UploadRecordHelper {
        Recorder recorder;
        String recordFileKey;

        public UploadRecordHelper(Recorder recorder, String bucket, String base64Key, String contentUUID, String uploaderSUID) {
            if (recorder != null) {
                this.recorder = recorder;
                this.recordFileKey = recorder.recorderKeyGenerate(bucket, base64Key, contentUUID, uploaderSUID);
            }
        }

        public Record reloadRecord() {
            Record record = null;
            if (this.recorder != null) {
                try {
                    byte[] data = this.recorder.get(this.recordFileKey);
                    record = (Record)new Gson().fromJson(new String(data, Charset.forName("UTF-8")), Record.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (record == null) {
                record = new Record();
            }
            return record;
        }

        public void delRecord() {
            if (this.recorder != null) {
                this.recorder.del(this.recordFileKey);
            }
        }

        public void syncRecord(Record record) {
            if (this.recorder != null) {
                this.recorder.set(this.recordFileKey, new Gson().toJson((Object)record).getBytes(Charset.forName("UTF-8")));
            }
        }

        public boolean isActiveRecord(Record record, BlockData blockData) {
            boolean isOk;
            boolean bl = isOk = record.createdTime > new Date().getTime() - 432000000L && !StringUtils.isNullOrEmpty(record.uploadId) && record.etagIdxes != null && record.etagIdxes.size() > 0 && record.size > 0L && record.size <= blockData.size();
            if (isOk) {
                int p = 0;
                for (EtagIdx ei : record.etagIdxes) {
                    if (ei.PartNumber == p + 1) {
                        p = ei.PartNumber;
                        continue;
                    }
                    return false;
                }
            }
            return isOk;
        }
    }

    class Record {
        long createdTime;
        String uploadId;
        long size;
        List<EtagIdx> etagIdxes;

        Record() {
        }
    }

    class EtagIdx {
        String Etag;
        int PartNumber;

        EtagIdx(String etag, int idx) {
            this.Etag = etag;
            this.PartNumber = idx;
        }

        public String toString() {
            return new Gson().toJson((Object)this);
        }
    }

    class EtagIdxPart {
        List<EtagIdx> parts;

        EtagIdxPart(List<EtagIdx> parts) {
            this.parts = parts;
        }

        public String toString() {
            return new Gson().toJson((Object)this);
        }
    }
}

