/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage.persistent;

import com.qiniu.storage.Recorder;
import com.qiniu.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Date;

public final class FileRecorder
implements Recorder {
    private final File directory;
    private static final String SPLIT = "*:|>?^ \b";

    public FileRecorder(String directory) throws IOException {
        this(new File(directory));
    }

    public FileRecorder(File directory) throws IOException {
        this.directory = directory;
        if (!directory.exists()) {
            boolean r = directory.mkdirs();
            if (!r) {
                throw new IOException("mkdir failed");
            }
            return;
        }
        if (!directory.isDirectory()) {
            throw new IOException("does not mkdir");
        }
    }

    @Override
    public synchronized void set(String key, byte[] data) {
        if (StringUtils.isNullOrEmpty(key)) {
            return;
        }
        File f = new File(this.directory, key);
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(f);
            fo.write(data);
            fo.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fo != null) {
            try {
                fo.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized byte[] get(String key) {
        if (StringUtils.isNullOrEmpty(key)) {
            return null;
        }
        File f = new File(this.directory, key);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fi = null;
        byte[] data = null;
        int read = 0;
        try {
            if (this.outOfDate(f)) {
                f.delete();
                return null;
            }
            data = new byte[(int)f.length()];
            fi = new FileInputStream(f);
            read = fi.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fi != null) {
            try {
                fi.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (read == 0) {
            return null;
        }
        return data;
    }

    private boolean outOfDate(File f) {
        return f.lastModified() + 432000000L < new Date().getTime();
    }

    @Override
    public synchronized void del(String key) {
        if (StringUtils.isNullOrEmpty(key)) {
            return;
        }
        File f = new File(this.directory, key);
        f.delete();
    }

    @Override
    public String recorderKeyGenerate(String key, File file) {
        return FileRecorder.hash(key + SPLIT + file.lastModified() + SPLIT + file.getAbsolutePath());
    }

    @Override
    public String recorderKeyGenerate(String bucket, String key, String contentDataSUID, String uploaderSUID) {
        return FileRecorder.hash(bucket + SPLIT + key + SPLIT + contentDataSUID + SPLIT + uploaderSUID);
    }

    private static String hash(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hash = digest.digest(base.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                hexString.append(Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1));
            }
            return hexString.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }
}

