/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.FormUploader;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploader;
import com.qiniu.storage.StreamUploader;
import com.qiniu.storage.UpCompletionHandler;
import com.qiniu.util.StringMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class UploadManager {
    private final Client client;
    private final Recorder recorder;
    private final Configuration configuration;

    public UploadManager(Configuration c) {
        this(c, null);
    }

    public UploadManager(Configuration c, Recorder recorder) {
        this.configuration = c.clone();
        this.client = new Client(this.configuration);
        this.recorder = recorder;
    }

    private static void checkArgs(String key, byte[] data, File f, String token) {
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static StringMap filterParam(StringMap params) {
        final StringMap ret = new StringMap();
        if (params == null) {
            return ret;
        }
        params.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                if (value == null) {
                    return;
                }
                String val = value.toString();
                if (key.startsWith("x:") && !val.equals("")) {
                    ret.put(key, val);
                }
            }
        });
        return ret;
    }

    public Response put(byte[] data, String key, String token) throws QiniuException {
        return this.put(data, key, token, null, null, false);
    }

    public Response put(byte[] data, String key, String token, StringMap params, String mime, boolean checkCrc) throws QiniuException {
        UploadManager.checkArgs(key, data, null, token);
        if (mime == null) {
            mime = "application/octet-stream";
        }
        params = UploadManager.filterParam(params);
        return new FormUploader(this.client, token, key, data, params, mime, checkCrc, this.configuration).upload();
    }

    public Response put(String filePath, String key, String token) throws QiniuException {
        return this.put(filePath, key, token, null, null, false);
    }

    public Response put(String filePath, String key, String token, StringMap params, String mime, boolean checkCrc) throws QiniuException {
        return this.put(new File(filePath), key, token, params, mime, checkCrc);
    }

    public Response put(File file, String key, String token) throws QiniuException {
        return this.put(file, key, token, null, null, false);
    }

    public Response put(File file, String key, String token, StringMap params, String mime, boolean checkCrc) throws QiniuException {
        UploadManager.checkArgs(key, null, file, token);
        if (mime == null) {
            mime = "application/octet-stream";
        }
        params = UploadManager.filterParam(params);
        long size = file.length();
        if (size <= (long)this.configuration.putThreshold) {
            return new FormUploader(this.client, token, key, file, params, mime, checkCrc, this.configuration).upload();
        }
        ResumeUploader uploader = new ResumeUploader(this.client, token, key, file, params, mime, this.recorder, this.configuration);
        return uploader.upload();
    }

    public void asyncPut(byte[] data, String key, String token, StringMap params, String mime, boolean checkCrc, UpCompletionHandler handler) throws IOException {
        UploadManager.checkArgs(key, data, null, token);
        if (mime == null) {
            mime = "application/octet-stream";
        }
        params = UploadManager.filterParam(params);
        new FormUploader(this.client, token, key, data, params, mime, checkCrc, this.configuration).asyncUpload(handler);
    }

    public Response put(InputStream stream, String key, String token, StringMap params, String mime) throws QiniuException {
        String message = null;
        if (stream == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        StreamUploader uploader = new StreamUploader(this.client, token, key, stream, params, mime, this.configuration);
        return uploader.upload();
    }
}

