/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.cdn;

import com.qiniu.cdn.CdnResult;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CdnManager {
    private static final int MAX_API_REFRESH_URL_COUNT = 100;
    private static final int MAX_API_REFRESH_DIR_COUNT = 10;
    private static final int MAX_API_PREFETCH_URL_COUNT = 100;
    private final Auth auth;
    private final String server;
    private final Client client;

    public CdnManager(Auth auth) {
        this(auth, "http://fusion.qiniuapi.com");
    }

    private CdnManager(Auth auth, String server) {
        this.auth = auth;
        this.server = server;
        this.client = new Client();
    }

    public CdnResult.RefreshResult refreshUrls(String[] urls) throws QiniuException {
        return this.refreshUrlsAndDirs(urls, null);
    }

    public CdnResult.RefreshResult refreshDirs(String[] dirs) throws QiniuException {
        return this.refreshUrlsAndDirs(null, dirs);
    }

    public CdnResult.RefreshResult refreshUrlsAndDirs(String[] urls, String[] dirs) throws QiniuException {
        if (urls != null && urls.length > 100) {
            throw new QiniuException(new Exception("url count exceeds the max refresh limit per request"));
        }
        if (dirs != null && dirs.length > 10) {
            throw new QiniuException(new Exception("dir count exceeds the max refresh limit per request"));
        }
        HashMap<String, String[]> req = new HashMap<String, String[]>();
        if (urls != null) {
            req.put("urls", urls);
        }
        if (dirs != null) {
            req.put("dirs", dirs);
        }
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/refresh";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        Response response = this.client.post(url, body, headers, "application/json");
        return response.jsonToObject(CdnResult.RefreshResult.class);
    }

    public CdnResult.PrefetchResult prefetchUrls(String[] urls) throws QiniuException {
        if (urls != null && urls.length > 100) {
            throw new QiniuException(new Exception("url count exceeds the max prefetch limit per request"));
        }
        HashMap<String, String[]> req = new HashMap<String, String[]>();
        req.put("urls", urls);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/prefetch";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        Response response = this.client.post(url, body, headers, "application/json");
        return response.jsonToObject(CdnResult.PrefetchResult.class);
    }

    public CdnResult.BandwidthResult getBandwidthData(String[] domains, String startDate, String endDate, String granularity) throws QiniuException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("domains", StringUtils.join(domains, ";"));
        req.put("startDate", startDate);
        req.put("endDate", endDate);
        req.put("granularity", granularity);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/bandwidth";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        Response response = this.client.post(url, body, headers, "application/json");
        return response.jsonToObject(CdnResult.BandwidthResult.class);
    }

    public CdnResult.FluxResult getFluxData(String[] domains, String startDate, String endDate, String granularity) throws QiniuException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("domains", StringUtils.join(domains, ";"));
        req.put("startDate", startDate);
        req.put("endDate", endDate);
        req.put("granularity", granularity);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/flux";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        Response response = this.client.post(url, body, headers, "application/json");
        return response.jsonToObject(CdnResult.FluxResult.class);
    }

    public CdnResult.LogListResult getCdnLogList(String[] domains, String logDate) throws QiniuException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("domains", StringUtils.join(domains, ";"));
        req.put("day", logDate);
        byte[] body = Json.encode(req).getBytes(Constants.UTF_8);
        String url = this.server + "/v2/tune/log/list";
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        Response response = this.client.post(url, body, headers, "application/json");
        return response.jsonToObject(CdnResult.LogListResult.class);
    }

    public static String createTimestampAntiLeechUrl(String host, String fileName, StringMap queryStringMap, String encryptKey, long deadline) throws UnsupportedEncodingException, MalformedURLException, NoSuchAlgorithmException {
        String urlToSign;
        String encodedFileName = URLEncoder.encode(fileName, "utf-8").replaceAll("\\+", "%20");
        if (queryStringMap != null && queryStringMap.size() > 0) {
            ArrayList<String> queryStrings = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : queryStringMap.map().entrySet()) {
                StringBuilder queryStringBuilder = new StringBuilder();
                queryStringBuilder.append(URLEncoder.encode(entry.getKey(), "utf-8"));
                queryStringBuilder.append("=");
                queryStringBuilder.append(URLEncoder.encode(entry.getValue().toString(), "utf-8"));
                queryStrings.add(queryStringBuilder.toString());
            }
            urlToSign = String.format("%s/%s?%s", host, encodedFileName, StringUtils.join(queryStrings, "&"));
        } else {
            urlToSign = String.format("%s/%s", host, encodedFileName);
        }
        URL urlObj = new URL(urlToSign);
        String path = urlObj.getPath();
        String expireHex = Long.toHexString(deadline);
        String toSignStr = String.format("%s%s%s", encryptKey, path, expireHex);
        String signedStr = StringUtils.md5Lower(toSignStr);
        String signedUrl = urlObj.getQuery() != null ? String.format("%s&sign=%s&t=%s", urlToSign, signedStr, expireHex) : String.format("%s?sign=%s&t=%s", urlToSign, signedStr, expireHex);
        return signedUrl;
    }
}

