/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.rtc;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;

public class RtcAppManager {
    private final Auth auth;
    private final String host;
    private final Client client;
    private StringMap params;

    public RtcAppManager(Auth auth) {
        this(auth, "http://rtc.qiniuapi.com");
    }

    public RtcAppManager(Auth auth, String host) {
        this.auth = auth;
        this.host = host;
        this.client = new Client();
        this.params = new StringMap();
    }

    public RtcAppManager(Auth auth, String host, Client client) {
        this.auth = auth;
        this.host = host;
        this.client = client;
        this.params = new StringMap();
    }

    public Response createApp(String hub, String title, int maxUsers, boolean noAutoKickUser) throws QiniuException {
        if (hub != null) {
            this.params.put("hub", hub);
        }
        if (title != null) {
            this.params.put("title", title);
        }
        if (hub != null) {
            this.params.put("maxUsers", maxUsers);
        }
        this.params.put("noAutoKickUser", noAutoKickUser);
        String url = String.format("%s%s", this.host, "/v3/apps");
        byte[] body = Json.encode(this.params).getBytes(Constants.UTF_8);
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }

    public Response getApp(String appId) throws QiniuException {
        String url = String.format("%s%s%s", this.host, "/v3/apps/", appId);
        StringMap headers = this.auth.authorizationV2(url);
        return this.client.get(url, headers);
    }

    public Response deleteApp(String appId) throws QiniuException {
        String urlStr = String.format("%s%s%s", this.host, "/v3/apps/", appId);
        StringMap headers = this.auth.authorizationV2(urlStr, "DELETE", null, null);
        return this.client.delete(urlStr, headers);
    }

    public Response updateApp(String appId, String hub, String title, int maxUsers, boolean noAutoKickUser) throws QiniuException {
        if (hub != null) {
            this.params.put("hub", hub);
        }
        if (title != null) {
            this.params.put("title", title);
        }
        if (hub != null) {
            this.params.put("maxUsers", maxUsers);
        }
        this.params.put("noAutoKickUser", noAutoKickUser);
        String url = String.format("%s%s%s", this.host, "/v3/apps/", appId);
        byte[] body = Json.encode(this.params).getBytes(Constants.UTF_8);
        StringMap headers = this.auth.authorizationV2(url, "POST", body, "application/json");
        return this.client.post(url, body, headers, "application/json");
    }
}

