/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadToken;

public abstract class BaseUploader {
    protected final Client client;
    protected final String key;
    protected final String upToken;
    protected final ConfigHelper configHelper;
    protected final Configuration config;

    BaseUploader(Client client, String upToken, String key, Configuration config) {
        this.client = client;
        this.key = key;
        this.upToken = upToken;
        this.config = config == null ? new Configuration() : config.clone();
        this.configHelper = new ConfigHelper(this.config);
    }

    public Response upload() throws QiniuException {
        if (this.config == null) {
            throw QiniuException.unrecoverable("config can't be empty");
        }
        return this.uploadWithRegionRetry();
    }

    private Response uploadWithRegionRetry() throws QiniuException {
        Response response = null;
        while (true) {
            try {
                while (this.couldSwitchRegionAndRetry(response = this.uploadFlows(), null) && this.couldReloadSource() && this.reloadSource() && this.config.region != null && this.config.region.switchRegion(new UploadToken(this.upToken))) {
                }
            }
            catch (QiniuException e) {
                if (this.couldSwitchRegionAndRetry(null, e) && this.couldReloadSource() && this.reloadSource() && this.config.region != null && this.config.region.switchRegion(new UploadToken(this.upToken))) continue;
                throw e;
            }
            break;
        }
        return response;
    }

    abstract Response uploadFlows() throws QiniuException;

    abstract boolean couldReloadSource();

    abstract boolean reloadSource();

    private boolean couldSwitchRegionAndRetry(Response response, QiniuException exception) {
        Response checkResponse = response;
        if (checkResponse == null && exception != null) {
            checkResponse = exception.response;
        }
        if (checkResponse != null) {
            int statusCode = checkResponse.statusCode;
            return statusCode > -2 && statusCode < 200 || statusCode > 299 && statusCode != 401 && statusCode != 413 && statusCode != 419 && statusCode != 608 && statusCode != 614 && statusCode != 630;
        }
        return exception == null || !exception.isUnrecoverable();
    }
}

