/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.common.collection;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Collections {
    public static <E> SafeIteratorList<E> safeIteratorList(List<E> list) {
        return new SafeIteratorList<E>(list);
    }

    public static <K, V> SafeIteratorMap<K, V> safeIteratorMap(Map<K, V> map) {
        return new SafeIteratorMap<K, V>(map);
    }

    public static class SafeIteratorList<E>
    implements List<E>,
    SafeIteratorCollection<E> {
        private final List<E> mInner;
        private int mIteratingCount = 0;
        private final List<Runnable> mPendingActions = new ArrayList<Runnable>();

        SafeIteratorList(@NonNull List<E> inner) {
            this.mInner = inner;
        }

        @Override
        public boolean isIterating() {
            return this.mIteratingCount > 0;
        }

        @Override
        public int size() {
            return this.mInner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.mInner.isEmpty();
        }

        @Override
        public boolean contains(@Nullable Object obj) {
            return this.mInner.contains(obj);
        }

        @Override
        @NonNull
        public Iterator<E> iterator() {
            throw new RuntimeException("please use forEach");
        }

        @Override
        @Nullable
        public Object[] toArray() {
            return this.mInner.toArray();
        }

        @Override
        public <T> T[] toArray(@Nullable T[] array) {
            return this.mInner.toArray(array);
        }

        @Override
        public boolean add(E error) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.add(error));
                return true;
            }
            return this.mInner.add(error);
        }

        @Override
        public boolean remove(@Nullable Object obj) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.remove(obj));
                return true;
            }
            return this.mInner.remove(obj);
        }

        @Override
        public boolean containsAll(@NonNull Collection<?> collection) {
            return this.mInner.containsAll(collection);
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends E> collection) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.addAll(collection));
                return true;
            }
            return this.mInner.addAll(collection);
        }

        @Override
        public boolean addAll(int index, @NonNull Collection<? extends E> c) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.addAll(index, c));
                return true;
            }
            return this.mInner.addAll(c);
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> collection) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.removeAll(collection));
                return true;
            }
            return this.mInner.removeAll(collection);
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> collection) {
            return this.mInner.retainAll(collection);
        }

        @Override
        public void clear() {
            if (this.isIterating()) {
                this.mPendingActions.add(this.mInner::clear);
                return;
            }
            this.mInner.clear();
        }

        @Override
        public E get(int index) {
            return this.mInner.get(index);
        }

        @Override
        public E set(int index, E element) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.set(index, element));
                return element;
            }
            return this.mInner.set(index, element);
        }

        @Override
        public void add(int index, E element) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.add(index, element));
                return;
            }
            this.mInner.add(index, element);
        }

        @Override
        public E remove(int index) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.remove(index));
                return this.mInner.get(index);
            }
            return this.mInner.remove(index);
        }

        @Override
        public int indexOf(@Nullable Object obj) {
            return this.mInner.indexOf(obj);
        }

        @Override
        public int lastIndexOf(@Nullable Object obj) {
            return this.mInner.lastIndexOf(obj);
        }

        @Override
        @NonNull
        public ListIterator<E> listIterator() {
            throw new RuntimeException("please use forEach");
        }

        @Override
        @NonNull
        public ListIterator<E> listIterator(int index) {
            throw new RuntimeException("please use forEach");
        }

        @Override
        @NonNull
        public List<E> subList(int fromIndex, int toIndex) {
            return this.mInner.subList(fromIndex, toIndex);
        }

        @Override
        public void forEach(IteratorAction<E> action) {
            ++this.mIteratingCount;
            for (E e : this.mInner) {
                action.run(e);
            }
            --this.mIteratingCount;
            if (!this.isIterating()) {
                while (this.mPendingActions.size() > 0) {
                    this.mPendingActions.remove(0).run();
                }
            }
        }

        @Override
        public void forEachWithIndex(IteratorActionWithIndex<E> action) {
            ++this.mIteratingCount;
            int size = this.mInner.size();
            for (int i = 0; i < size; ++i) {
                action.run(i, this.mInner.get(i));
            }
            --this.mIteratingCount;
            if (!this.isIterating()) {
                while (this.mPendingActions.size() > 0) {
                    this.mPendingActions.remove(0).run();
                }
            }
        }
    }

    public static class SafeIteratorMap<K, V>
    implements Map<K, V>,
    SafeIteratorCollection<Map.Entry<K, V>> {
        private final Map<K, V> mInner;
        private int mIteratingCount = 0;
        private final List<Runnable> mPendingActions = new ArrayList<Runnable>();

        SafeIteratorMap(@NonNull Map<K, V> inner) {
            this.mInner = inner;
        }

        @Override
        public boolean isIterating() {
            return this.mIteratingCount > 0;
        }

        @Override
        public int size() {
            return this.mInner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.mInner.isEmpty();
        }

        @Override
        public boolean containsKey(@Nullable Object key) {
            return this.mInner.containsKey(key);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return this.mInner.containsValue(value);
        }

        @Override
        @Nullable
        public V get(@Nullable Object key) {
            return this.mInner.get(key);
        }

        @Override
        @Nullable
        public V put(@NonNull K key, @NonNull V value) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.put(key, value));
                return value;
            }
            return this.mInner.put(key, value);
        }

        @Override
        @Nullable
        public V remove(@Nullable Object key) {
            if (this.isIterating()) {
                V value = this.mInner.get(key);
                this.mPendingActions.add(() -> this.mInner.remove(key));
                return value;
            }
            return this.mInner.remove(key);
        }

        @Override
        public void putAll(@NonNull Map<? extends K, ? extends V> map) {
            if (this.isIterating()) {
                this.mPendingActions.add(() -> this.mInner.putAll(map));
                return;
            }
            this.mInner.putAll(map);
        }

        @Override
        public void clear() {
            if (this.isIterating()) {
                this.mPendingActions.add(this.mInner::clear);
                return;
            }
            this.mInner.clear();
        }

        @Override
        @NonNull
        public Set<K> keySet() {
            return this.mInner.keySet();
        }

        @Override
        @NonNull
        public Collection<V> values() {
            return this.mInner.values();
        }

        @Override
        @NonNull
        public Set<Map.Entry<K, V>> entrySet() {
            return this.mInner.entrySet();
        }

        @Override
        public void forEach(IteratorAction<Map.Entry<K, V>> action) {
            ++this.mIteratingCount;
            Set<Map.Entry<K, V>> entries = this.mInner.entrySet();
            for (Map.Entry<K, V> entry : entries) {
                action.run(entry);
            }
            --this.mIteratingCount;
            if (!this.isIterating()) {
                while (this.mPendingActions.size() > 0) {
                    this.mPendingActions.remove(0).run();
                }
            }
        }

        @Override
        public void forEachWithIndex(IteratorActionWithIndex<Map.Entry<K, V>> action) {
            ++this.mIteratingCount;
            Set<Map.Entry<K, V>> entries = this.mInner.entrySet();
            int index = 0;
            for (Map.Entry<K, V> entry : entries) {
                action.run(index, entry);
                ++index;
            }
            --this.mIteratingCount;
            if (!this.isIterating()) {
                while (this.mPendingActions.size() > 0) {
                    this.mPendingActions.remove(0).run();
                }
            }
        }
    }

    public static interface IteratorActionWithIndex<E> {
        public void run(int var1, E var2);
    }

    public static interface IteratorAction<E> {
        public void run(E var1);
    }

    public static interface SafeIteratorCollection<E> {
        public void forEach(IteratorAction<E> var1);

        public void forEachWithIndex(IteratorActionWithIndex<E> var1);

        public boolean isIterating();
    }
}

