/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.common.thread;

import android.util.Log;
import com.qiniu.qplayer2ext.common.thread.BCoreThreadPool;
import com.qiniu.qplayer2ext.common.thread.BThreadPool;
import com.qiniu.qplayer2ext.common.thread.BThreadTask;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/qiniu/qplayer2ext/common/thread/BThreadPoolExecutor;", "Ljava/util/concurrent/AbstractExecutorService;", "name", "", "(Ljava/lang/String;)V", "isHighPriority", "", "isRisky", "poolId", "", "state", "taskNum", "Ljava/util/concurrent/atomic/AtomicInteger;", "awaitTermination", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "execute", "", "command", "Ljava/lang/Runnable;", "highPriority", "value", "isShutdown", "isTerminated", "shutdown", "shutdownNow", "", "Companion", "qplayer2-ext-1.4.1_release"})
public final class BThreadPoolExecutor
extends AbstractExecutorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int poolId;
    @NotNull
    private final AtomicInteger taskNum;
    private boolean isHighPriority;
    private boolean isRisky;
    private int state;
    @NotNull
    private static final String TAG = "BThreadPoolExecutor";
    private static final int STATE_NORMAL = 0;
    private static final int STATE_SHUTDOWN = 1;
    private static final int STATE_TERMINATED = 2;
    @NotNull
    private static final AtomicInteger poolNum = new AtomicInteger(0);

    public BThreadPoolExecutor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.poolId = poolNum.incrementAndGet();
        this.taskNum = new AtomicInteger(0);
        boolean bl = true;
        if (BThreadPool.Companion.getRiskThreadName$qplayer2_ext_1_4_1_release() != null) {
            List<String> list = BThreadPool.Companion.getRiskThreadName$qplayer2_ext_1_4_1_release();
            Intrinsics.checkNotNull(list);
            if (list.contains(this.name)) {
                Log.w((String)TAG, (String)("BThreadPoolExecutor:" + this.name + " is risky!!!"));
                this.isRisky = true;
            }
        }
    }

    @NotNull
    public final BThreadPoolExecutor highPriority(boolean value) {
        this.isHighPriority = value;
        return this;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (this.state != 0) {
            Log.w((String)TAG, (String)Intrinsics.stringPlus((String)"execute skipped, state=", (Object)this.state));
            return;
        }
        BThreadTask bThreadTask = new BThreadTask(this.poolId, this.name, this.taskNum.incrementAndGet(), command, this.isHighPriority);
        if (this.isRisky) {
            BThreadPool.Companion.getRiskThreadPool$qplayer2_ext_1_4_1_release().execute(bThreadTask);
        } else {
            BThreadPool.Companion.getCoreThreadPool$qplayer2_ext_1_4_1_release().execute(bThreadTask);
        }
    }

    @Override
    public void shutdown() {
        Log.i((String)TAG, (String)(this.name + '-' + this.poolId + " shutdown"));
        this.state = 1;
        if (this.isRisky) {
            BThreadPool.Companion.getRiskThreadPool$qplayer2_ext_1_4_1_release().stopExecutor(this.poolId);
        } else {
            BThreadPool.Companion.getCoreThreadPool$qplayer2_ext_1_4_1_release().stopExecutor(this.poolId);
            BCoreThreadPool bCoreThreadPool = BThreadPool.Companion.getMDiscardThreadPool$qplayer2_ext_1_4_1_release();
            if (bCoreThreadPool != null) {
                bCoreThreadPool.stopExecutorNow(this.poolId);
            }
        }
        this.state = 2;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        Log.i((String)TAG, (String)(this.name + '-' + this.poolId + " shutdownNow"));
        this.state = 1;
        List<Runnable> removedList = null;
        if (this.isRisky) {
            removedList = BThreadPool.Companion.getRiskThreadPool$qplayer2_ext_1_4_1_release().stopExecutorNow(this.poolId);
        } else {
            List<Runnable> list;
            removedList = BThreadPool.Companion.getCoreThreadPool$qplayer2_ext_1_4_1_release().stopExecutorNow(this.poolId);
            BCoreThreadPool bCoreThreadPool = BThreadPool.Companion.getMDiscardThreadPool$qplayer2_ext_1_4_1_release();
            if (bCoreThreadPool != null && (list = bCoreThreadPool.stopExecutorNow(this.poolId)) != null) {
                List<Runnable> list2;
                List<Runnable> it = list2 = list;
                boolean bl = false;
                removedList.addAll((Collection<Runnable>)it);
            }
        }
        this.state = 2;
        return removedList;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 1;
    }

    @Override
    public boolean isTerminated() {
        return this.state >= 2;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        throw new UnsupportedOperationException("BThreadPoolExecutor not support awaitTermination");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/qiniu/qplayer2ext/common/thread/BThreadPoolExecutor$Companion;", "", "()V", "STATE_NORMAL", "", "STATE_SHUTDOWN", "STATE_TERMINATED", "TAG", "", "poolNum", "Ljava/util/concurrent/atomic/AtomicInteger;", "qplayer2-ext-1.4.1_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

