/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.common.thread;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.concurrent.FutureTask;

public class HandlerThreads {
    public static final int THREAD_UI = 0;
    public static final int THREAD_REPORT = 1;
    public static final int THREAD_BACKGROUND = 2;
    public static final int THREAD_BACK_IO = 3;
    public static final int THREAD_SIZE = 4;
    private static final Handler[] INTERNAL_HANDLER_LIST = new Handler[4];
    private static final String[] INTERNAL_THREAD_NAME_LIST = new String[]{"thread_ui", "thread_report", "thread_background", "thread_back_io"};
    private static final Object LOCK = new Object();
    private static final HashMap<String, Handler> HANDLER_MAP = new HashMap(4);

    public static void post(int index, Runnable r) {
        Handler handler = HandlerThreads.getHandler(index);
        handler.post(r);
    }

    public static void postDelayed(int index, Runnable r, long delayMillis) {
        Handler handler = HandlerThreads.getHandler(index);
        handler.postDelayed(r, delayMillis);
    }

    public static void postAtFront(int index, Runnable r) {
        Handler handler = HandlerThreads.getHandler(index);
        handler.postAtFrontOfQueue(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Handler getHandler(int index) {
        if (INTERNAL_HANDLER_LIST[index] != null) return INTERNAL_HANDLER_LIST[index];
        Handler[] handlerArray = INTERNAL_HANDLER_LIST;
        synchronized (INTERNAL_HANDLER_LIST) {
            Handler handler;
            if (index == 0) {
                handler = new Handler(Looper.getMainLooper());
            } else {
                HandlerThread thread = new HandlerThread(INTERNAL_THREAD_NAME_LIST[index], 1);
                thread.start();
                handler = new Handler(thread.getLooper());
            }
            HandlerThreads.INTERNAL_HANDLER_LIST[index] = handler;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INTERNAL_HANDLER_LIST[index];
        }
    }

    public static Looper getLooper(int index) {
        return HandlerThreads.getHandler(index).getLooper();
    }

    public static boolean runningOn(int index) {
        return HandlerThreads.getHandler(index).getLooper() == Looper.myLooper();
    }

    public static void runOnBlocking(int index, Runnable r) {
        if (HandlerThreads.runningOn(index)) {
            r.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(r, null);
            HandlerThreads.post(index, task);
            try {
                task.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while waiting for runnable", e);
            }
        }
    }

    public static void runOn(int index, Runnable r) {
        if (HandlerThreads.runningOn(index)) {
            r.run();
        } else {
            HandlerThreads.post(index, r);
        }
    }

    public static void remove(int index, Runnable r) {
        HandlerThreads.getHandler(index).removeCallbacks(r);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThreadModel {
    }
}

