/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.common.thread;

import android.annotation.SuppressLint;
import android.os.SystemClock;
import android.util.Log;
import com.qiniu.qplayer2ext.common.thread.BThreadPool;
import com.qiniu.qplayer2ext.common.thread.MonitorThreadPool;
import com.qiniu.qplayer2ext.common.thread.MonitorThreadTask;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 02\u00020\u0001:\u0002/0B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\r2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u001c\u0010\"\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010#2\b\u0010\u001f\u001a\u0004\u0018\u00010\rH\u0014J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0003J\b\u0010&\u001a\u00020\u001eH\u0014J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\rH\u0016J<\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\"\u0010,\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050-j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005`.H\u0014R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Lcom/qiniu/qplayer2ext/common/thread/MonitorThreadPool;", "Ljava/util/concurrent/ThreadPoolExecutor;", "name", "", "corePoolSize", "", "maximumPoolSize", "keepAliveTime", "", "unit", "Ljava/util/concurrent/TimeUnit;", "workQueue", "Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "(Ljava/lang/String;IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;)V", "handleTimeOutCycle", "getHandleTimeOutCycle", "()I", "setHandleTimeOutCycle", "(I)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "runningTasks", "", "Lcom/qiniu/qplayer2ext/common/thread/MonitorThreadTask;", "getRunningTasks", "()Ljava/util/List;", "afterExecute", "", "r", "t", "", "beforeExecute", "Ljava/lang/Thread;", "changeName", "newName", "checkThread", "execute", "command", "handleTimeOutThread", "timeoutTaskCount", "normalTaskCount", "timeoutTaskMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "BThreadFactory", "Companion", "qplayer2-ext-1.4.1_release"})
public class MonitorThreadPool
extends ThreadPoolExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final List<MonitorThreadTask> runningTasks;
    private int handleTimeOutCycle;
    @NotNull
    public static final String TAG = "MonitorThreadPool";
    private static final long CHECK_PERIOD_TIME = 20000L;
    @NotNull
    private static final Lazy<Timer> mTimer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)Companion.mTimer.2.INSTANCE);
    @NotNull
    private static final HashSet<WeakReference<MonitorThreadPool>> poolSet = new HashSet();

    public MonitorThreadPool(@NotNull String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, @Nullable TimeUnit unit, @Nullable BlockingQueue<Runnable> workQueue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new BThreadFactory(name));
        this.name = name;
        this.runningTasks = new LinkedList();
        Companion.getMTimer$qplayer2_ext_1_4_1_release();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public final void changeName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this.name = newName;
        ThreadFactory threadFactory = this.getThreadFactory();
        if (threadFactory == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.qiniu.qplayer2ext.common.thread.MonitorThreadPool.BThreadFactory");
        }
        ((BThreadFactory)threadFactory).setName(newName);
    }

    @NotNull
    protected final List<MonitorThreadTask> getRunningTasks() {
        return this.runningTasks;
    }

    public final int getHandleTimeOutCycle() {
        return this.handleTimeOutCycle;
    }

    public final void setHandleTimeOutCycle(int n) {
        this.handleTimeOutCycle = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkThread() {
        List<MonitorThreadTask> list;
        int timeOutCount = 0;
        int normalTaskCount = 0;
        MonitorThreadPool monitorThreadPool = this;
        int n = monitorThreadPool.handleTimeOutCycle;
        monitorThreadPool.handleTimeOutCycle = n + 1;
        HashMap<String, Integer> timeoutTaskMap = new HashMap<String, Integer>();
        List<MonitorThreadTask> list2 = list = this.runningTasks;
        synchronized (list2) {
            boolean bl = false;
            for (MonitorThreadTask runningTask : this.getRunningTasks()) {
                long cost = SystemClock.uptimeMillis() - runningTask.getStartTime();
                if (cost > (long)(BThreadPool.Companion.getWarnTreadTime$qplayer2_ext_1_4_1_release() * 1000)) {
                    Object object;
                    Object object2;
                    Object object3;
                    Thread thread = runningTask.getCurrentThread();
                    StringBuilder stringBuilder = new StringBuilder().append((Object)(thread == null ? null : thread.getName())).append(" is running too long! cost ").append(cost).append(" ms,thread state:");
                    thread = runningTask.getCurrentThread();
                    Log.w((String)TAG, (String)stringBuilder.append((Object)(thread == null ? null : thread.getState())).toString());
                    int n2 = timeOutCount;
                    timeOutCount = n2 + 1;
                    if (this.getHandleTimeOutCycle() >= 3) {
                        Integer num = timeoutTaskMap.get(runningTask.getPoolName());
                        if (num == null) {
                            object3 = timeoutTaskMap;
                            object2 = runningTask.getPoolName();
                            object = 1;
                            object3.put(object2, object);
                        } else {
                            object3 = timeoutTaskMap;
                            object2 = runningTask.getPoolName();
                            object = num + 1;
                            object3.put(object2, object);
                        }
                    }
                    if (runningTask.getHasReported()) continue;
                    HashMap<String, Object> reportMap = new HashMap<String, Object>();
                    object3 = reportMap;
                    object2 = "pool_name";
                    object = runningTask.getPoolName();
                    object3.put(object2, object);
                    object3 = runningTask.getCurrentThread();
                    if (object3 != null && (object2 = ((Thread)object3).getName()) != null) {
                        Object it = object = object2;
                        boolean bl2 = false;
                        String cfr_ignored_0 = (String)reportMap.put("thread_name", it);
                    }
                    Log.w((String)TAG, (String)Intrinsics.stringPlus((String)"reportThreadTimeOut:", reportMap));
                    runningTask.setHasReported(true);
                    object3 = runningTask.getCurrentThread();
                    if (object3 != null) {
                        Object it = object2 = object3;
                        boolean bl3 = false;
                        StringBuilder traceText = new StringBuilder();
                        Object object4 = ((Thread)it).getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it.stackTrace");
                        for (StackTraceElement trace : object4) {
                            traceText.append(Intrinsics.stringPlus((String)trace.toString(), (Object)"\n"));
                        }
                        Log.w((String)TAG, (String)Intrinsics.stringPlus((String)"=================stackTrace===================\n", (Object)traceText));
                        Map map = reportMap;
                        object4 = "stack";
                        String string = traceText.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"traceText.toString()");
                        map.put(object4, string);
                    }
                    object3 = BThreadPool.Companion.getMPoolReporter$qplayer2_ext_1_4_1_release();
                    if (object3 == null) continue;
                    object3.reportThreadTimeOut((Map<String, String>)reportMap);
                    continue;
                }
                int n3 = normalTaskCount;
                normalTaskCount = n3 + 1;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (this.handleTimeOutCycle >= 3) {
            this.handleTimeOutCycle = 0;
            this.handleTimeOutThread(timeOutCount, normalTaskCount, timeoutTaskMap);
        }
    }

    protected void handleTimeOutThread(int timeoutTaskCount, int normalTaskCount, @NotNull HashMap<String, Integer> timeoutTaskMap) {
        Intrinsics.checkNotNullParameter(timeoutTaskMap, (String)"timeoutTaskMap");
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!(command instanceof MonitorThreadTask)) {
            MonitorThreadTask runnable = new MonitorThreadTask(command, this.name);
            super.execute(runnable);
        } else {
            super.execute(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(@Nullable Thread t, @Nullable Runnable r) {
        List<MonitorThreadTask> list;
        super.beforeExecute(t, r);
        boolean bl = r instanceof MonitorThreadTask;
        if (!bl) {
            boolean bl2 = false;
            String string = "Runnable must is BThreadTask";
            throw new IllegalArgumentException(string.toString());
        }
        if (r == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.qiniu.qplayer2ext.common.thread.MonitorThreadTask");
        }
        ((MonitorThreadTask)r).setStartTime(SystemClock.uptimeMillis());
        ((MonitorThreadTask)r).setCurrentThread(t);
        List<MonitorThreadTask> list2 = list = this.runningTasks;
        synchronized (list2) {
            boolean bl3 = false;
            boolean bl4 = this.getRunningTasks().add((MonitorThreadTask)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(@Nullable Runnable r, @Nullable Throwable t) {
        List<MonitorThreadTask> list;
        super.afterExecute(r, t);
        boolean bl = r instanceof MonitorThreadTask;
        if (!bl) {
            boolean bl2 = false;
            String string = "Runnable must is BThreadTask";
            throw new IllegalArgumentException(string.toString());
        }
        if (r == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.qiniu.qplayer2ext.common.thread.MonitorThreadTask");
        }
        ((MonitorThreadTask)r).setCurrentThread(null);
        List<MonitorThreadTask> list2 = list = this.runningTasks;
        synchronized (list2) {
            boolean bl3 = false;
            boolean bl4 = this.getRunningTasks().remove(r);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR-\u0010\r\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000ej\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/qiniu/qplayer2ext/common/thread/MonitorThreadPool$Companion;", "", "()V", "CHECK_PERIOD_TIME", "", "TAG", "", "mTimer", "Ljava/util/Timer;", "getMTimer$qplayer2_ext_1_4_1_release", "()Ljava/util/Timer;", "mTimer$delegate", "Lkotlin/Lazy;", "poolSet", "Ljava/util/HashSet;", "Ljava/lang/ref/WeakReference;", "Lcom/qiniu/qplayer2ext/common/thread/MonitorThreadPool;", "Lkotlin/collections/HashSet;", "getPoolSet", "()Ljava/util/HashSet;", "qplayer2-ext-1.4.1_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timer getMTimer$qplayer2_ext_1_4_1_release() {
            Lazy lazy = mTimer$delegate;
            Object var2_2 = null;
            return (Timer)lazy.getValue();
        }

        @NotNull
        public final HashSet<WeakReference<MonitorThreadPool>> getPoolSet() {
            return poolSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/qiniu/qplayer2ext/common/thread/MonitorThreadPool$BThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "name", "", "(Ljava/lang/String;)V", "group", "Ljava/lang/ThreadGroup;", "getName", "()Ljava/lang/String;", "setName", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "qplayer2-ext-1.4.1_release"})
    @SuppressLint(value={"NewThread"})
    public static final class BThreadFactory
    implements ThreadFactory {
        @NotNull
        private String name;
        @NotNull
        private final ThreadGroup group;
        @NotNull
        private final AtomicInteger threadNumber;

        public BThreadFactory(@NotNull String name) {
            ThreadGroup threadGroup;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.threadNumber = new AtomicInteger(1);
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                ThreadGroup threadGroup2 = s.getThreadGroup();
                Intrinsics.checkNotNullExpressionValue((Object)threadGroup2, (String)"s.threadGroup");
                threadGroup = threadGroup2;
            } else {
                ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
                Intrinsics.checkNotNullExpressionValue((Object)threadGroup3, (String)"currentThread().threadGroup");
                threadGroup = threadGroup3;
            }
            this.group = threadGroup;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Thread t = new Thread(this.group, r, this.name + '-' + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

