/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.layer.gesture;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.qiniu.qplayer2ext.commonplayer.layer.gesture.PlayerGestureView;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/CustomGestureDetector;", "Landroid/view/GestureDetector;", "context", "Landroid/content/Context;", "mGestureListener", "Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/CustomGestureDetector$PlayerGestureListener;", "touchListener", "Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/PlayerGestureView$OnTouchGestureListener;", "(Landroid/content/Context;Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/CustomGestureDetector$PlayerGestureListener;Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/PlayerGestureView$OnTouchGestureListener;)V", "mEnableGesture", "", "getMGestureListener", "()Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/CustomGestureDetector$PlayerGestureListener;", "onTouchEvent", "ev", "Landroid/view/MotionEvent;", "setGestureEnabled", "", "enabled", "setHorizontalGestureEnabled", "PlayerGestureListener", "qplayer2-ext-1.4.1_release"})
final class CustomGestureDetector
extends GestureDetector {
    @NotNull
    private final PlayerGestureListener mGestureListener;
    private boolean mEnableGesture;

    public CustomGestureDetector(@NotNull Context context, @NotNull PlayerGestureListener mGestureListener, @Nullable PlayerGestureView.OnTouchGestureListener touchListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mGestureListener), (String)"mGestureListener");
        super(context, (GestureDetector.OnGestureListener)mGestureListener);
        this.mGestureListener = mGestureListener;
        this.mEnableGesture = true;
        this.mGestureListener.setTouchGestureListener(touchListener);
    }

    @NotNull
    public final PlayerGestureListener getMGestureListener() {
        return this.mGestureListener;
    }

    public final void setGestureEnabled(boolean enabled) {
        this.mEnableGesture = enabled;
    }

    public final void setHorizontalGestureEnabled(boolean enabled) {
        this.mGestureListener.setHorizontalGestureEnabled(enabled);
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (ev.getAction() == 3) {
            this.mGestureListener.cancel$qplayer2_ext_1_4_1_release();
        }
        this.mGestureListener.onTouch(ev);
        if (ev.getAction() == 1 && this.mGestureListener.onUp(ev)) {
            return true;
        }
        return ev.getAction() == 2 && !this.mEnableGesture ? false : super.onTouchEvent(ev);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001f\u0018\u0000 =2\u00020\u0001:\u0001=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J\r\u0010\u001a\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001bJ\u001c\u0010\u001c\u001a\u00020\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J,\u0010\"\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0002J,\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001fH\u0016J\u0010\u0010)\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001fH\u0016J(\u0010*\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u001fH\u0016J4\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J*\u0010.\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0016J\u0010\u0010/\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001fH\u0016J,\u00100\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J,\u00101\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J\u000e\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u001fJ\u000e\u00104\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001fJ(\u00105\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0016\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003J\u000e\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\bJ\u0010\u0010;\u001a\u00020\u00162\b\u0010<\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/CustomGestureDetector$PlayerGestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "mGestureWidth", "", "mGestureHeight", "(II)V", "mCurrentAction", "mEnableHorizontalGesture", "", "mInHorizontalMoving", "getMInHorizontalMoving", "()Z", "setMInHorizontalMoving", "(Z)V", "mInVerticalMoving", "getMInVerticalMoving", "setMInVerticalMoving", "mOnTouchGestureListener", "Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/PlayerGestureView$OnTouchGestureListener;", "mProgressFactor", "", "beginHorizontalDrag", "", "progress", "point", "Lkotlin/Pair;", "cancel", "cancel$qplayer2_ext_1_4_1_release", "endHorizontalDrag", "getDeltaFactorX", "e1", "Landroid/view/MotionEvent;", "e2", "getDeltaFactorY", "handleScroll", "distanceX", "distanceY", "horizontalDag", "pointerCount", "onDoubleTap", "e", "onDown", "onHorizontalMove", "onLongPress", "onProgressChanged", "action", "onScroll", "onSingleTapConfirmed", "onStartTrackingTouch", "onStopTrackingTouch", "onTouch", "ev", "onUp", "onVerticalMove", "setGestureSize", "width", "height", "setHorizontalGestureEnabled", "enabled", "setTouchGestureListener", "onTouchGestureListener", "Companion", "qplayer2-ext-1.4.1_release"})
    public static final class PlayerGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int mGestureWidth;
        private int mGestureHeight;
        private boolean mInVerticalMoving;
        private boolean mInHorizontalMoving;
        @Nullable
        private PlayerGestureView.OnTouchGestureListener mOnTouchGestureListener;
        private float mProgressFactor;
        private int mCurrentAction;
        private boolean mEnableHorizontalGesture;
        private static final float MIN_HORIZONTAL_PROGRESS_FACTOR = 0.02f;

        public PlayerGestureListener(int mGestureWidth, int mGestureHeight) {
            this.mGestureWidth = mGestureWidth;
            this.mGestureHeight = mGestureHeight;
            this.mCurrentAction = -1;
            this.mEnableHorizontalGesture = true;
        }

        public final boolean getMInVerticalMoving() {
            return this.mInVerticalMoving;
        }

        public final void setMInVerticalMoving(boolean bl) {
            this.mInVerticalMoving = bl;
        }

        public final boolean getMInHorizontalMoving() {
            return this.mInHorizontalMoving;
        }

        public final void setMInHorizontalMoving(boolean bl) {
            this.mInHorizontalMoving = bl;
        }

        public boolean onDown(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
            if (onTouchGestureListener != null) {
                onTouchGestureListener.onDown(e);
            }
            return true;
        }

        public final void setGestureSize(int width, int height) {
            this.mGestureWidth = width;
            this.mGestureHeight = height;
        }

        public final void cancel$qplayer2_ext_1_4_1_release() {
            PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
            if (onTouchGestureListener != null) {
                onTouchGestureListener.onScrollCancel();
            }
            this.mInHorizontalMoving = false;
            this.mInVerticalMoving = false;
        }

        public final boolean onUp(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            float startX = e.getX();
            float startY = e.getY();
            this.endHorizontalDrag((Pair<Float, Float>)new Pair((Object)Float.valueOf(startX), (Object)Float.valueOf(startY)));
            if (this.mInHorizontalMoving) {
                this.mInHorizontalMoving = false;
            }
            if (this.mInVerticalMoving) {
                this.mInVerticalMoving = false;
            }
            return false;
        }

        public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.mOnTouchGestureListener != null) {
                PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
                Intrinsics.checkNotNull((Object)onTouchGestureListener);
                bl = onTouchGestureListener.onSingleTapConfirmed();
            } else {
                bl = super.onSingleTapConfirmed(e);
            }
            return bl;
        }

        public boolean onDoubleTap(@NotNull MotionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.mOnTouchGestureListener != null) {
                PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
                Intrinsics.checkNotNull((Object)onTouchGestureListener);
                bl = onTouchGestureListener.onDoubleTap(e);
            } else {
                bl = super.onDoubleTap(e);
            }
            return bl;
        }

        public boolean onScroll(@Nullable MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
            return this.handleScroll(e1, e2, distanceX, distanceY) ? true : super.onScroll(e1, e2, distanceX, distanceY);
        }

        public void onLongPress(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.mOnTouchGestureListener != null) {
                PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
                Intrinsics.checkNotNull((Object)onTouchGestureListener);
                onTouchGestureListener.onLongPress(e);
            }
        }

        private final boolean handleScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (e1 == null || e2 == null) {
                return false;
            }
            float startX = e1.getX();
            if (startX < (float)this.mGestureWidth * 0.01f || startX > (float)this.mGestureWidth * 0.95f) {
                return true;
            }
            float startY = e1.getY();
            if (startY < (float)this.mGestureHeight * 0.1f || startY > (float)this.mGestureHeight * 0.95f) {
                return true;
            }
            boolean consumed = false;
            float moveDelta = Math.abs(distanceY) - Math.abs(distanceX);
            if (moveDelta > 0.0f) {
                consumed = this.onVerticalMove(e1, e2, distanceX, distanceY);
            } else if (moveDelta < 0.0f) {
                consumed = this.onHorizontalMove(e1, e2, distanceX, distanceY);
            }
            return consumed;
        }

        private final boolean onHorizontalMove(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (this.mInVerticalMoving || !this.mEnableHorizontalGesture) {
                return false;
            }
            float deltaFactorX = this.getDeltaFactorX(e1, e2);
            if (Math.abs(deltaFactorX) < 0.02f && !this.mInHorizontalMoving) {
                return false;
            }
            int e1PointerCount = e1.getPointerCount();
            int e2PointerCount = e2.getPointerCount();
            int pointerCount = Math.max(e1PointerCount, e2PointerCount);
            if (!this.mInHorizontalMoving) {
                this.beginHorizontalDrag(deltaFactorX, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e1.getX()), (Object)Float.valueOf(e1.getY())));
            }
            float endX = e2.getX();
            float endY = e2.getY();
            this.horizontalDag(deltaFactorX, pointerCount, (Pair<Float, Float>)new Pair((Object)Float.valueOf(endX), (Object)Float.valueOf(endY)));
            if (!this.mInHorizontalMoving) {
                this.mInHorizontalMoving = true;
            }
            return false;
        }

        private final void beginHorizontalDrag(float progress, Pair<Float, Float> point) {
            this.mProgressFactor = progress;
            this.onStartTrackingTouch(1, progress, point);
        }

        private final void horizontalDag(float progress, int pointerCount, Pair<Float, Float> point) {
            this.mProgressFactor = progress;
            this.onProgressChanged(1, progress, pointerCount, point);
        }

        private final void endHorizontalDrag(Pair<Float, Float> point) {
            if (this.mInHorizontalMoving || this.mInVerticalMoving) {
                this.onStopTrackingTouch(this.mCurrentAction, this.mProgressFactor, point);
            }
        }

        public final void setTouchGestureListener(@Nullable PlayerGestureView.OnTouchGestureListener onTouchGestureListener) {
            this.mOnTouchGestureListener = onTouchGestureListener;
        }

        private final void onStartTrackingTouch(int action, float progress, Pair<Float, Float> point) {
            if (this.mOnTouchGestureListener != null) {
                PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
                Intrinsics.checkNotNull((Object)onTouchGestureListener);
                onTouchGestureListener.onScrollStart(action, progress, point);
            }
        }

        private final void onProgressChanged(int action, float progress, int pointerCount, Pair<Float, Float> point) {
            this.mCurrentAction = action;
            if (this.mOnTouchGestureListener != null) {
                PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
                Intrinsics.checkNotNull((Object)onTouchGestureListener);
                onTouchGestureListener.onScroll(action, progress, pointerCount, point);
            }
        }

        private final void onStopTrackingTouch(int action, float progress, Pair<Float, Float> point) {
            if (this.mOnTouchGestureListener != null) {
                PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
                Intrinsics.checkNotNull((Object)onTouchGestureListener);
                onTouchGestureListener.onScrollStop(action, progress, point);
            }
        }

        private final boolean onVerticalMove(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (this.mInHorizontalMoving) {
                return false;
            }
            int e1PointerCount = e1.getPointerCount();
            int e2PointerCount = e2.getPointerCount();
            int pointerCount = Math.max(e1PointerCount, e2PointerCount);
            float startX1 = e1.getX();
            float startX2 = e2.getX();
            int gestureWidth = this.mGestureWidth;
            float left = gestureWidth / 3;
            float right = left * (float)2;
            if (startX1 < left && startX2 < left) {
                float diffFactor = this.getDeltaFactorY(e1, e2);
                if (!this.mInVerticalMoving) {
                    this.mInVerticalMoving = true;
                    this.onStartTrackingTouch(5, diffFactor, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e1.getX()), (Object)Float.valueOf(e1.getY())));
                }
                this.onProgressChanged(5, diffFactor, pointerCount, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e2.getX()), (Object)Float.valueOf(e2.getY())));
            } else if (startX1 > right && startX2 > right) {
                float diffFactor = this.getDeltaFactorY(e1, e2);
                if (!this.mInVerticalMoving) {
                    this.mInVerticalMoving = true;
                    this.onStartTrackingTouch(6, diffFactor, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e1.getX()), (Object)Float.valueOf(e1.getY())));
                }
                this.onProgressChanged(6, diffFactor, pointerCount, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e2.getX()), (Object)Float.valueOf(e2.getY())));
            }
            return false;
        }

        private final float getDeltaFactorX(MotionEvent e1, MotionEvent e2) {
            int rangeX = this.mGestureWidth;
            if (rangeX <= 0) {
                return 0.0f;
            }
            float deltaX = e2.getX() - e1.getX();
            return deltaX / (float)rangeX;
        }

        private final float getDeltaFactorY(MotionEvent e1, MotionEvent e2) {
            int rangeY = this.mGestureHeight;
            if (rangeY <= 0) {
                return 0.0f;
            }
            float deltaY = e2.getY() - e1.getY();
            return deltaY / (float)rangeY;
        }

        public final void onTouch(@NotNull MotionEvent ev) {
            Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
            if (this.mOnTouchGestureListener != null) {
                PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.mOnTouchGestureListener;
                Intrinsics.checkNotNull((Object)onTouchGestureListener);
                onTouchGestureListener.onTouch(ev);
            }
        }

        public final void setHorizontalGestureEnabled(boolean enabled) {
            this.mEnableHorizontalGesture = enabled;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/CustomGestureDetector$PlayerGestureListener$Companion;", "", "()V", "MIN_HORIZONTAL_PROGRESS_FACTOR", "", "qplayer2-ext-1.4.1_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

