/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.layer.gesture;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.qiniu.qplayer2ext.commonplayer.layer.gesture.PlayerGestureView;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000fJ\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/MultiPointerGestureDetector;", "", "context", "Landroid/content/Context;", "gestureListener", "Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/PlayerGestureView$OnTouchGestureListener;", "(Landroid/content/Context;Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/PlayerGestureView$OnTouchGestureListener;)V", "getGestureListener", "()Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/PlayerGestureView$OnTouchGestureListener;", "setGestureListener", "(Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/PlayerGestureView$OnTouchGestureListener;)V", "isConsideredDoubleTap", "", "()Z", "mCurrentDownEvent", "Landroid/view/MotionEvent;", "mDoubleClickCount", "", "mDoubleTapRunnable", "Ljava/lang/Runnable;", "mDoubleTapSlopSquare", "mHandler", "Landroid/os/Handler;", "mPreviousDownEvent", "mPreviousUpEvent", "onTouchEvent", "event", "reset", "", "Companion", "qplayer2-ext-1.4.1_release"})
public final class MultiPointerGestureDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PlayerGestureView.OnTouchGestureListener gestureListener;
    @Nullable
    private MotionEvent mCurrentDownEvent;
    @Nullable
    private MotionEvent mPreviousDownEvent;
    @Nullable
    private MotionEvent mPreviousUpEvent;
    @NotNull
    private Handler mHandler;
    private int mDoubleTapSlopSquare;
    private int mDoubleClickCount;
    @NotNull
    private final Runnable mDoubleTapRunnable;
    @NotNull
    public static final String TAG = "GestureDetector";
    private static final int DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout() + 100;
    private static final int DOUBLE_TAP_MIN_TIME = 50;

    public MultiPointerGestureDetector(@NotNull Context context, @Nullable PlayerGestureView.OnTouchGestureListener gestureListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.gestureListener = gestureListener;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mDoubleTapRunnable = () -> MultiPointerGestureDetector.mDoubleTapRunnable$lambda-0(this);
        this.mDoubleTapSlopSquare = ViewConfiguration.get((Context)context).getScaledDoubleTapSlop();
    }

    @Nullable
    public final PlayerGestureView.OnTouchGestureListener getGestureListener() {
        return this.gestureListener;
    }

    public final void setGestureListener(@Nullable PlayerGestureView.OnTouchGestureListener onTouchGestureListener) {
        this.gestureListener = onTouchGestureListener;
    }

    private final boolean isConsideredDoubleTap() {
        if (this.mPreviousDownEvent == null || this.mPreviousUpEvent == null || this.mCurrentDownEvent == null || this.mDoubleClickCount != 2) {
            return false;
        }
        MotionEvent motionEvent = this.mCurrentDownEvent;
        Intrinsics.checkNotNull((Object)motionEvent);
        long l = motionEvent.getEventTime();
        MotionEvent motionEvent2 = this.mPreviousUpEvent;
        Intrinsics.checkNotNull((Object)motionEvent2);
        long deltaTime = l - motionEvent2.getEventTime();
        if (deltaTime > (long)DOUBLE_TAP_TIMEOUT || deltaTime < 50L) {
            return false;
        }
        MotionEvent motionEvent3 = this.mPreviousDownEvent;
        Intrinsics.checkNotNull((Object)motionEvent3);
        int n = (int)motionEvent3.getX();
        MotionEvent motionEvent4 = this.mCurrentDownEvent;
        Intrinsics.checkNotNull((Object)motionEvent4);
        int deltaX = n - (int)motionEvent4.getX();
        MotionEvent motionEvent5 = this.mPreviousDownEvent;
        Intrinsics.checkNotNull((Object)motionEvent5);
        int n2 = (int)motionEvent5.getY();
        MotionEvent motionEvent6 = this.mCurrentDownEvent;
        Intrinsics.checkNotNull((Object)motionEvent6);
        int deltaY = n2 - (int)motionEvent6.getY();
        return Math.abs(deltaX) < this.mDoubleTapSlopSquare && Math.abs(deltaY) < this.mDoubleTapSlopSquare;
    }

    public final boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int n = event.getActionMasked();
        switch (n) {
            case 0: {
                this.mHandler.removeCallbacks(this.mDoubleTapRunnable);
                if (this.mPreviousDownEvent == null) {
                    this.mPreviousDownEvent = MotionEvent.obtain((MotionEvent)event);
                    Log.d((String)TAG, (String)"pre down event instance");
                    break;
                }
                this.mCurrentDownEvent = MotionEvent.obtain((MotionEvent)event);
                Log.d((String)TAG, (String)"curr down event instance");
                break;
            }
            case 5: {
                boolean isTwoPointer;
                boolean bl = isTwoPointer = event.getPointerCount() == 2;
                if (!isTwoPointer) {
                    this.reset();
                    Log.d((String)TAG, (String)"reset when not two finger");
                    break;
                }
                MultiPointerGestureDetector multiPointerGestureDetector = this;
                int n2 = multiPointerGestureDetector.mDoubleClickCount;
                multiPointerGestureDetector.mDoubleClickCount = n2 + 1;
                multiPointerGestureDetector = StringCompanionObject.INSTANCE;
                String string = "click count (%d)";
                Object[] objectArray = new Object[]{this.mDoubleClickCount};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                Log.d((String)TAG, (String)string2);
                break;
            }
            case 1: {
                if (this.mPreviousUpEvent == null && this.mPreviousDownEvent != null) {
                    this.mPreviousUpEvent = MotionEvent.obtain((MotionEvent)event);
                    Log.d((String)TAG, (String)"action up when double click");
                    this.mHandler.removeCallbacks(this.mDoubleTapRunnable);
                    this.mHandler.postDelayed(this.mDoubleTapRunnable, (long)(DOUBLE_TAP_TIMEOUT + 50));
                    break;
                }
                if (this.isConsideredDoubleTap()) {
                    PlayerGestureView.OnTouchGestureListener onTouchGestureListener = this.gestureListener;
                    if (onTouchGestureListener != null) {
                        onTouchGestureListener.onTwoFingerDoubleTap();
                    }
                    this.reset();
                    return true;
                }
                this.reset();
                break;
            }
            case 3: {
                this.mHandler.removeCallbacks(this.mDoubleTapRunnable);
                this.reset();
            }
        }
        return false;
    }

    private final void reset() {
        this.mPreviousDownEvent = null;
        this.mPreviousUpEvent = null;
        this.mCurrentDownEvent = null;
        this.mDoubleClickCount = 0;
        this.mHandler.removeCallbacks(this.mDoubleTapRunnable);
    }

    private static final void mDoubleTapRunnable$lambda-0(MultiPointerGestureDetector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Log.d((String)TAG, (String)"handle time out msg");
        this$0.reset();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/gesture/MultiPointerGestureDetector$Companion;", "", "()V", "DOUBLE_TAP_MIN_TIME", "", "DOUBLE_TAP_TIMEOUT", "TAG", "", "qplayer2-ext-1.4.1_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

