/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.layer.gesture;

import android.view.GestureDetector;
import android.view.MotionEvent;
import com.qiniu.qplayer2ext.commonplayer.layer.gesture.PlayerGestureView;
import kotlin.Pair;

public class PlayerGestureListener
extends GestureDetector.SimpleOnGestureListener {
    private int mGestureWidth;
    private int mGestureHeight;
    private boolean mInVerticalMoving = false;
    private boolean mInHorizontalMoving = false;
    private PlayerGestureView.OnTouchGestureListener mOnTouchGestureListener = null;
    private float mProgressFactor = 0.0f;
    private int mCurrentAction = -1;
    private boolean mEnableHorizontalGesture = true;
    private static final float MIN_HORIZONTAL_PROGRESS_FACTOR = 0.05f;

    public PlayerGestureListener(int gestureWidth, int gestureHeight) {
        this.mGestureWidth = gestureWidth;
        this.mGestureHeight = gestureHeight;
    }

    public boolean onDown(MotionEvent e) {
        if (this.mOnTouchGestureListener != null) {
            this.mOnTouchGestureListener.onDown(e);
        }
        return true;
    }

    public void setGestureSize(int width, int height) {
        this.mGestureWidth = width;
        this.mGestureHeight = height;
    }

    public void cancel() {
        if (this.mOnTouchGestureListener != null) {
            this.mOnTouchGestureListener.onScrollCancel();
        }
        this.mInHorizontalMoving = false;
        this.mInVerticalMoving = false;
    }

    public boolean onUp(MotionEvent e) {
        float startX = e.getX();
        float startY = e.getY();
        this.endHorizontalDrag((Pair<Float, Float>)new Pair((Object)Float.valueOf(startX), (Object)Float.valueOf(startY)));
        if (this.mInHorizontalMoving) {
            this.mInHorizontalMoving = false;
        }
        if (this.mInVerticalMoving) {
            this.mInVerticalMoving = false;
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return this.mOnTouchGestureListener != null ? this.mOnTouchGestureListener.onSingleTapConfirmed() : super.onSingleTapConfirmed(e);
    }

    public boolean onDoubleTap(MotionEvent e) {
        return this.mOnTouchGestureListener != null ? this.mOnTouchGestureListener.onDoubleTap(e) : super.onDoubleTap(e);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return this.handleScroll(e1, e2, distanceX, distanceY) || super.onScroll(e1, e2, distanceX, distanceY);
    }

    public void onLongPress(MotionEvent e) {
        if (this.mOnTouchGestureListener != null) {
            this.mOnTouchGestureListener.onLongPress(e);
        }
    }

    private boolean handleScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (e1 == null || e2 == null) {
            return false;
        }
        float startX = e1.getX();
        if (startX < (float)this.mGestureWidth * 0.01f || startX > (float)this.mGestureWidth * 0.95f) {
            return true;
        }
        float startY = e1.getY();
        if (startY < (float)this.mGestureHeight * 0.1f || startY > (float)this.mGestureHeight * 0.95f) {
            return true;
        }
        boolean consumed = false;
        float moveDelta = Math.abs(distanceY) - Math.abs(distanceX);
        if (moveDelta > 0.0f) {
            consumed = this.onVerticalMove(e1, e2, distanceX, distanceY);
        } else if (moveDelta < 0.0f) {
            consumed = this.onHorizontalMove(e1, e2, distanceX, distanceY);
        }
        return consumed;
    }

    private boolean onHorizontalMove(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mInVerticalMoving || !this.mEnableHorizontalGesture) {
            return false;
        }
        float deltaFactorX = this.getDeltaFactorX(e1, e2);
        if (Math.abs(deltaFactorX) < 0.05f && !this.mInHorizontalMoving) {
            return false;
        }
        int e1PointerCount = e1.getPointerCount();
        int e2PointerCount = e2.getPointerCount();
        int pointerCount = Math.max(e1PointerCount, e2PointerCount);
        if (!this.mInHorizontalMoving) {
            this.beginHorizontalDrag(deltaFactorX, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e1.getX()), (Object)Float.valueOf(e1.getY())));
        }
        float endX = e2.getX();
        float endY = e2.getY();
        this.horizontalDag(deltaFactorX, pointerCount, (Pair<Float, Float>)new Pair((Object)Float.valueOf(endX), (Object)Float.valueOf(endY)));
        if (!this.mInHorizontalMoving) {
            this.mInHorizontalMoving = true;
        }
        return false;
    }

    private void beginHorizontalDrag(float progress, Pair<Float, Float> point) {
        this.mProgressFactor = progress;
        this.onStartTrackingTouch(1, progress, point);
    }

    private void horizontalDag(float progress, int pointerCount, Pair<Float, Float> point) {
        this.mProgressFactor += progress;
        this.onProgressChanged(1, progress, pointerCount, point);
    }

    private void endHorizontalDrag(Pair<Float, Float> point) {
        if (this.mInHorizontalMoving || this.mInVerticalMoving) {
            this.onStopTrackingTouch(this.mCurrentAction, this.mProgressFactor, point);
        }
    }

    private void onStartTrackingTouch(int action, float progress, Pair<Float, Float> point) {
        if (this.mOnTouchGestureListener != null) {
            this.mOnTouchGestureListener.onScrollStart(action, progress, point);
        }
    }

    private void onProgressChanged(int action, float progress, int pointerCount, Pair<Float, Float> point) {
        this.mCurrentAction = action;
        if (this.mOnTouchGestureListener != null) {
            this.mOnTouchGestureListener.onScroll(action, progress, pointerCount, point);
        }
    }

    private void onStopTrackingTouch(int action, float progress, Pair<Float, Float> point) {
        if (this.mOnTouchGestureListener != null) {
            this.mOnTouchGestureListener.onScrollStop(action, progress, point);
        }
    }

    private boolean onVerticalMove(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mInHorizontalMoving) {
            return false;
        }
        int e1PointerCount = e1.getPointerCount();
        int e2PointerCount = e2.getPointerCount();
        int pointerCount = Math.max(e1PointerCount, e2PointerCount);
        float startX1 = e1.getX();
        float startX2 = e2.getX();
        int gestureWidth = this.mGestureWidth;
        float left = (float)gestureWidth / 3.0f;
        float right = left * 2.0f;
        if (startX1 < left && startX2 < left) {
            float diffFactor = this.getDeltaFactorY(e1, e2);
            if (!this.mInVerticalMoving) {
                this.mInVerticalMoving = true;
                this.onStartTrackingTouch(5, diffFactor, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e1.getX()), (Object)Float.valueOf(e1.getY())));
            }
            this.onProgressChanged(5, diffFactor, pointerCount, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e2.getX()), (Object)Float.valueOf(e2.getY())));
        } else if (startX1 > right && startX2 > right) {
            float diffFactor = this.getDeltaFactorY(e1, e2);
            if (!this.mInVerticalMoving) {
                this.mInVerticalMoving = true;
                this.onStartTrackingTouch(6, diffFactor, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e1.getX()), (Object)Float.valueOf(e1.getY())));
            }
            this.onProgressChanged(6, diffFactor, pointerCount, (Pair<Float, Float>)new Pair((Object)Float.valueOf(e2.getX()), (Object)Float.valueOf(e2.getY())));
        }
        return false;
    }

    private float getDeltaFactorX(MotionEvent e1, MotionEvent e2) {
        int rangeX = this.mGestureWidth;
        if (rangeX <= 0) {
            return 0.0f;
        }
        float deltaX = e2.getX() - e1.getX();
        return deltaX / (float)rangeX;
    }

    private float getDeltaFactorY(MotionEvent e1, MotionEvent e2) {
        int rangeY = this.mGestureHeight;
        if (rangeY <= 0) {
            return 0.0f;
        }
        float deltaY = e2.getY() - e1.getY();
        return deltaY / (float)rangeY;
    }

    void onTouch(MotionEvent ev) {
        if (this.mOnTouchGestureListener != null) {
            this.mOnTouchGestureListener.onTouch(ev);
        }
    }

    void setHorizontalGestureEnabled(boolean enabled) {
        this.mEnableHorizontalGesture = enabled;
    }

    public void setTouchGestureListener(PlayerGestureView.OnTouchGestureListener onTouchGestureListener) {
        this.mOnTouchGestureListener = onTouchGestureListener;
    }
}

