/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.layer.gesture.detector;

import android.util.Log;
import android.view.MotionEvent;

public class RotateGestureDetector {
    private static final String TAG = RotateGestureDetector.class.getSimpleName();
    private OnRotateGestureListener mListener;
    private MotionEvent mPrevEvent;
    private MotionEvent mCurrEvent;
    private double mPrevFingerDiffX;
    private double mPrevFingerDiffY;
    private double mCurrFingerDiffX;
    private double mCurrFingerDiffY;
    private boolean mInProgress;
    private int rotateIndex1 = 0;
    private int rotateIndex2 = 1;

    public RotateGestureDetector(OnRotateGestureListener listener) {
        this.mListener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            return this.mListener != null && this.handleEvent(event);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return false;
        }
    }

    private boolean handleEvent(MotionEvent event) {
        boolean streamComplete;
        int action = event.getActionMasked();
        boolean bl = streamComplete = action == 1 || action == 3;
        if (action == 0 || streamComplete) {
            if (this.mInProgress) {
                this.mListener.onRotateEnd(this);
            }
            this.reset();
            return true;
        }
        int count = event.getPointerCount();
        if (action == 6) {
            if (count < 2) {
                if (this.mInProgress) {
                    this.mListener.onRotateEnd(this);
                }
                this.reset();
            } else {
                this.updateRotateIndex(event);
                this.mPrevEvent = null;
            }
            return true;
        }
        if (action == 5) {
            this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
            this.updateRotateIndex(event);
            this.updateStateByEvent(event);
            this.mInProgress = this.mListener.onRotateBegin(this);
        }
        if (action == 2 && count >= 2) {
            if (this.mPrevEvent == null) {
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
            }
            this.updateStateByEvent(event);
            if (this.mListener.onRotate(this)) {
                this.mPrevEvent.recycle();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
            }
        }
        return true;
    }

    private void updateRotateIndex(MotionEvent event) {
        int pointerUpIndex;
        int count = event.getPointerCount();
        int n = pointerUpIndex = event.getActionMasked() == 6 ? event.getActionIndex() : Integer.MAX_VALUE;
        if (count <= 2) {
            this.rotateIndex1 = 0;
            this.rotateIndex2 = 1;
            return;
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = 0.0f;
        float maxY = 0.0f;
        int minXIndex = 0;
        int minYIndex = 0;
        int maxXIndex = 0;
        int maxYIndex = 0;
        for (int i = 0; i < count; ++i) {
            if (i == pointerUpIndex) continue;
            float x = event.getX(i);
            float y = event.getY(i);
            if (x <= minX) {
                minX = x;
                minXIndex = i;
            }
            if (x >= maxX) {
                maxX = x;
                maxXIndex = i;
            }
            if (y <= minY) {
                minY = y;
                minYIndex = i;
            }
            if (!(y >= maxY)) continue;
            maxY = y;
            maxYIndex = i;
        }
        if (maxX - minX > maxY - minY) {
            this.rotateIndex1 = minXIndex >= pointerUpIndex ? minXIndex - 1 : minXIndex;
            this.rotateIndex2 = maxXIndex >= pointerUpIndex ? maxXIndex - 1 : maxXIndex;
        } else {
            this.rotateIndex1 = minYIndex >= pointerUpIndex ? minYIndex - 1 : minYIndex;
            this.rotateIndex2 = maxYIndex >= pointerUpIndex ? maxYIndex - 1 : maxYIndex;
        }
    }

    private void updateStateByEvent(MotionEvent event) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)event);
        MotionEvent prev = this.mPrevEvent;
        MotionEvent curr = this.mCurrEvent;
        float prevX0 = prev.getX(this.rotateIndex1);
        float prevY0 = prev.getY(this.rotateIndex1);
        float prevX1 = prev.getX(this.rotateIndex2);
        float prevY1 = prev.getY(this.rotateIndex2);
        float prevXDistance = prevX1 - prevX0;
        float prevYDistance = prevY1 - prevY0;
        this.mPrevFingerDiffX = prevXDistance;
        this.mPrevFingerDiffY = prevYDistance;
        float currX0 = curr.getX(this.rotateIndex1);
        float currY0 = curr.getY(this.rotateIndex1);
        float currX1 = curr.getX(this.rotateIndex2);
        float currY1 = curr.getY(this.rotateIndex2);
        float currXDistance = currX1 - currX0;
        float currYDistance = currY1 - currY0;
        this.mCurrFingerDiffX = currXDistance;
        this.mCurrFingerDiffY = currYDistance;
    }

    public boolean isInProgress() {
        return this.mInProgress;
    }

    public float getDegree() {
        double diffRadians = Math.atan2(this.mCurrFingerDiffY, this.mCurrFingerDiffX) - Math.atan2(this.mPrevFingerDiffY, this.mPrevFingerDiffX);
        return (float)(diffRadians * 180.0 / Math.PI);
    }

    private void reset() {
        this.mInProgress = false;
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
    }

    public static interface OnRotateGestureListener {
        public boolean onRotateBegin(RotateGestureDetector var1);

        public boolean onRotate(RotateGestureDetector var1);

        public void onRotateEnd(RotateGestureDetector var1);
    }

    public static abstract class SimpleRotateGestureListener
    implements OnRotateGestureListener {
        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            return false;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
        }
    }
}

