/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.layer.toast;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.qiniu.qplayer2ext.common.measure.DpUtils;
import com.qiniu.qplayer2ext.commonplayer.data.DisplayOrientation;
import com.qiniu.qplayer2ext.commonplayer.layer.IPlayerLayer;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.IPlayerToastContainer;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.PlayerToast;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.center.CenterToastView;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.left.LeftToastView;
import com.qiniu.qplayer2ext.commonplayer.screen.ScreenType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\r\u0010\u001f\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/PlayerToastContainer;", "Lcom/qiniu/qplayer2ext/commonplayer/layer/IPlayerLayer;", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/IPlayerToastContainer;", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCenterToastView", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/center/CenterToastView;", "mCurrentDisplayOrientation", "Lcom/qiniu/qplayer2ext/commonplayer/data/DisplayOrientation;", "mCurrentScreenType", "Lcom/qiniu/qplayer2ext/commonplayer/screen/ScreenType;", "mIsReleased", "", "mLeftToastView", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/left/LeftToastView;", "mMainHandler", "Landroid/os/Handler;", "mPaddingRect", "Landroid/graphics/Rect;", "mToastRootViewFL", "Landroid/widget/FrameLayout;", "dismissToast", "", "toast", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/PlayerToast;", "getView", "Landroid/view/View;", "refreshToast", "screenType", "displayOrientation", "release", "release$qplayer2_ext_1_4_1_release", "setPadding", "rect", "showToast", "Companion", "qplayer2-ext-1.4.1_release"})
public final class PlayerToastContainer
implements IPlayerLayer,
IPlayerToastContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context mContext;
    @NotNull
    private Handler mMainHandler;
    @NotNull
    private final FrameLayout mToastRootViewFL;
    @NotNull
    private final LeftToastView mLeftToastView;
    @NotNull
    private final CenterToastView mCenterToastView;
    @NotNull
    private ScreenType mCurrentScreenType;
    @NotNull
    private DisplayOrientation mCurrentDisplayOrientation;
    private boolean mIsReleased;
    @Nullable
    private Rect mPaddingRect;
    private static final int LANDSCAPE_FULLSCREEN_BOTTOM_PADDING = DpUtils.INSTANCE.dpToPx(96);
    private static final int VERTICAL_FULLSCREEN_BOTTOM_PADDING = DpUtils.INSTANCE.dpToPx(238);
    private static final int THUMB_BOTTOM_PADDING = DpUtils.INSTANCE.dpToPx(36);
    private static final int WINDOW_INSET_LEFT_PADDING = DpUtils.INSTANCE.dpToPx(8);

    public PlayerToastContainer(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mToastRootViewFL = new FrameLayout(this.mContext);
        this.mLeftToastView = new LeftToastView(this.mContext, (ViewGroup)this.mToastRootViewFL, this.mMainHandler);
        this.mCenterToastView = new CenterToastView(this.mContext, (ViewGroup)this.mToastRootViewFL);
        this.mCurrentScreenType = ScreenType.NONE;
        this.mCurrentDisplayOrientation = DisplayOrientation.NONE;
        this.refreshToast(ScreenType.HALF_SCREEN, DisplayOrientation.LANDSCAPE);
    }

    @Override
    @NotNull
    public View getView() {
        return (View)this.mToastRootViewFL;
    }

    @Override
    public void showToast(@NotNull PlayerToast toast) {
        Intrinsics.checkNotNullParameter((Object)toast, (String)"toast");
        if (this.mIsReleased) {
            return;
        }
        int n = toast.getLocation();
        switch (n) {
            case 32: {
                this.mLeftToastView.addToast(toast);
                break;
            }
            case 33: {
                this.mCenterToastView.showToast(toast);
            }
        }
    }

    @Override
    public void setPadding(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.mPaddingRect = rect;
        this.mToastRootViewFL.setPadding(rect.left, rect.top, rect.right, rect.bottom);
    }

    @Override
    public void dismissToast(@NotNull PlayerToast toast) {
        Intrinsics.checkNotNullParameter((Object)toast, (String)"toast");
        if (toast.getLocation() == 32) {
            this.mLeftToastView.removeToast(toast);
        } else if (toast.getLocation() == 33) {
            this.mCenterToastView.dismiss();
        }
    }

    @Override
    public void refreshToast(@NotNull ScreenType screenType, @NotNull DisplayOrientation displayOrientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)screenType), (String)"screenType");
        Intrinsics.checkNotNullParameter((Object)((Object)displayOrientation), (String)"displayOrientation");
        if (this.mCurrentScreenType == screenType && this.mCurrentDisplayOrientation == displayOrientation) {
            return;
        }
        this.mCurrentScreenType = screenType;
        this.mCurrentDisplayOrientation = displayOrientation;
        if ((this.mCurrentScreenType == ScreenType.REVERSE_FULL_SCREEN || this.mCurrentScreenType == ScreenType.FULL_SCREEN) && this.mCurrentDisplayOrientation == DisplayOrientation.LANDSCAPE) {
            this.mLeftToastView.scale(1.0f);
            if (this.mPaddingRect == null) {
                this.mToastRootViewFL.setPadding(0, 0, 0, LANDSCAPE_FULLSCREEN_BOTTOM_PADDING);
            }
            this.mCenterToastView.scale(1.0f);
        } else if ((this.mCurrentScreenType == ScreenType.REVERSE_FULL_SCREEN || this.mCurrentScreenType == ScreenType.FULL_SCREEN) && this.mCurrentDisplayOrientation == DisplayOrientation.VERTICAL) {
            this.mLeftToastView.scale(1.0f);
            if (this.mPaddingRect == null) {
                this.mToastRootViewFL.setPadding(0, 0, 0, VERTICAL_FULLSCREEN_BOTTOM_PADDING);
            }
            this.mCenterToastView.scale(1.0f);
        } else if (this.mCurrentScreenType == ScreenType.HALF_SCREEN) {
            this.mLeftToastView.scale(0.8f);
            if (this.mPaddingRect == null) {
                this.mToastRootViewFL.setPadding(0, 0, 0, THUMB_BOTTOM_PADDING);
            }
            this.mCenterToastView.scale(0.8f);
        }
    }

    public final void release$qplayer2_ext_1_4_1_release() {
        this.mIsReleased = true;
        this.mLeftToastView.removeAll();
        this.mCenterToastView.release();
        this.mMainHandler.removeCallbacksAndMessages(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/PlayerToastContainer$Companion;", "", "()V", "LANDSCAPE_FULLSCREEN_BOTTOM_PADDING", "", "THUMB_BOTTOM_PADDING", "VERTICAL_FULLSCREEN_BOTTOM_PADDING", "WINDOW_INSET_LEFT_PADDING", "qplayer2-ext-1.4.1_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

