/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.layer.toast.center;

import android.content.Context;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.qiniu.qplayer2ext.R;
import com.qiniu.qplayer2ext.common.measure.DpUtils;
import com.qiniu.qplayer2ext.common.thread.HandlerThreads;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.AbsScaleableToastView;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.PlayerToast;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.PlayerToastConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/center/CenterToastView;", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/AbsScaleableToastView;", "context", "Landroid/content/Context;", "rootView", "Landroid/view/ViewGroup;", "(Landroid/content/Context;Landroid/view/ViewGroup;)V", "mLayoutParams", "Landroid/widget/FrameLayout$LayoutParams;", "mParentView", "Landroid/widget/FrameLayout;", "mTipTextView", "Landroid/widget/TextView;", "mToastDismissRunnable", "Ljava/lang/Runnable;", "mViewRoot", "Landroid/view/View;", "dismiss", "", "release", "scaleRootView", "showToast", "toast", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/PlayerToast;", "qplayer2-ext-1.4.1_release"})
public final class CenterToastView
extends AbsScaleableToastView {
    @Nullable
    private final View mViewRoot;
    @Nullable
    private final TextView mTipTextView;
    @NotNull
    private final FrameLayout mParentView;
    @NotNull
    private FrameLayout.LayoutParams mLayoutParams;
    @NotNull
    private final Runnable mToastDismissRunnable;

    public CenterToastView(@NotNull Context context, @NotNull ViewGroup rootView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        this.mParentView = (FrameLayout)rootView;
        this.mToastDismissRunnable = () -> CenterToastView.mToastDismissRunnable$lambda-0(this);
        Object object = context.getSystemService("layout_inflater");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater layoutInflater = (LayoutInflater)object;
        this.mViewRoot = layoutInflater.inflate(R.layout.toast_message_common_player_normal, (ViewGroup)this.mParentView, false);
        int dp44 = DpUtils.INSTANCE.dpToPx(44);
        this.mLayoutParams = new FrameLayout.LayoutParams(-2, dp44);
        this.mLayoutParams.gravity = 17;
        this.mParentView.addView(this.mViewRoot, (ViewGroup.LayoutParams)this.mLayoutParams);
        View view = this.mViewRoot;
        Intrinsics.checkNotNull((Object)view);
        view.setVisibility(4);
        this.mTipTextView = (TextView)this.mViewRoot.findViewById(R.id.message);
    }

    public final void showToast(@Nullable PlayerToast toast) {
        if (toast == null || this.mViewRoot == null || this.mTipTextView == null) {
            return;
        }
        String text = PlayerToastConfig.getTitle(toast);
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.mTipTextView.setText((CharSequence)text);
        int titleSize = toast.getExtraIntValue("extra_title_size");
        if (titleSize > 0) {
            this.mTipTextView.setTextSize((float)titleSize);
        } else {
            this.mTipTextView.setTextSize(14.0f);
        }
        TextPaint tp = this.mTipTextView.getPaint();
        tp.setFakeBoldText(PlayerToastConfig.getTitleBold(toast, false));
        int bgResId = toast.getExtraIntValue("extra_background_drawable_res_id");
        if (bgResId > 0) {
            this.mViewRoot.setBackgroundResource(bgResId);
        } else {
            this.mViewRoot.setBackgroundResource(R.drawable.shape_roundrect_player_black);
        }
        HandlerThreads.remove(0, this.mToastDismissRunnable);
        if (toast.getDuration() != 100000L) {
            HandlerThreads.postDelayed(0, this.mToastDismissRunnable, toast.getDuration());
        }
        this.scaleRootView();
        this.mViewRoot.setVisibility(0);
    }

    public final void dismiss() {
        if (this.mViewRoot == null || this.mTipTextView == null) {
            return;
        }
        this.mViewRoot.setVisibility(4);
    }

    public final void release() {
        HandlerThreads.remove(0, this.mToastDismissRunnable);
    }

    @Override
    public void scaleRootView() {
        if (this.mViewRoot != null) {
            ViewCompat.setScaleX((View)this.mViewRoot, (float)this.getMScaleFactor());
            ViewCompat.setScaleY((View)this.mViewRoot, (float)this.getMScaleFactor());
        }
    }

    private static final void mToastDismissRunnable$lambda-0(CenterToastView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.dismiss();
    }
}

