/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.layer.toast.left;

import android.os.Handler;
import android.util.Log;
import android.view.ViewGroup;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.PlayerToast;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.left.AbsToastListAdapter;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.left.AbsToastViewHolder;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.left.viewholder.ActionMessageVH;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.left.viewholder.ActionMessageWithAnimationVH;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.left.viewholder.CustomMessageVH;
import com.qiniu.qplayer2ext.commonplayer.layer.toast.left.viewholder.NormalMessageVH;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u001e\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/left/ToastRecyclerViewAdapter;", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/left/AbsToastListAdapter;", "handler", "Landroid/os/Handler;", "(Landroid/os/Handler;)V", "createToastViewHolder", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/left/AbsToastViewHolder;", "parent", "Landroid/view/ViewGroup;", "viewType", "", "dispatchToastAdd", "", "list", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/qiniu/qplayer2ext/commonplayer/layer/toast/PlayerToast;", "toast", "loopToastState", "qplayer2-ext-1.4.1_release"})
public final class ToastRecyclerViewAdapter
extends AbsToastListAdapter {
    public ToastRecyclerViewAdapter(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super(handler);
    }

    @Override
    public void loopToastState(@NotNull CopyOnWriteArrayList<PlayerToast> list, @NotNull PlayerToast toast) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)toast, (String)"toast");
        if (toast.getDuration() == 100000L) {
            long diff;
            if (toast.getRefreshDuration() > -1L && (diff = PlayerToast.Companion.generateCreateTimeMillis() - toast.getCreateTime()) >= toast.getRefreshDuration()) {
                toast.setRefreshDuration(-1L);
                int index = list.indexOf(toast);
                this.notifyItemChanged(index);
            }
        } else {
            long diff = PlayerToast.Companion.generateCreateTimeMillis() - toast.getCreateTime();
            long index = toast.getRefreshDuration();
            boolean bl = 0L <= index ? index <= diff : false;
            if (bl) {
                toast.setRefreshDuration(-1L);
                int index2 = list.indexOf(toast);
                this.notifyItemChanged(index2);
            } else if (diff >= toast.getDuration()) {
                int index3 = list.indexOf(toast);
                list.remove(index3);
                this.notifyItemRemoved(index3);
            }
        }
    }

    @Override
    public void dispatchToastAdd(@NotNull CopyOnWriteArrayList<PlayerToast> list, @Nullable PlayerToast toast) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        int size = list.size();
        PlayerToast playerToast = toast;
        Intrinsics.checkNotNull((Object)playerToast);
        if (playerToast.getQueueType() == 49) {
            switch (size) {
                case 0: {
                    this.insertToastToQueue(0, toast);
                    break;
                }
                case 1: {
                    PlayerToast p0 = list.get(0);
                    if (toast.getToastType() == p0.getToastType()) {
                        this.refreshToastItem(0, toast);
                        break;
                    }
                    if (toast.getLevel() >= p0.getLevel()) {
                        this.insertToastToQueue(1, toast);
                        break;
                    }
                    this.insertToastToQueue(0, toast);
                    break;
                }
                case 2: {
                    PlayerToast p0 = list.get(0);
                    PlayerToast p1 = list.get(1);
                    if (toast.getToastType() == p0.getToastType()) {
                        this.refreshToastItem(0, toast);
                        break;
                    }
                    if (toast.getToastType() == p1.getToastType()) {
                        this.refreshToastItem(1, toast);
                        break;
                    }
                    if (toast.getLevel() < p0.getLevel()) {
                        this.insertToastToQueue(0, toast);
                        break;
                    }
                    if (toast.getLevel() < p1.getLevel()) {
                        this.insertToastToQueue(1, toast);
                        break;
                    }
                    this.insertToastToQueue(2, toast);
                    break;
                }
                case 3: {
                    PlayerToast p0 = list.get(0);
                    PlayerToast p1 = list.get(1);
                    PlayerToast p2 = list.get(2);
                    if (toast.getToastType() == p0.getToastType()) {
                        this.refreshToastItem(0, toast);
                        break;
                    }
                    if (toast.getToastType() == p1.getToastType()) {
                        this.refreshToastItem(1, toast);
                        break;
                    }
                    if (toast.getToastType() == p2.getToastType()) {
                        this.refreshToastItem(2, toast);
                        break;
                    }
                    if (toast.getLevel() < p0.getLevel()) {
                        Log.d((String)this.getTag(), (String)"refresh : max Toast exist, current level is not enough to show!");
                        break;
                    }
                    if (p0.getDuration() == 100000L) {
                        this.removeForeverToastTemporary();
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)p0, (String)"p0");
                        this.removeToast(p0, false);
                    }
                    if (toast.getLevel() < p1.getLevel()) {
                        this.insertToastToQueue(0, toast);
                        break;
                    }
                    if (toast.getLevel() < p2.getLevel()) {
                        this.insertToastToQueue(1, toast);
                        break;
                    }
                    this.insertToastToQueue(2, toast);
                }
            }
        } else if (toast.getQueueType() == 48) {
            switch (size) {
                case 0: {
                    this.insertToastToQueue(0, toast);
                    break;
                }
                case 1: {
                    PlayerToast p0 = list.get(0);
                    if (toast.getLevel() >= p0.getLevel()) {
                        this.insertToastToQueue(1, toast);
                        break;
                    }
                    this.insertToastToQueue(0, toast);
                    break;
                }
                case 2: {
                    PlayerToast p0 = list.get(0);
                    PlayerToast p1 = list.get(1);
                    if (toast.getLevel() < p0.getLevel()) {
                        Log.d((String)this.getTag(), (String)"insert : max Toast exist, current level is not enough to show!");
                        break;
                    }
                    if (p0.getDuration() == 100000L) {
                        this.removeForeverToastTemporary();
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)p0, (String)"p0");
                        this.removeToast(p0, false);
                    }
                    if (toast.getLevel() < p1.getLevel()) {
                        this.insertToastToQueue(0, toast);
                        break;
                    }
                    this.insertToastToQueue(1, toast);
                }
            }
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"toast queue type must use the defined value in PlayerToastConfig! but current type is", (Object)toast.getQueueType()));
        }
    }

    @Override
    @NotNull
    public AbsToastViewHolder createToastViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int n = viewType;
        switch (n) {
            case 17: {
                return NormalMessageVH.Companion.create(parent);
            }
            case 18: {
                return ActionMessageVH.Companion.create(parent);
            }
            case 19: {
                return CustomMessageVH.Companion.create(parent);
            }
            case 21: {
                return ActionMessageWithAnimationVH.Companion.create(parent);
            }
        }
        return NormalMessageVH.Companion.create(parent);
    }
}

